/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans;

import datechooser.beans.editor.ModelBehaviorEditor;
import datechooser.beans.editor.NavigatePaneEditor;
import datechooser.beans.editor.SimpleColorEditor;
import datechooser.beans.editor.WeekDaysStyleEditor;
import datechooser.beans.editor.appear.AppearEditor;
import datechooser.beans.editor.dates.DateEditor;
import datechooser.beans.editor.dates.PeriodsEditor;
import datechooser.beans.editor.dimension.SimpleDimensionEditor;
import datechooser.beans.editor.font.SimpleFontEditor;
import datechooser.beans.editor.locale.LocaleEditor;
import datechooser.beans.locale.LocaleUtils;
import datechooser.events.CommitListener;
import datechooser.events.CursorMoveListener;
import datechooser.events.SelectionChangedListener;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateChooserBeanInfo
extends SimpleBeanInfo {
    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        try {
            EventSetDescriptor commit = new EventSetDescriptor(this.getBeanClass(), "commit", CommitListener.class, "onCommit");
            commit.setDisplayName(LocaleUtils.getCalendarLocaleString("commit"));
            commit.setShortDescription(LocaleUtils.getCalendarLocaleString("commit_descript"));
            EventSetDescriptor selChanged = new EventSetDescriptor(this.getBeanClass(), "selectionChanged", SelectionChangedListener.class, "onSelectionChange");
            selChanged.setDisplayName(LocaleUtils.getCalendarLocaleString("selChange"));
            selChanged.setShortDescription(LocaleUtils.getCalendarLocaleString("selChange_descript"));
            EventSetDescriptor cursorMoved = new EventSetDescriptor(this.getBeanClass(), "cursorMove", CursorMoveListener.class, "onCursorMove");
            cursorMoved.setDisplayName(LocaleUtils.getCalendarLocaleString("onCursorMove"));
            cursorMoved.setShortDescription(LocaleUtils.getCalendarLocaleString("onCursorMove_descript"));
            return new EventSetDescriptor[]{commit, selChanged, cursorMoved};
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        try {
            PropertyDescriptor defDate = new PropertyDescriptor("dch_defaultDates", this.getBeanClass(), "getDefaultPeriods", "setDefaultPeriods");
            defDate.setPropertyEditorClass(PeriodsEditor.class);
            defDate.setDisplayName(LocaleUtils.getCalendarLocaleString("Default"));
            defDate.setShortDescription(LocaleUtils.getCalendarLocaleString("Default_descript"));
            descriptors.add(defDate);
            PropertyDescriptor calSize = new PropertyDescriptor("dch_calSize", this.getBeanClass(), "getCalendarPreferredSize", "setCalendarPreferredSize");
            calSize.setPropertyEditorClass(SimpleDimensionEditor.class);
            calSize.setDisplayName(LocaleUtils.getCalendarLocaleString("Calend_size"));
            calSize.setShortDescription(LocaleUtils.getCalendarLocaleString("Calend_size_descript"));
            descriptors.add(calSize);
            PropertyDescriptor forbidDate = new PropertyDescriptor("dch_forbidDates", this.getBeanClass(), "getForbiddenPeriods", "setForbiddenPeriods");
            forbidDate.setPropertyEditorClass(PeriodsEditor.class);
            forbidDate.setDisplayName(LocaleUtils.getCalendarLocaleString("Forbidden"));
            forbidDate.setShortDescription(LocaleUtils.getCalendarLocaleString("Forbidden_descript"));
            descriptors.add(forbidDate);
            PropertyDescriptor maxDate = new PropertyDescriptor("dch_maxDate", this.getBeanClass(), "getMaxDate", "setMaxDate");
            maxDate.setPropertyEditorClass(DateEditor.class);
            maxDate.setDisplayName(LocaleUtils.getCalendarLocaleString("Maximal_date"));
            maxDate.setShortDescription(LocaleUtils.getCalendarLocaleString("Maximal_date_descript"));
            descriptors.add(maxDate);
            PropertyDescriptor minDate = new PropertyDescriptor("dch_minDate", this.getBeanClass(), "getMinDate", "setMinDate");
            minDate.setPropertyEditorClass(DateEditor.class);
            minDate.setDisplayName(LocaleUtils.getCalendarLocaleString("Minimal_date"));
            minDate.setShortDescription(LocaleUtils.getCalendarLocaleString("Minimal_date_descript"));
            descriptors.add(minDate);
            PropertyDescriptor autoScroll = new PropertyDescriptor("dch_autoScroll", this.getBeanClass(), "isAutoScroll", "setAutoScroll");
            autoScroll.setDisplayName(LocaleUtils.getCalendarLocaleString("Auto_scroll"));
            autoScroll.setShortDescription(LocaleUtils.getCalendarLocaleString("Auto_scroll_descript"));
            descriptors.add(autoScroll);
            PropertyDescriptor oneMonth = new PropertyDescriptor("dch_oneMonth", this.getBeanClass(), "isShowOneMonth", "setShowOneMonth");
            oneMonth.setDisplayName(LocaleUtils.getCalendarLocaleString("Show_one_month"));
            oneMonth.setShortDescription(LocaleUtils.getCalendarLocaleString("Show_one_month_descript"));
            descriptors.add(oneMonth);
            PropertyDescriptor enabled = new PropertyDescriptor("dch_enabled", this.getBeanClass(), "isEnabled", "setEnabled");
            enabled.setDisplayName(LocaleUtils.getCalendarLocaleString("Enabled"));
            enabled.setShortDescription(LocaleUtils.getCalendarLocaleString("Enabled_descript"));
            descriptors.add(enabled);
            PropertyDescriptor locked = new PropertyDescriptor("dch_locked", this.getBeanClass(), "isLocked", "setLocked");
            locked.setDisplayName(LocaleUtils.getCalendarLocaleString("Locked"));
            locked.setShortDescription(LocaleUtils.getCalendarLocaleString("Locked_descript"));
            descriptors.add(locked);
            PropertyDescriptor nothingAllowed = new PropertyDescriptor("dch_nothingAllowed", this.getBeanClass(), "isNothingAllowed", "setNothingAllowed");
            nothingAllowed.setDisplayName(LocaleUtils.getCalendarLocaleString("NothingAllowed"));
            nothingAllowed.setShortDescription(LocaleUtils.getCalendarLocaleString("NothingAllowed_descript"));
            descriptors.add(nothingAllowed);
            PropertyDescriptor navFont = new PropertyDescriptor("dch_navFont", this.getBeanClass(), "getNavigateFont", "setNavigateFont");
            navFont.setPropertyEditorClass(SimpleFontEditor.class);
            navFont.setDisplayName(LocaleUtils.getCalendarLocaleString("Navig_font"));
            navFont.setShortDescription(LocaleUtils.getCalendarLocaleString("Navig_font_descript"));
            descriptors.add(navFont);
            PropertyDescriptor behavior = new PropertyDescriptor("dch_behavior", this.getBeanClass(), "getBehavior", "setBehavior");
            behavior.setPropertyEditorClass(ModelBehaviorEditor.class);
            behavior.setDisplayName(LocaleUtils.getCalendarLocaleString("Behavior"));
            behavior.setShortDescription(LocaleUtils.getCalendarLocaleString("Behavior_descript"));
            descriptors.add(behavior);
            PropertyDescriptor weekDayStyle = new PropertyDescriptor("dch_weekDayStyle", this.getBeanClass(), "getWeekStyle", "setWeekStyle");
            weekDayStyle.setPropertyEditorClass(WeekDaysStyleEditor.class);
            weekDayStyle.setDisplayName(LocaleUtils.getCalendarLocaleString("WeekDayStyle"));
            weekDayStyle.setShortDescription(LocaleUtils.getCalendarLocaleString("WeekDayStyle_descript"));
            descriptors.add(weekDayStyle);
            PropertyDescriptor view = new PropertyDescriptor("dch_view", this.getBeanClass(), "getCurrentView", "setCurrentView");
            view.setPropertyEditorClass(AppearEditor.class);
            view.setDisplayName(LocaleUtils.getCalendarLocaleString("View"));
            view.setShortDescription(LocaleUtils.getCalendarLocaleString("View_descript"));
            descriptors.add(view);
            PropertyDescriptor locale = new PropertyDescriptor("dch_locale", this.getBeanClass(), "getLocale", "setLocale");
            locale.setPropertyEditorClass(LocaleEditor.class);
            locale.setDisplayName(LocaleUtils.getCalendarLocaleString("Locale"));
            locale.setShortDescription(LocaleUtils.getCalendarLocaleString("Locale_descript"));
            descriptors.add(locale);
            PropertyDescriptor navigPane = new PropertyDescriptor("dch_navigPane", this.getBeanClass(), "getCurrentNavigateIndex", "setCurrentNavigateIndex");
            navigPane.setPropertyEditorClass(NavigatePaneEditor.class);
            navigPane.setDisplayName(LocaleUtils.getCalendarLocaleString("NavigatePane"));
            navigPane.setShortDescription(LocaleUtils.getCalendarLocaleString("NavigatePane_descript"));
            descriptors.add(navigPane);
            PropertyDescriptor backColor = new PropertyDescriptor("dch_backgroundColor", this.getBeanClass(), "getCalendarBackground", "setCalendarBackground");
            backColor.setPropertyEditorClass(SimpleColorEditor.class);
            backColor.setDisplayName(LocaleUtils.getCalendarLocaleString("BackColor"));
            backColor.setShortDescription(LocaleUtils.getCalendarLocaleString("BackColor_descript"));
            descriptors.add(backColor);
            descriptors.addAll(this.getAdditionalDescriptors());
            return descriptors.toArray(new PropertyDescriptor[descriptors.size()]);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public int getDefaultPropertyIndex() {
        return 1;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor bd = new BeanDescriptor(this.getBeanClass(), this.getCustomizerClass());
        bd.setDisplayName(this.getDisplayName());
        return bd;
    }

    @Override
    public Image getIcon(int iconKind) {
        String name = "";
        switch (iconKind) {
            case 2: {
                name = "col32";
                break;
            }
            case 1: {
                name = "col16";
                break;
            }
            case 4: {
                name = "bw32";
                break;
            }
            case 3: {
                name = "bw16";
            }
        }
        return this.loadImage("/datechooser/beans/pic/" + this.getPicturePrefix() + "_" + name + ".gif");
    }

    protected abstract String getDisplayName();

    protected abstract String getPicturePrefix();

    protected abstract Class getBeanClass();

    protected abstract ArrayList<PropertyDescriptor> getAdditionalDescriptors() throws IntrospectionException;

    protected abstract Class getCustomizerClass();
}

