/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans;

import datechooser.beans.BeanTableCell;
import datechooser.beans.DateChooserVisual;
import datechooser.model.multiple.PeriodSet;
import java.awt.Color;
import java.awt.Component;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

class BeanTableCellRenderer
implements TableCellRenderer,
BeanTableCell {
    private boolean useCalendarForSingleDate;
    private DateChooserVisual bean;
    private boolean commitLocked;
    private Border selectBorder;
    private Border focusBorder;
    private Border emptyBorder;

    public BeanTableCellRenderer(DateChooserVisual bean) {
        this.setUseCalendarForSingleDate(true);
        this.bean = bean;
        this.selectBorder = BorderFactory.createLineBorder(Color.BLUE, 1);
        this.focusBorder = BorderFactory.createLineBorder(Color.BLACK, 1);
        this.emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.bean.setBorder(this.emptyBorder);
        if (isSelected) {
            this.bean.setBorder(this.selectBorder);
        }
        if (hasFocus) {
            this.bean.setBorder(this.focusBorder);
        }
        if (value instanceof Calendar) {
            Calendar cval = (Calendar)value;
            this.bean.setSelectedDate(cval);
        } else if (value instanceof PeriodSet) {
            PeriodSet pval = (PeriodSet)value;
            this.bean.setSelection(pval);
        }
        return this.bean;
    }

    public boolean isUseCalendarForSingleDate() {
        return this.useCalendarForSingleDate;
    }

    public void setUseCalendarForSingleDate(boolean useCalendarForSingleDate) {
        this.useCalendarForSingleDate = useCalendarForSingleDate;
    }
}

