/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.utils;

import datechooser.beans.editor.utils.ColorHolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JColorChooser;

public class ColorChooseAction
implements ActionListener {
    private static JColorChooser chooseColor = new JColorChooser();
    public static final String COLOR_CHOOSE_EVENT_NAME = "color";
    private ColorHolder colorHolder;
    private String prompt;
    private Component component;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public ColorChooseAction(ColorHolder colorHolder, String prompt, Component c) {
        this.setColorHolder(colorHolder);
        this.setPrompt(prompt);
        this.setComponent(c);
    }

    public void actionPerformed(ActionEvent e) {
        Color newColor = JColorChooser.showDialog(this.getComponent(), this.getPrompt(), this.getColor());
        if (newColor != null) {
            this.setColor(newColor);
            this.changeSupport.firePropertyChange(COLOR_CHOOSE_EVENT_NAME, null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Color getColor() {
        return this.colorHolder.getColor();
    }

    public ColorHolder getColorHolder() {
        return this.colorHolder;
    }

    public void setColorHolder(ColorHolder colorHolder) {
        this.colorHolder = colorHolder;
    }

    public void setColor(Color color) {
        this.colorHolder.setColor(color);
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }
}

