/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;

public class BackRenderer
implements Serializable {
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_FILL = 1;
    public static final int ALIGN_TILE = 2;
    private int style;
    private URL url;
    private transient Image image;
    private transient int imageWidth;
    private transient int imageHeight;
    private transient int timesX;
    private transient int timesY;
    private transient int i;
    private transient int j;

    public BackRenderer(int style, String imageURLPath) {
        this.style = style;
        this.initializeByString(imageURLPath);
    }

    public BackRenderer(int style, URL imageURL) {
        this(style, imageURL, null);
    }

    private void initializeByString(String URLPath) {
        File file = new File(URLPath);
        if (!file.exists()) {
            this.setNoImage();
            return;
        }
        try {
            this.url = file.toURL();
        }
        catch (MalformedURLException ex) {
            this.setNoImage();
            return;
        }
        try {
            this.setImage(ImageIO.read(this.url));
        }
        catch (IOException ex) {
            this.setNoImage();
        }
    }

    private void setNoImage() {
        this.url = null;
        this.setImage(null);
    }

    public BackRenderer(int style, URL imageURL, Image image) {
        if (image == null) {
            try {
                this.setImage(ImageIO.read(imageURL));
                this.url = imageURL;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            this.setImage(image);
            this.url = imageURL;
        }
        this.style = style;
    }

    private void setImage(Image image) {
        this.image = image;
        if (image != null) {
            this.imageWidth = image.getWidth(null);
            this.imageHeight = image.getHeight(null);
        }
    }

    public void render(Graphics2D g, Rectangle bounds) {
        if (this.image == null) {
            return;
        }
        switch (this.style) {
            case 0: {
                this.renderCentered(g, bounds);
                break;
            }
            case 1: {
                this.renderFilled(g, bounds);
                break;
            }
            case 2: {
                this.renderTiled(g, bounds);
            }
        }
    }

    private void renderCentered(Graphics2D g, Rectangle bounds) {
        g.drawImage(this.getImage(), (bounds.width - this.imageWidth) / 2, (bounds.height - this.imageHeight) / 2, this.imageWidth, this.imageHeight, null);
    }

    private void renderFilled(Graphics2D g, Rectangle bounds) {
        g.drawImage(this.getImage(), 0, 0, bounds.width, bounds.height, null);
    }

    private void renderTiled(Graphics2D g, Rectangle bounds) {
        this.timesX = bounds.width / this.imageWidth + 1;
        this.timesY = bounds.height / this.imageHeight + 1;
        for (int i = 0; i < this.timesX; ++i) {
            for (int j = 0; j < this.timesY; ++j) {
                g.drawImage(this.getImage(), i * this.imageWidth, j * this.imageHeight, this.imageWidth, this.imageHeight, null);
            }
        }
    }

    public int getStyle() {
        return this.style;
    }

    public Image getImage() {
        return this.image;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.image != null) {
            out.writeBoolean(true);
            ImageIO.write((RenderedImage)((BufferedImage)this.image), "jpg", out);
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in.readBoolean()) {
            this.setImage(ImageIO.read(in));
        }
    }

    public URL getUrl() {
        return this.url;
    }
}

