/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view.appearance.custom;

import datechooser.view.appearance.CellRenderer;
import datechooser.view.appearance.custom.CustomCellAppearance;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.border.Border;

public class CustomCellRenderer
extends CellRenderer {
    private CustomCellAppearance appearance;
    private transient Composite fillComposite;

    public CustomCellRenderer(CustomCellAppearance anAppearance) {
        this.setAppearance(anAppearance);
        this.fillComposite = AlphaComposite.getInstance(3);
    }

    public void render(Graphics2D g, Component c, String text, int width, int height, boolean isCursor) {
        Border border = this.getAppearance().getCellBorder();
        g.setColor(this.getAppearance().getBackgroundColor());
        g.fillRect(0, 0, width, height);
        g.setComposite(this.fillComposite);
        Rectangle cellRect = new Rectangle(0, 0, width, height);
        if (border != null) {
            Insets borderInsets = border.getBorderInsets(c);
            cellRect.setRect(cellRect.x + borderInsets.left, cellRect.y + borderInsets.top, cellRect.width - (borderInsets.left + borderInsets.right), cellRect.height - (borderInsets.top + borderInsets.bottom));
            border.paintBorder(c, g, 0, 0, width, height);
        }
        g.setFont(this.appearance.getFont());
        this.paintText(g, text, this.getAppearance().getTextColor(), cellRect, this.appearance.getFont());
        if (isCursor && this.getAppearance().isSelectable()) {
            this.paintCursor(g, cellRect, this.getAppearance().getCursorColor());
        }
    }

    private void paintText(Graphics2D g, String text, Color color, Rectangle rec, Font font) {
        g.setColor(color);
        FontRenderContext context = g.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(text, context);
        double x = rec.getX() + (rec.getWidth() - bounds.getWidth()) / 2.0;
        double y = rec.getY() + (rec.getHeight() - bounds.getHeight()) / 2.0;
        double ascent = -bounds.getY();
        double baseY = y + ascent;
        g.drawString(text, (int)x, (int)baseY);
    }

    public CustomCellAppearance getAppearance() {
        return this.appearance;
    }

    public void setAppearance(CustomCellAppearance appearance) {
        this.appearance = appearance;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fillComposite = AlphaComposite.getInstance(3);
    }
}

