/*
 * Decompiled with CFR 0.152.
 */
package Controladores;

import Enumeradores.NivelEnum;
import Modelos.Dao.AsistenciaBachilleratoDaoImpl;
import Modelos.Dao.CalificacionDao;
import Modelos.Dao.CalificacionDaoImpl;
import Modelos.Dao.InstructorDao;
import Modelos.Dao.InstructorDaoImpl;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.Instructor;
import Vistas.FuncionesAuxiliar;
import Vistas.VistaAsistencia;
import Vistas.VistaAsistenciaBachillerato;
import Vistas.VistaJustificarAsistencia;
import Vistas.VistaNota;
import Vistas.VistaNotaInicial;
import Vistas.VistaPrincipal;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import vo.CalificacionVO;
import vo.InfoUsuarioVO;

public class ControladorMateria
implements ActionListener {
    private final CalificacionDao calificacionDao = new CalificacionDaoImpl();
    private final InstructorDao instructorDao = new InstructorDaoImpl();
    private List<Asignacion> asignacion = new ArrayList<Asignacion>();
    private final AsistenciaBachilleratoDaoImpl asistenciaBachilleratoDaoImpl = new AsistenciaBachilleratoDaoImpl();

    public ControladorMateria() {
    }

    public ControladorMateria(final VistaPrincipal jfrParent) {
        int numeroMaterias = 0;
        final InfoUsuarioVO infoUsuario = InfoUsuarioVO.obtenerInstancia();
        List<Instructor> listaInstructor = null;
        ArrayList<Instructor> listaInstructorAux = new ArrayList<Instructor>();
        try {
            listaInstructor = this.instructorDao.BuscarPorIdentificacion(infoUsuario.getUsuario().getIdentificacion());
        }
        catch (Exception ex) {
            Logger.getLogger(ControladorMateria.class.getName()).log(Level.SEVERE, null, ex);
        }
        ArrayList<String> nivelesConsultar = new ArrayList<String>();
        nivelesConsultar.add(NivelEnum.BASICA_SUPERIOR.getNemonico());
        nivelesConsultar.add(NivelEnum.CIENCIAS.getNemonico());
        nivelesConsultar.add(NivelEnum.TECNICO.getNemonico());
        nivelesConsultar.add(NivelEnum.INTERNACIONAL.getNemonico());
        for (Instructor item : this.instructorDao.buscarTutorGrados(infoUsuario.getUsuario().getIdentificacion(), nivelesConsultar)) {
            Instructor auxC = new Instructor();
            Instructor auxR = new Instructor();
            try {
                auxC = this.instructorDao.BuscarTutorCursoPorIdentificacion(item.getIdentificacionDocente(), item.getIdCurso(), item.getIdParalelo());
                auxR = this.instructorDao.BuscarTutorCursoPorIdentificacion(item.getIdentificacionDocente(), item.getIdCurso(), item.getIdParalelo());
            }
            catch (Exception ex) {
                Logger.getLogger(ControladorMateria.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (auxC == null || auxR == null) continue;
            auxC.setNombreMateria("COMPORTAMIENTO");
            listaInstructorAux.add(auxC);
            auxR.setNombreMateria("RECOMENDACIONES");
            listaInstructorAux.add(auxR);
        }
        listaInstructor.addAll(listaInstructorAux);
        jfrParent.pnlListaMateria.setOpaque(false);
        jfrParent.pnlListaMateria.setBackground(new Color(0, 0, 0, 55));
        numeroMaterias = listaInstructor.size();
        if (listaInstructor != null && !listaInstructor.isEmpty()) {
            for (final Instructor instructor : listaInstructor) {
                JButton jbtMateria = new JButton();
                ImageIcon Img = new ImageIcon(this.getClass().getResource("/Imagenes/NOTAS_BLANCO.PNG"));
                if (instructor.getNombreMateria().equals("COMPORTAMIENTO") || instructor.getNombreMateria().equals("RECOMENDACIONES")) {
                    jbtMateria.setBackground(new Color(0, 77, 128));
                } else {
                    jbtMateria.setBackground(new Color(0, 140, 205));
                }
                jbtMateria.setSize(200, 50);
                jbtMateria.setIcon(Img);
                jbtMateria.setText("<html><body><center><div style=\"padding:2px;font-weight:bold;\"><div style=\"padding:3px;\">" + instructor.getNombreInstitucion() + "</div><div style=\"padding:3px;\">" + instructor.getNombreMateria() + "</div><div style=\"padding:3px;\">" + instructor.getNombreCurso() + " " + instructor.getNombreParalelo() + "</div> <div style=\"padding:3px;\">" + instructor.getEspecialidad() + "</div> <div style=\"padding:3px;\">" + instructor.getJornada() + "</div> </div></center></body></html>");
                jbtMateria.setIconTextGap(1);
                jbtMateria.setHorizontalAlignment(0);
                jbtMateria.setVerticalAlignment(0);
                jbtMateria.setHorizontalTextPosition(4);
                jbtMateria.setForeground(Color.WHITE);
                jbtMateria.setFont(new FuncionesAuxiliar().establecerFont(3));
                jbtMateria.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            List<CalificacionVO> listaCalificaciones = ControladorMateria.this.calificacionDao.recuperarCalificaciones(instructor.getIdEscenario(), instructor.getIdEscenarioDiscrecion(), instructor.getIdParalelo());
                            if (instructor.getNemTipoNivel().equals(NivelEnum.INICIAL1.getNemonico()) || instructor.getNemTipoNivel().equals(NivelEnum.INICIAL2.getNemonico()) || instructor.getNemTipoNivel().equals(NivelEnum.BASICA_PREPARATORIA.getNemonico())) {
                                if (instructor.getNemonicoMateria() != null && instructor.getNemonicoMateria().equals("PE")) {
                                    jfrParent.vistaNota.removeAll();
                                    jfrParent.vistaNota = new VistaNota();
                                    jfrParent.vistaNota.mostrarCalificacion(listaCalificaciones, infoUsuario, instructor);
                                } else {
                                    jfrParent.vistaNotaInicial.removeAll();
                                    jfrParent.vistaNotaInicial = new VistaNotaInicial();
                                    jfrParent.vistaNotaInicial.iniciarCarga(instructor.getIdParalelo(), instructor);
                                }
                            } else {
                                jfrParent.vistaNota.removeAll();
                                jfrParent.vistaNota = new VistaNota();
                                jfrParent.vistaNota.mostrarCalificacion(listaCalificaciones, infoUsuario, instructor);
                            }
                            jfrParent.setIndiceVentana(3);
                            jfrParent.setInstitucion(instructor.getNombreInstitucion());
                            jfrParent.setMateria(instructor.getNombreMateria());
                            jfrParent.setParalelo(instructor.getNombreCurso() + " " + instructor.getNombreParalelo());
                            jfrParent.setRegimenAnioLectivo(instructor.getRegimen() + ": " + instructor.getAnioLectivoInicio() + " - " + instructor.getAnioLectivoFin());
                            jfrParent.formarTrabajo();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(ControladorMateria.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
                jfrParent.pnlListaMateria.add(jbtMateria);
            }
            if (numeroMaterias < 20) {
                for (int i = numeroMaterias; i < 20; ++i) {
                    JButton jbtMateriaCompleto = new JButton();
                    jbtMateriaCompleto.setSize(50, 50);
                    jbtMateriaCompleto.setOpaque(false);
                    jbtMateriaCompleto.setContentAreaFilled(false);
                    jbtMateriaCompleto.setBorderPainted(false);
                    jfrParent.pnlListaMateria.add(jbtMateriaCompleto);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }

    public void consultarParalelosAsignaturasAsistencia(final VistaPrincipal jfrParent) {
        int numeroMaterias = 0;
        final InfoUsuarioVO infoUsuario = InfoUsuarioVO.obtenerInstancia();
        List<Object> listaInstructor = new ArrayList();
        ArrayList<String> nivelesConsultar = new ArrayList<String>();
        nivelesConsultar.add(NivelEnum.BASICA_SUPERIOR.getNemonico());
        nivelesConsultar.add(NivelEnum.CIENCIAS.getNemonico());
        nivelesConsultar.add(NivelEnum.TECNICO.getNemonico());
        nivelesConsultar.add(NivelEnum.INTERNACIONAL.getNemonico());
        try {
            listaInstructor = this.instructorDao.buscarPorIdentificacionAsistencia(infoUsuario.getUsuario().getIdentificacion(), nivelesConsultar);
        }
        catch (Exception ex) {
            Logger.getLogger(ControladorMateria.class.getName()).log(Level.SEVERE, null, ex);
        }
        List<Instructor> auxJus = this.instructorDao.buscarTutorGrados(infoUsuario.getUsuario().getIdentificacion(), nivelesConsultar);
        if (!auxJus.isEmpty()) {
            Instructor justificar = new Instructor();
            justificar.setTutor("-1");
            justificar.setRegimen(((Instructor)listaInstructor.get(0)).getRegimen());
            justificar.setAnioLectivoFin(((Instructor)listaInstructor.get(0)).getAnioLectivoFin());
            justificar.setNombreInstitucion(((Instructor)listaInstructor.get(0)).getNombreInstitucion());
            justificar.setNombreMateria("FALTA");
            justificar.setAnioLectivoInicio(((Instructor)listaInstructor.get(0)).getAnioLectivoInicio());
            justificar.setIdRegistroAnioLectivo(((Instructor)listaInstructor.get(0)).getIdRegistroAnioLectivo());
            justificar.setIdRegimen(((Instructor)listaInstructor.get(0)).getIdRegimen());
            justificar.setNombreCurso("-");
            justificar.setNombreParalelo("-");
            justificar.setIdUsuario(((Instructor)listaInstructor.get(0)).getIdUsuario());
            listaInstructor.add(justificar);
        }
        numeroMaterias = listaInstructor.size();
        jfrParent.pnlListaMateria.setOpaque(false);
        jfrParent.pnlListaMateria.setBackground(new Color(0, 0, 0, 55));
        if (!listaInstructor.isEmpty()) {
            for (final Instructor instructor : listaInstructor) {
                JButton jbtMateria = new JButton();
                ImageIcon Img = new ImageIcon(this.getClass().getResource("/Imagenes/ASISTENCIAS_BLANCO.PNG"));
                if (instructor.getTutor() != null && instructor.getTutor().equals("-1")) {
                    jbtMateria.setBackground(new Color(0, 77, 128));
                    jbtMateria.setText("<html><body><center><div style=\"padding:10px;font-weight:bold;\"><div style=\"padding:3px;\">" + instructor.getNombreInstitucion() + "</div><div style=\"padding:3px;\">CONTROL DE FALTAS </div><div style=\"padding:3px;\">JUSTIFICADAS E INJUSTIFICADAS</div></center></body></html>");
                } else {
                    jbtMateria.setBackground(new Color(0, 140, 205));
                    jbtMateria.setText("<html><body><center><div style=\"padding:10px;font-weight:bold;\"><div style=\"padding:3px;\">" + instructor.getNombreInstitucion() + "</div>" + (instructor.getNemTipoNivel().equals(NivelEnum.BASICA_ELEMENTAL.getNemonico()) || instructor.getNemTipoNivel().equals(NivelEnum.BASICA_MEDIA.getNemonico()) ? "<div style=\"padding:3px;\">TRONCO COM\u00daN</div>" : "<div style=\"padding:3px;\">" + instructor.getNombreMateria() + "</div>") + "<div style=\"padding:3px;\">" + instructor.getNombreCurso() + " " + instructor.getNombreParalelo() + "</div><div style=\"padding:3px;\">" + instructor.getEspecialidad() + "</div> <div style=\"padding:3px;\">" + instructor.getJornada() + "</div></div></center></body></html>");
                }
                jbtMateria.setIcon(Img);
                jbtMateria.setIconTextGap(1);
                jbtMateria.setHorizontalAlignment(0);
                jbtMateria.setVerticalAlignment(0);
                jbtMateria.setHorizontalTextPosition(4);
                jbtMateria.setForeground(Color.WHITE);
                jbtMateria.setFont(new FuncionesAuxiliar().establecerFont(3));
                jbtMateria.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            if (instructor.getTutor() != null && instructor.getTutor().equals("-1")) {
                                jfrParent.vistaJustificarAsistencia.removeAll();
                                jfrParent.vistaJustificarAsistencia = new VistaJustificarAsistencia();
                                jfrParent.vistaJustificarAsistencia.iniciarCarga(instructor.getIdRegistroAnioLectivo(), infoUsuario.getUsuario().getIdentificacion(), instructor);
                            } else if (instructor.getNemTipoNivel().equals(NivelEnum.BASICA_ELEMENTAL.getNemonico()) || instructor.getNemTipoNivel().equals(NivelEnum.BASICA_MEDIA.getNemonico())) {
                                jfrParent.vistaAsistencia.removeAll();
                                jfrParent.vistaAsistencia = new VistaAsistencia();
                                jfrParent.vistaAsistencia.iniciarCarga(instructor.getIdParalelo(), instructor.getIdRegistroAnioLectivo(), instructor);
                            } else {
                                jfrParent.vistaAsistenciaBach.removeAll();
                                jfrParent.vistaAsistenciaBach = new VistaAsistenciaBachillerato();
                                jfrParent.vistaAsistenciaBach.iniciarCarga(instructor.getIdParalelo(), instructor.getIdRegistroAnioLectivo(), instructor);
                            }
                            jfrParent.setIndiceVentana(4);
                            jfrParent.setInstitucion(instructor.getNombreInstitucion());
                            jfrParent.setMateria(instructor.getNombreMateria());
                            jfrParent.setParalelo(instructor.getNombreCurso() + " " + instructor.getNombreParalelo());
                            jfrParent.setRegimenAnioLectivo(instructor.getRegimen() + ": " + instructor.getAnioLectivoInicio() + " - " + instructor.getAnioLectivoFin());
                            jfrParent.formarTrabajo();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(ControladorMateria.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
                jfrParent.pnlListaMateria.add(jbtMateria);
            }
            if (numeroMaterias < 20) {
                for (int i = numeroMaterias; i < 20; ++i) {
                    JButton jButton = new JButton();
                    jButton.setSize(50, 50);
                    jButton.setOpaque(false);
                    jButton.setContentAreaFilled(false);
                    jButton.setBorderPainted(false);
                    jfrParent.pnlListaMateria.add(jButton);
                }
            }
        }
    }
}

