/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.NotaCualitativaDao;
import Modelos.Entidades.NotaCualitativa;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class NotaCualitativaDaoImpl
extends ConexionSQLite
implements NotaCualitativaDao {
    @Override
    public List<NotaCualitativa> listar() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void registrar(String nota, String tipo) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotaCualitativa obtenerPorCalificacionModelo(Integer idCalificacion, Integer idModelo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(NotaCualitativa.class);
        NotaCualitativa nota = null;
        try {
            nota = (NotaCualitativa)run.query(conn, " SELECT  r.id_aplicacion as idAplicacion,  r.id_modelo as idModelo,  r.nombre_modelo as nombreModelo, r.nota1 as nota1, r.nota2 as nota2,  r.nota3 as nota3, r.nota_quimestre as notaQuimestres,  r.id_usuario_creacion as idUsuarioCreacion, r.id as id FROM nota_cualitativa r  WHERE  r.id_calificacion = ? and  r.id_modelo=? ", (ResultSetHandler)handler, new Object[]{idCalificacion, idModelo});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return nota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarNota(NotaCualitativa nota) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO nota_cualitativa(id_calificacion, id_modelo,nombre_modelo,nota1,nota2,nota3,nota_quimestre, id_usuario_creacion, reg_anio_inicio )  values(?,?,?,?,?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{nota.getIdCalificacion(), nota.getIdModelo(), nota.getNombreModelo(), nota.getNota1(), nota.getNota2(), nota.getNota3(), nota.getNotaQuimestres(), nota.getIdUsuarioCreacion(), nota.getRegAnioInicio()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarNota(NotaCualitativa nota) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE nota_cualitativa set nota1 = ?, nota2 = ?, nota3 = ?, nota_quimestre= ?, reg_anio_inicio= ?, id_usuario_creacion= ?, id = ? where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{nota.getNota1(), nota.getNota2(), nota.getNota3(), nota.getNotaQuimestres(), nota.getRegAnioInicio(), nota.getIdUsuarioCreacion(), nota.getId(), nota.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public boolean actualizar(String valores, Integer id) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NotaCualitativa> obtenerPorParalelo(Integer idEscenario, Integer idEscenarioDiscrecion) throws Exception {
        System.out.println("idEscenarioDiscrecion:" + idEscenarioDiscrecion + " - " + idEscenario);
        ArrayList<NotaCualitativa> notas = new ArrayList<NotaCualitativa>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT ");
            query.append(" r.id_aplicacion as idAplicacion, ");
            query.append(" r.id_modelo as idModelo, ");
            query.append(" r.nombre_modelo as nombreModelo, ");
            query.append(" r.nota1 as nota1, ");
            query.append(" r.nota2 as nota2, ");
            query.append(" r.nota3 as nota3, ");
            query.append(" r.nota_quimestre as notaQuimestres, ");
            query.append(" r.id as id, ");
            query.append(" r.reg_anio_inicio as regAnioInicio, ");
            query.append(" r.id_usuario_creacion as idUsuarioCreacion, ");
            query.append(" c.id as idCalificacion ");
            query.append(" FROM nota_cualitativa r ");
            query.append(" join calificacion c on c.id_aplicacion=r.id_calificacion ");
            query.append(" where  c.id_escenario=? ");
            if (idEscenarioDiscrecion == null || idEscenarioDiscrecion == 0) {
                query.append("and c.id_escenario_discrecion is null ");
            } else {
                query.append("and c.id_escenario_discrecion=? ");
            }
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idEscenario);
            if (idEscenarioDiscrecion != 0) {
                ps.setInt(2, idEscenarioDiscrecion);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                NotaCualitativa nota = new NotaCualitativa();
                nota.setIdAplicacion(rs.getInt("idAplicacion"));
                nota.setIdModelo(rs.getInt("idModelo"));
                nota.setNombreModelo(rs.getString("nombreModelo"));
                nota.setNota1(rs.getString("nota1"));
                nota.setNota2(rs.getString("nota2"));
                nota.setNota3(rs.getString("nota3"));
                nota.setNotaQuimestres(rs.getString("notaQuimestres"));
                nota.setId(rs.getInt("id"));
                nota.setRegAnioInicio(rs.getString("regAnioInicio"));
                nota.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                nota.setIdCalificacion(rs.getInt("idCalificacion"));
                notas.add(nota);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.cerrar();
        }
        return notas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarNotaSincronizacion(NotaCualitativa nota) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE nota_cualitativa set id= ?, codigo_error = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{nota.getId(), nota.getCodigoError(), nota.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NotaCualitativa> buscarTodo() {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(NotaCualitativa.class);
        ArrayList<NotaCualitativa> nota = new ArrayList();
        try {
            nota = (List)run.query(conn, " SELECT  r.id_aplicacion as idAplicacion,  r.id_modelo as idModelo,  r.nombre_modelo as nombreModelo, r.nota1 as nota1, r.nota2 as nota2,  r.nota3 as nota3, r.nota_quimestre as notaQuimestres,  r.id as id, r.reg_anio_inicio as regAnioInicio, r.id_usuario_creacion as idUsuarioCreacion, c.id   idCalificacion FROM nota_cualitativa r  join calificacion c on c.id_aplicacion=r.id_calificacion join instructor i on i.id=c.id_instructor ", (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return nota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaNota(List<NotaCualitativa> listaNota) throws Exception {
        if (null != listaNota && !listaNota.isEmpty()) {
            try {
                String sql = " INSERT INTO nota_cualitativa(id, id_calificacion, id_modelo,nombre_modelo,nota1,nota2,nota3,nota_quimestre, id_usuario_creacion, reg_anio_inicio )  values(?,?,?,?,?,?,?,?,?,?)";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (NotaCualitativa nota : listaNota) {
                    if (null == nota) continue;
                    PreparedStatement psc = this.getConexion().prepareStatement("SELECT * FROM calificacion WHERE id =? ");
                    psc.setInt(1, nota.getIdCalificacion());
                    ResultSet rsc = psc.executeQuery();
                    if (null == rsc) continue;
                    rsc.next();
                    ps.setInt(1, nota.getId());
                    ps.setInt(2, rsc.getInt("id_aplicacion"));
                    ps.setInt(3, nota.getIdModelo());
                    ps.setString(4, "QUIMESTRAL");
                    ps.setString(5, (String)(nota.getNota1() != null ? (nota.getNota1().trim().equals("") ? null : nota.getNota1().trim()) : nota.getNota1()));
                    ps.setString(6, (String)(nota.getNota2() != null ? (nota.getNota2().trim().equals("") ? null : nota.getNota2().trim()) : nota.getNota2()));
                    ps.setString(7, (String)(nota.getNota3() != null ? (nota.getNota3().trim().equals("") ? null : nota.getNota3().trim()) : nota.getNota3()));
                    ps.setString(8, nota.getNotaQuimestres() != null ? nota.getNotaQuimestres().trim() : nota.getNotaQuimestres());
                    ps.setInt(9, nota.getIdUsuarioCreacion());
                    ps.setString(10, nota.getRegAnioInicio());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (Exception e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }
}

