/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.PeriodoAnioLectivoDao;
import Modelos.Entidades.PeriodoAnioLectivo;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class PeriodoAnioLectivoDaoImpl
extends ConexionSQLite
implements PeriodoAnioLectivoDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeriodoAnioLectivo buscarPorId(Integer id) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(PeriodoAnioLectivo.class);
        PeriodoAnioLectivo periodo = null;
        try {
            periodo = (PeriodoAnioLectivo)run.query(conn, " SELECT  r.id ,  r.fecha_inicio as fechaInicio,  r.fecha_fin as fechaFin,  r.dia_asistencia as diaAsistencia,  r.id_modelo as idModelo,  r.id_reg_anio_lectivo as idRegAnioLectivo, r.estado as estado FROM periodo_anio_lectivo r  WHERE r.id = ?  ", (ResultSetHandler)handler, new Object[]{id});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return periodo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarPeriodoAnioLectivo(PeriodoAnioLectivo periodoAnioLectivo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO periodo_anio_lectivo(id, fecha_inicio, fecha_fin, dia_asistencia, id_modelo,id_reg_anio_lectivo,estado)  values(?,?,?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{periodoAnioLectivo.getId(), periodoAnioLectivo.getFechaInicio(), periodoAnioLectivo.getFechaFin(), periodoAnioLectivo.getDiaAsistencia(), periodoAnioLectivo.getIdModelo(), periodoAnioLectivo.getIdRegAnioLectivo(), periodoAnioLectivo.getEstado()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaPeriodoAnioLectivo(List<PeriodoAnioLectivo> periodoAnioLectivo) throws Exception {
        if (null != periodoAnioLectivo && !periodoAnioLectivo.isEmpty()) {
            try {
                String sql = " INSERT INTO periodo_anio_lectivo(id, fecha_inicio, fecha_fin, dia_asistencia, id_modelo,id_reg_anio_lectivo,estado)  values(?,?,?,?,?,?,?)";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (PeriodoAnioLectivo periodo : periodoAnioLectivo) {
                    if (null == periodo) continue;
                    ps.setInt(1, periodo.getId());
                    ps.setString(2, periodo.getFechaInicio());
                    ps.setString(3, periodo.getFechaFin());
                    ps.setObject(4, (Object)periodo.getDiaAsistencia(), 4);
                    ps.setObject(5, (Object)periodo.getIdModelo(), 4);
                    ps.setObject(6, (Object)periodo.getIdRegAnioLectivo(), 4);
                    ps.setString(7, periodo.getEstado());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeriodoAnioLectivo buscarPorAniLecModelo(Integer idAniLec, Integer idModelo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(PeriodoAnioLectivo.class);
        PeriodoAnioLectivo periodo = null;
        try {
            periodo = (PeriodoAnioLectivo)run.query(conn, " SELECT  r.id ,  r.fecha_inicio as fechaInicio,  r.fecha_fin as fechaFin,  r.dia_asistencia as diaAsistencia,  r.id_modelo as idModelo,  r.id_reg_anio_lectivo as idRegAnioLectivo, r.estado as estado FROM periodo_anio_lectivo r  WHERE r.id_reg_anio_lectivo = ? and r.id_modelo=? ", (ResultSetHandler)handler, new Object[]{idAniLec, idModelo});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return periodo;
    }
}

