/*
 * Decompiled with CFR 0.152.
 */
package Vistas.model;

import Enumeradores.ModeloEnum;
import Modelos.Dao.AsignacionDao;
import Modelos.Dao.AsignacionDaoImpl;
import Modelos.Dao.CalificacionDao;
import Modelos.Dao.CalificacionDaoImpl;
import Modelos.Dao.NotaDao;
import Modelos.Dao.NotaDaoImpl;
import Modelos.Dao.SupletorioDao;
import Modelos.Dao.SupletorioDaoImpl;
import Modelos.Entidades.Calificacion;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.Nota;
import Modelos.Entidades.Supletorio;
import Servicios.Validaciones;
import Util.Constantes;
import Vistas.model.JBroTableDataProyectoEscolar;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.view.JBroTable;
import vo.CalificacionVO;

public class JBroTableData
extends JBroTable {
    private List<CalificacionVO> listaCalificaciones;
    CalificacionDao calificacionDao = new CalificacionDaoImpl();
    NotaDao notaDao = new NotaDaoImpl();
    SupletorioDao supletorioDao = new SupletorioDaoImpl();
    AsignacionDao asignacionDao = new AsignacionDaoImpl();
    ModelData data;
    private ModelField[] fields;
    private Instructor instructor;
    private Nota nota1 = null;
    private Nota nota2 = null;
    private Supletorio supletorio = null;
    private Calificacion calificacion = null;
    private CalificacionVO calificacionVo = new CalificacionVO();

    public JBroTableData(ModelData data, List<CalificacionVO> listaCalificaciones, ModelField[] fields, Instructor instructor) {
        super(data);
        this.data = data;
        this.listaCalificaciones = listaCalificaciones;
        this.fields = fields;
        this.instructor = instructor;
    }

    public int getRowCount() {
        return this.listaCalificaciones.size();
    }

    public Class<?> getColumnClass(int i) {
        return this.getValueAt(this.getRowCount() - 1, i).getClass();
    }

    public boolean isCellEditable(int fila, int col) {
        boolean isEditable = false;
        boolean columBloquea = false;
        try {
            String opcion;
            switch (opcion = this.fields[col].getIdentifier()) {
                case "Q1P1": {
                    columBloquea = true;
                    break;
                }
                case "Q1P2": {
                    columBloquea = true;
                    break;
                }
                case "Q1P3": {
                    columBloquea = true;
                    break;
                }
                case "Q1EX": {
                    columBloquea = true;
                    break;
                }
                case "Q2P1": {
                    columBloquea = true;
                    break;
                }
                case "Q2P2": {
                    columBloquea = true;
                    break;
                }
                case "Q2P3": {
                    columBloquea = true;
                    break;
                }
                case "Q2EX": {
                    columBloquea = true;
                    break;
                }
                case "QEM": {
                    Object value = this.getValueAt(fila, col - 2);
                    String f = value.toString();
                    Double valor = Double.valueOf(f.replace(',', '.'));
                    Object valueSuple = this.getValueAt(fila, col + 1);
                    String fSuple = valueSuple.toString();
                    Object valueReme = this.getValueAt(fila, col + 2);
                    String fReme = valueReme.toString();
                    if (!(Double.valueOf(valor.toString()) >= 7.0) || !(Double.valueOf(valor.toString()) < 10.0)) break;
                    if (fSuple != "" || fReme != "") {
                        isEditable = false;
                        break;
                    }
                    isEditable = true;
                    break;
                }
                case "QSS": {
                    Object value = this.getValueAt(fila, col - 3);
                    String f = value.toString();
                    Object valueSuple = this.getValueAt(fila, col);
                    String fSuple = valueSuple.toString();
                    Double valor = Double.valueOf(f.replace(',', '.'));
                    if (!(Double.valueOf(valor.toString()) >= 5.0 && Double.valueOf(valor.toString()) < 7.0) && fSuple == "") break;
                    isEditable = true;
                    break;
                }
                case "QSR": {
                    Object value = this.getValueAt(fila, col - 4);
                    String f = value.toString();
                    Double valor = Double.valueOf(f.replace(',', '.'));
                    Object valueSuple = this.getValueAt(fila, col - 1);
                    String fSuple = valueSuple.toString();
                    Double valorSuple = 0.0;
                    if (fSuple != "") {
                        valorSuple = Double.valueOf(fSuple.replace(',', '.'));
                    }
                    valueSuple = this.getValueAt(fila, col);
                    String fSupleReme = valueSuple.toString();
                    if (!(Double.valueOf(valor.toString()) < 5.0 || fSuple != "" && Double.valueOf(valorSuple.toString()) < 7.0) && fSupleReme == "") break;
                    isEditable = true;
                    break;
                }
                case "QSG": {
                    Object value = this.getValueAt(fila, col - 1);
                    String f = value.toString();
                    Object valueSuple = this.getValueAt(fila, col);
                    String fSuple = valueSuple.toString();
                    Double valor = Double.valueOf(f.replace(',', '.'));
                    if (!(valor < 7.0) && fSuple == "") break;
                    isEditable = true;
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isEditable || columBloquea;
    }

    public Object getValueAt(int fila, int col) {
        this.calificacionVo = this.listaCalificaciones.get(fila);
        Object valor = null;
        if (col == 0) {
            this.fields[col].setDefaultWidth(Integer.valueOf(0));
        }
        try {
            switch (this.fields[col].getIdentifier()) {
                case "Q1P1": {
                    valor = Validaciones.decimal(this.calificacionVo.getNota1Nota1());
                    break;
                }
                case "Q1P2": {
                    valor = Validaciones.decimal(this.calificacionVo.getNota2Nota1());
                    break;
                }
                case "Q1P3": {
                    valor = Validaciones.decimal(this.calificacionVo.getNota3Nota1());
                    break;
                }
                case "Q1PR": {
                    valor = Validaciones.decimal(this.calificacionVo.getPromedioNotaNota1());
                    break;
                }
                case "Q1PP": {
                    valor = Validaciones.decimal(this.calificacionVo.getPorcentajePromedioNota1());
                    break;
                }
                case "Q1EX": {
                    valor = Validaciones.decimal(this.calificacionVo.getNotaExamenNota1());
                    break;
                }
                case "Q1PE": {
                    valor = Validaciones.decimal(this.calificacionVo.getPorcentajeExamenNota1());
                    break;
                }
                case "PQ1": {
                    valor = Validaciones.decimal(this.calificacionVo.getPromedioNota1());
                    break;
                }
                case "Q2P1": {
                    valor = Validaciones.decimal(this.calificacionVo.getNota1Nota2());
                    break;
                }
                case "Q2P2": {
                    valor = Validaciones.decimal(this.calificacionVo.getNota2Nota2());
                    break;
                }
                case "Q2P3": {
                    valor = Validaciones.decimal(this.calificacionVo.getNota3Nota2());
                    break;
                }
                case "Q2PR": {
                    valor = Validaciones.decimal(this.calificacionVo.getPromedioNotaNota2());
                    break;
                }
                case "Q2PP": {
                    valor = Validaciones.decimal(this.calificacionVo.getPorcentajePromedioNota2());
                    break;
                }
                case "Q2EX": {
                    valor = Validaciones.decimal(this.calificacionVo.getNotaExamenNota2());
                    break;
                }
                case "Q2PE": {
                    valor = Validaciones.decimal(this.calificacionVo.getPorcentajeExamenNota2());
                    break;
                }
                case "PQ2": {
                    valor = Validaciones.decimal(this.calificacionVo.getPromedioNota2());
                    break;
                }
                case "QMPA": {
                    valor = Validaciones.decimal(this.calificacionVo.getPromedioAnual());
                    break;
                }
                case "QEM": {
                    valor = Validaciones.decimal(this.calificacionVo.getNotaExamenMejora());
                    break;
                }
                case "QSS": {
                    valor = Validaciones.decimal(this.calificacionVo.getNotaSupletorio());
                    break;
                }
                case "QSR": {
                    valor = Validaciones.decimal(this.calificacionVo.getNotaRemedial());
                    break;
                }
                case "QSG": {
                    valor = Validaciones.decimal(this.calificacionVo.getNotaGracia());
                    break;
                }
                default: {
                    valor = "";
                    break;
                }
            }
        }
        catch (Exception e) {
            valor = "";
        }
        return valor;
    }

    public void setValueAt(Object o, int fila, int col) {
        try {
            BigDecimal valor;
            if (o == null) {
                valor = null;
            } else {
                String f = o.toString();
                BigDecimal bd = valor = new BigDecimal(f.replace(',', '.'));
                valor = bd = bd.setScale(2, RoundingMode.DOWN);
            }
            this.calificacionVo = this.listaCalificaciones.get(fila);
            this.calificacion = this.calificacionDao.buscarCalificacionPorAsignacionInstructor(this.calificacionVo.getIdAsignacion(), this.instructor.getIdEscenario(), this.instructor.getIdEscenarioDiscrecion());
            boolean updateNota1 = true;
            boolean updateNota2 = true;
            boolean updateSuple = true;
            boolean crearSupletorio = false;
            boolean crearNota1 = false;
            boolean crearNota2 = false;
            boolean crearNotaInsumo1 = false;
            boolean crearNotaInsumo2 = false;
            if (this.calificacion.getIdAplicacion() == null) {
                this.calificacion = new Calificacion();
                this.calificacion.setAsignacion(this.asignacionDao.buscarPorId(this.calificacionVo.getIdAsignacion()));
                this.calificacion.setInstrucutor(this.instructor);
                this.calificacion.setIdEsquema(this.instructor.getIdEsquema());
                this.calificacion.setIdPeriodo(this.instructor.getIdPeriodo());
                this.calificacion.setNombreEsquema("QUIMESTRAL");
                this.calificacion.setTipoPromedio("Q");
                this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                this.calificacion.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                this.calificacion.setIdEscenario(this.instructor.getIdEscenario());
                if (this.instructor.getIdEscenarioDiscrecion().equals(0)) {
                    this.calificacion.setIdEscenarioDiscrecion(null);
                } else {
                    this.calificacion.setIdEscenarioDiscrecion(this.instructor.getIdEscenarioDiscrecion());
                }
                this.calificacionDao.guardarCalificacion(this.calificacion);
            }
            this.calificacion = this.calificacionDao.buscarCalificacionPorAsignacionInstructor(this.calificacionVo.getIdAsignacion(), this.instructor.getIdEscenario(), this.instructor.getIdEscenarioDiscrecion());
            if (this.calificacion.getIdAplicacion() != null) {
                try {
                    this.nota1 = this.notaDao.obtenerPorCalificacionModelo(this.calificacion.getIdAplicacion() == null ? 0 : this.calificacion.getIdAplicacion(), 2);
                }
                catch (Exception ex) {
                    Logger.getLogger(JBroTableDataProyectoEscolar.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.nota2 = this.notaDao.obtenerPorCalificacionModelo(this.calificacion.getIdAplicacion() == null ? 0 : this.calificacion.getIdAplicacion(), 3);
                this.supletorio = this.supletorioDao.buscarPorIdCalificacion(this.calificacion.getIdAplicacion() == null ? 0 : this.calificacion.getIdAplicacion());
            }
            if (this.nota1.getIdAplicacion() == null) {
                updateNota1 = false;
                this.nota1 = new Nota();
            } else {
                updateNota1 = true;
            }
            if (this.nota2.getIdAplicacion() == null) {
                updateNota2 = false;
                this.nota2 = new Nota();
            } else {
                updateNota2 = true;
            }
            if (this.supletorio.getIdAplicacion() == null) {
                updateSuple = false;
                this.supletorio = new Supletorio();
            }
            if (valor != null && (valor.doubleValue() > 10.0 || valor.doubleValue() < 0.0)) {
                JOptionPane.showMessageDialog(null, "Nota incorrecta. Por favor ingresar una nota de 0 a 10");
            } else {
                String opcion;
                switch (opcion = this.fields[col].getIdentifier()) {
                    case "Q1P1": {
                        this.nota1.setNota1(valor);
                        crearNota1 = true;
                        BigDecimal promedio = Validaciones.calcularPromedio(this.nota1.getNota1(), this.nota1.getNota2(), this.nota1.getNota3());
                        this.nota1.setPromedioNota(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : promedio);
                        this.nota1.setPorcentajePromedio(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calcularPorcentajeNota(this.nota1.getPromedioNota()));
                        this.nota1.setPromedio(this.nota1.getPorcentajeExamen() == null && promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calculaSuma(this.nota1.getPorcentajePromedio(), this.nota1.getPorcentajeExamen()));
                        if (valor != null && valor.compareTo(BigDecimal.ZERO) == 0) {
                            this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                        } else {
                            this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        }
                        this.calificacionVo.setNota1Nota1(valor);
                        this.calificacionVo.setPromedioNotaNota1(this.nota1.getPromedioNota());
                        this.calificacionVo.setPorcentajePromedioNota1(this.nota1.getPorcentajePromedio());
                        this.calificacionVo.setPromedioNota1(this.nota1.getPromedio());
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                    case "Q1P2": {
                        this.nota1.setNota2(valor);
                        crearNota1 = true;
                        BigDecimal promedio = Validaciones.calcularPromedio(this.nota1.getNota1(), this.nota1.getNota2(), this.nota1.getNota3());
                        this.nota1.setPromedioNota(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : promedio);
                        this.nota1.setPorcentajePromedio(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calcularPorcentajeNota(this.nota1.getPromedioNota()));
                        this.nota1.setPromedio(this.nota1.getPorcentajeExamen() == null && promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calculaSuma(this.nota1.getPorcentajePromedio(), this.nota1.getPorcentajeExamen()));
                        if (valor != null && valor.compareTo(BigDecimal.ZERO) == 0) {
                            this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                        } else {
                            this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        }
                        this.calificacionVo.setNota2Nota1(valor);
                        this.calificacionVo.setPromedioNotaNota1(this.nota1.getPromedioNota());
                        this.calificacionVo.setPorcentajePromedioNota1(this.nota1.getPorcentajePromedio());
                        this.calificacionVo.setPromedioNota1(this.nota1.getPromedio());
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                    case "Q1P3": {
                        this.nota1.setNota3(valor);
                        crearNota1 = true;
                        BigDecimal promedio = Validaciones.calcularPromedio(this.nota1.getNota1(), this.nota1.getNota2(), this.nota1.getNota3());
                        this.nota1.setPromedioNota(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : promedio);
                        this.nota1.setPorcentajePromedio(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calcularPorcentajeNota(this.nota1.getPromedioNota()));
                        this.nota1.setPromedio(this.nota1.getPorcentajeExamen() == null && promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calculaSuma(this.nota1.getPorcentajePromedio(), this.nota1.getPorcentajeExamen()));
                        if (valor != null && valor.compareTo(BigDecimal.ZERO) == 0) {
                            this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                        } else {
                            this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        }
                        this.calificacionVo.setNota3Nota1(valor);
                        this.calificacionVo.setPromedioNotaNota1(this.nota1.getPromedioNota());
                        this.calificacionVo.setPorcentajePromedioNota1(this.nota1.getPorcentajePromedio());
                        this.calificacionVo.setPromedioNota1(this.nota1.getPromedio());
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                    case "Q1EX": {
                        this.nota1.setNotaExamen(valor);
                        crearNota1 = true;
                        BigDecimal promedio = Validaciones.calcularPorcentajeExamen(this.nota1.getNotaExamen());
                        this.nota1.setPorcentajeExamen(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : promedio);
                        this.nota1.setPromedio(this.nota1.getPorcentajePromedio() == null && promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calculaSuma(this.nota1.getPorcentajePromedio(), this.nota1.getPorcentajeExamen()));
                        if (valor != null && valor.compareTo(BigDecimal.ZERO) == 0) {
                            this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                        } else {
                            this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        }
                        this.calificacionVo.setNotaExamenNota1(valor);
                        this.calificacionVo.setPorcentajeExamenNota1(this.nota1.getPorcentajeExamen());
                        this.calificacionVo.setPromedioNota1(this.nota1.getPromedio());
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                    case "Q2P1": {
                        this.nota2.setNota1(valor);
                        crearNota2 = true;
                        BigDecimal promedio = Validaciones.calcularPromedio(this.nota2.getNota1(), this.nota2.getNota2(), this.nota2.getNota3());
                        this.nota2.setPromedioNota(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : promedio);
                        this.nota2.setPorcentajePromedio(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calcularPorcentajeNota(this.nota2.getPromedioNota()));
                        this.nota2.setPromedio(this.nota2.getPorcentajeExamen() == null && promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calculaSuma(this.nota2.getPorcentajePromedio(), this.nota2.getPorcentajeExamen()));
                        if (valor != null && valor.compareTo(BigDecimal.ZERO) == 0) {
                            this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                        } else {
                            this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        }
                        this.calificacionVo.setNota1Nota2(valor);
                        this.calificacionVo.setPromedioNotaNota2(this.nota2.getPromedioNota());
                        this.calificacionVo.setPorcentajePromedioNota2(this.nota2.getPorcentajePromedio());
                        this.calificacionVo.setPromedioNota2(this.nota2.getPromedio());
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                    case "Q2P2": {
                        this.nota2.setNota2(valor);
                        crearNota2 = true;
                        BigDecimal promedio = Validaciones.calcularPromedio(this.nota2.getNota1(), this.nota2.getNota2(), this.nota2.getNota3());
                        this.nota2.setPromedioNota(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : promedio);
                        this.nota2.setPorcentajePromedio(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calcularPorcentajeNota(this.nota2.getPromedioNota()));
                        this.nota2.setPromedio(this.nota2.getPorcentajeExamen() == null && promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calculaSuma(this.nota2.getPorcentajePromedio(), this.nota2.getPorcentajeExamen()));
                        if (valor != null && valor.compareTo(BigDecimal.ZERO) == 0) {
                            this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                        } else {
                            this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        }
                        this.calificacionVo.setNota2Nota2(valor);
                        this.calificacionVo.setPromedioNotaNota2(this.nota2.getPromedioNota());
                        this.calificacionVo.setPorcentajePromedioNota2(this.nota2.getPorcentajePromedio());
                        this.calificacionVo.setPromedioNota2(this.nota2.getPromedio());
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                    case "Q2P3": {
                        this.nota2.setNota3(valor);
                        crearNota2 = true;
                        BigDecimal promedio = Validaciones.calcularPromedio(this.nota2.getNota1(), this.nota2.getNota2(), this.nota2.getNota3());
                        this.nota2.setPromedioNota(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : promedio);
                        this.nota2.setPorcentajePromedio(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calcularPorcentajeNota(this.nota2.getPromedioNota()));
                        this.nota2.setPromedio(this.nota2.getPorcentajeExamen() == null && promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calculaSuma(this.nota2.getPorcentajePromedio(), this.nota2.getPorcentajeExamen()));
                        if (valor != null && valor.compareTo(BigDecimal.ZERO) == 0) {
                            this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                        } else {
                            this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        }
                        this.calificacionVo.setNota3Nota2(valor);
                        this.calificacionVo.setPromedioNotaNota2(this.nota2.getPromedioNota());
                        this.calificacionVo.setPorcentajePromedioNota2(this.nota2.getPorcentajePromedio());
                        this.calificacionVo.setPromedioNota2(this.nota2.getPromedio());
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                    case "Q2EX": {
                        this.nota2.setNotaExamen(valor);
                        crearNota2 = true;
                        BigDecimal promedio = Validaciones.calcularPorcentajeExamen(this.nota2.getNotaExamen());
                        this.nota2.setPorcentajeExamen(promedio.compareTo(BigDecimal.ZERO) == 0 ? null : promedio);
                        this.nota2.setPromedio(this.nota2.getPorcentajePromedio() == null && promedio.compareTo(BigDecimal.ZERO) == 0 ? null : Validaciones.calculaSuma(this.nota2.getPorcentajePromedio(), this.nota2.getPorcentajeExamen()));
                        if (valor != null && valor.compareTo(BigDecimal.ZERO) == 0) {
                            this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                        } else {
                            this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        }
                        this.calificacionVo.setNotaExamenNota2(valor);
                        this.calificacionVo.setPorcentajeExamenNota2(this.nota2.getPorcentajeExamen());
                        this.calificacionVo.setPromedioNota2(this.nota2.getPromedio());
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                    case "QEM": {
                        this.calificacion.setNotaExamenMejora(valor);
                        this.calificacionVo.setNotaExamenMejora(valor);
                        this.nota2.setPromedio(Validaciones.calculaSuma(this.nota2.getPorcentajePromedio(), this.nota2.getPorcentajeExamen()));
                        this.calificacionVo.setPromedioNota2(this.nota2.getPromedio());
                        this.nota1.setPromedio(Validaciones.calculaSuma(this.nota1.getPorcentajePromedio(), this.nota1.getPorcentajeExamen()));
                        this.calificacionVo.setPromedioNota1(this.nota1.getPromedio());
                        if (valor != null && (valor.compareTo(this.nota1.getPromedio()) == 1 || valor.compareTo(this.nota2.getPromedio()) == 1)) {
                            if (this.nota1.getPromedio().compareTo(this.nota2.getPromedio()) == 1) {
                                if (this.nota2 != null) {
                                    crearNota2 = true;
                                    updateNota2 = true;
                                }
                                this.nota2.setPromedio(valor);
                                if (valor != null && valor.compareTo(BigDecimal.ZERO) == 0) {
                                    this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                                } else {
                                    this.calificacion.setPromedioAnual(Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                                }
                                this.calificacionVo.setPromedioNota2(this.nota2.getPromedio());
                                this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                                break;
                            }
                            if (this.nota1 != null) {
                                crearNota1 = true;
                                updateNota1 = true;
                            }
                            this.nota1.setPromedio(valor);
                            if (valor != null && valor.compareTo(BigDecimal.ZERO) == 0) {
                                this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                            } else {
                                this.calificacion.setPromedioAnual(Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                            }
                            this.calificacionVo.setPromedioNota1(this.nota1.getPromedio());
                            this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                            break;
                        }
                        this.calificacion.setPromedioAnual(Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        if (this.nota2 != null) {
                            crearNota2 = true;
                            updateNota2 = true;
                        }
                        if (this.nota1 == null) break;
                        crearNota1 = true;
                        updateNota1 = true;
                        break;
                    }
                    case "QSS": {
                        crearSupletorio = true;
                        this.supletorio.setNotaSupletorio(valor);
                        this.calificacionVo.setNotaSupletorio(valor);
                        if (valor != null) {
                            if (valor.compareTo(Constantes.NOTA_APRUEBA_SUPLETORIO) == 0 || valor.compareTo(Constantes.NOTA_APRUEBA_SUPLETORIO) == 1) {
                                this.calificacion.setPromedioAnual(Constantes.NOTA_APRUEBA_SUPLETORIO);
                                this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                                break;
                            }
                            this.calificacion.setPromedioAnual(Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                            this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                            break;
                        }
                        this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                    case "QSR": {
                        crearSupletorio = true;
                        this.supletorio.setNotaRemedial(valor);
                        this.calificacionVo.setNotaRemedial(valor);
                        if (valor != null) {
                            if (valor.compareTo(Constantes.NOTA_APRUEBA_SUPLETORIO) == 0 || valor.compareTo(Constantes.NOTA_APRUEBA_SUPLETORIO) == 1) {
                                this.calificacion.setPromedioAnual(Constantes.NOTA_APRUEBA_SUPLETORIO);
                                this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                                break;
                            }
                            this.calificacion.setPromedioAnual(Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                            this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                            break;
                        }
                        this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                    case "QSG": {
                        crearSupletorio = true;
                        this.supletorio.setNotaGracia(valor);
                        this.calificacionVo.setNotaGracia(valor);
                        if (valor != null) {
                            if (valor.compareTo(Constantes.NOTA_APRUEBA_SUPLETORIO) == 0 || valor.compareTo(Constantes.NOTA_APRUEBA_SUPLETORIO) == 1) {
                                this.calificacion.setPromedioAnual(Constantes.NOTA_APRUEBA_SUPLETORIO);
                                this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                                break;
                            }
                            this.calificacion.setPromedioAnual(Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                            this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                            break;
                        }
                        this.calificacion.setPromedioAnual(this.nota1.getPromedio() == null && this.nota2.getPromedio() == null ? null : Validaciones.calcularPromedio(this.nota1.getPromedio(), this.nota2.getPromedio()));
                        this.calificacionVo.setPromedioAnual(this.calificacion.getPromedioAnual());
                        break;
                    }
                }
                if (crearNota1) {
                    String escalaCualitativaNota1;
                    String string = this.calificacionVo.getPromedioNota1() == null ? "" : (!(this.calificacionVo.getPromedioNota1().compareTo(new BigDecimal(9)) != 0 && this.calificacionVo.getPromedioNota1().compareTo(new BigDecimal(9)) != 1 || this.calificacionVo.getPromedioNota1().compareTo(new BigDecimal(10)) != 0 && this.calificacionVo.getPromedioNota1().compareTo(new BigDecimal(10)) != 1) ? "DA" : ((this.calificacionVo.getPromedioNota1().compareTo(new BigDecimal(7)) == 0 || this.calificacionVo.getPromedioNota1().compareTo(new BigDecimal(7)) == 1) && this.calificacionVo.getPromedioNota1().compareTo(new BigDecimal(9)) == -1 ? "AA" : (escalaCualitativaNota1 = this.calificacionVo.getPromedioNota1().compareTo(new BigDecimal(4)) == 1 && this.calificacionVo.getPromedioNota1().compareTo(new BigDecimal(7)) == -1 ? "PA" : "NA")));
                    if (updateNota1) {
                        this.nota1.setCalificacion(this.calificacion);
                        this.nota1.setPromedioEc(escalaCualitativaNota1);
                        this.nota1.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                        this.nota1.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                        if (this.nota1.getId() == null || this.nota1.getId() == 0) {
                            this.nota1.setId(null);
                        }
                        this.notaDao.actualizarNota(this.nota1);
                    } else {
                        this.nota1.setCalificacion(this.calificacion);
                        this.nota1.setIdModelo(2);
                        this.nota1.setNombreModelo(ModeloEnum.Q1.getCodigo());
                        this.nota1.setPromedioEc(escalaCualitativaNota1);
                        this.nota1.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                        this.nota1.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                        this.notaDao.guardarNota(this.nota1);
                    }
                }
                if (crearNota2) {
                    String escalaCualitativaNota2;
                    String string = this.calificacionVo.getPromedioNotaNota2() == null ? "" : (!(this.calificacionVo.getPromedioNotaNota2().compareTo(new BigDecimal(9)) != 0 && this.calificacionVo.getPromedioNotaNota2().compareTo(new BigDecimal(9)) != 1 || this.calificacionVo.getPromedioNotaNota2().compareTo(new BigDecimal(10)) != 0 && this.calificacionVo.getPromedioNotaNota2().compareTo(new BigDecimal(10)) != -1) ? "DA" : ((this.calificacionVo.getPromedioNotaNota2().compareTo(new BigDecimal(7)) == 0 || this.calificacionVo.getPromedioNotaNota2().compareTo(new BigDecimal(7)) == 1) && this.calificacionVo.getPromedioNotaNota2().compareTo(new BigDecimal(9)) == -1 ? "AA" : (escalaCualitativaNota2 = this.calificacionVo.getPromedioNotaNota2().compareTo(new BigDecimal(4)) == 1 && this.calificacionVo.getPromedioNotaNota2().compareTo(new BigDecimal(7)) == -1 ? "PA" : "NA")));
                    if (updateNota2) {
                        this.nota2.setPromedioEc(escalaCualitativaNota2);
                        this.nota2.setCalificacion(this.calificacion);
                        this.nota2.setPromedioEc(escalaCualitativaNota2);
                        this.nota2.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                        this.nota2.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                        if (this.nota2.getId() == null || this.nota2.getId() == 0) {
                            this.nota2.setId(null);
                        }
                        this.notaDao.actualizarNota(this.nota2);
                    } else {
                        this.nota2.setCalificacion(this.calificacion);
                        this.nota2.setIdModelo(3);
                        this.nota2.setNombreModelo(ModeloEnum.Q2.getCodigo());
                        this.nota2.setPromedioEc(escalaCualitativaNota2);
                        this.nota2.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                        this.nota2.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                        this.notaDao.guardarNota(this.nota2);
                    }
                }
                if (crearSupletorio) {
                    if (updateSuple) {
                        this.supletorio.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                        this.supletorio.setCalificacion(this.calificacion);
                        this.supletorio.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                        if (this.supletorio.getId() == null || this.supletorio.getId() == 0) {
                            this.supletorio.setId(null);
                        }
                        this.supletorioDao.actualizar(this.supletorio);
                    } else {
                        this.supletorio.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                        this.supletorio.setTipoExamen("S");
                        this.supletorio.setCalificacion(this.calificacion);
                        this.supletorio.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                        this.supletorioDao.guardar(this.supletorio);
                    }
                }
                String escalaCualitativa = this.calificacionVo.getPromedioAnual() == null ? "" : (!(this.calificacionVo.getPromedioAnual().compareTo(new BigDecimal(9)) != 0 && this.calificacionVo.getPromedioAnual().compareTo(new BigDecimal(9)) != 1 || this.calificacionVo.getPromedioAnual().compareTo(new BigDecimal(10)) != 0 && this.calificacionVo.getPromedioAnual().compareTo(new BigDecimal(10)) != -1) ? "DA" : ((this.calificacionVo.getPromedioAnual().compareTo(new BigDecimal(7)) == 0 || this.calificacionVo.getPromedioAnual().compareTo(new BigDecimal(7)) == 1) && this.calificacionVo.getPromedioAnual().compareTo(new BigDecimal(9)) == -1 ? "AA" : (this.calificacionVo.getPromedioAnual().compareTo(new BigDecimal(4)) == 1 && this.calificacionVo.getPromedioAnual().compareTo(new BigDecimal(7)) == -1 ? "PA" : "NA")));
                this.calificacion.setPromedioAnualEc(escalaCualitativa);
                this.calificacion.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                this.calificacion.setTipoPromedio("Q");
                this.calificacion.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                if (this.calificacion.getId() == null || this.calificacion.getId() == 0) {
                    this.calificacion.setId(null);
                }
                this.calificacionDao.actualizarCalificacion(this.calificacion);
                this.updateUI();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

