/*
 * Decompiled with CFR 0.152.
 */
package update;

import Util.Constantes;
import Util.IOUtils;
import Util.MigrateDatabase;
import Util.MsgLog;
import Util.ObtenerPropiedad;
import Util.Util;
import dto.JarDTO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.lang.exception.ExceptionUtils;

public class Main_Gui
extends JFrame {
    private static final String urlDirectorioJars = Util.rutaApp() + "/lib/";
    private static final String urlScriptsBaseDatos = Util.rutaApp() + Constantes.PATH_BASE_DATOS_MODELO;
    private Thread worker;
    private final String root = "update/";
    private JTextArea outText;
    private JButton cancle;
    private JButton launch;
    private JScrollPane sp;
    private JPanel pan1;
    private JPanel pan2;

    public Main_Gui() {
        this.initComponents();
        this.outText.setText("Conect\u00e1ndose con el servidor para la descarga de la actualizaci\u00f3n...");
        this.download();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Nueva Actualizaci\u00f3n");
        this.setLocationByPlatform(this.rootPaneCheckingEnabled);
        ImageIcon imiMinisterio = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/Imagenes/iconolibro.png")));
        this.setIconImage(imiMinisterio.getImage());
        this.pan1 = new JPanel();
        this.pan1.setLayout(new BorderLayout());
        this.pan2 = new JPanel();
        this.pan2.setLayout(new FlowLayout());
        this.outText = new JTextArea();
        this.sp = new JScrollPane();
        this.sp.setViewportView(this.outText);
        this.launch = new JButton("Ejecutar la aplicaci\u00f3n");
        this.launch.setEnabled(false);
        this.launch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main_Gui.this.launch();
            }
        });
        this.cancle = new JButton("Cancelar la actualizaci\u00f3n");
        this.cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.pan2.add(this.cancle);
        this.pan1.add((Component)this.sp, "Center");
        this.pan1.add((Component)this.pan2, "South");
        this.add(this.pan1);
        this.pack();
        this.setSize(500, 400);
    }

    private void download() {
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Main_Gui.this.downloadFile("http://pre-academico.educacion.gob.ec/app-escritorio/aplicacionDistribuir.zip");
                    Main_Gui.this.unzip();
                    Main_Gui.this.copyFiles(new File("update/"), new File("").getAbsolutePath());
                    Main_Gui.this.cleanup();
                    Main_Gui.this.launch.setEnabled(true);
                    Main_Gui.this.actualizarPlantillaBaseDatos();
                    Main_Gui.this.cleanupZip();
                    Main_Gui.this.cancle.setEnabled(false);
                    Main_Gui.this.outText.setText(Main_Gui.this.outText.getText() + "\nActualizaci\u00f3n finalizada!");
                    int confirm = JOptionPane.showOptionDialog(null, "<html><div style=\"text-align:center\">Actualizaci\u00f3n finalizada.<br/><br/>\u00bfDesea ejecutar la aplicaci\u00f3n?</div></html>", "Confirmaci\u00f3n", 0, 3, null, null, null);
                    if (confirm == 0) {
                        Main_Gui.this.launch();
                    } else {
                        System.exit(0);
                    }
                }
                catch (HeadlessException | IOException ex) {
                    JOptionPane.showMessageDialog(null, "Un error a ocurrido mientras se ejecutaba la actualizaci\u00f3n!");
                    MsgLog.write(ExceptionUtils.getStackTrace(ex));
                }
            }
        });
        this.worker.start();
    }

    private void launch() {
        String[] run = new String[]{"java", "-jar", "GestionEscolar.jar"};
        try {
            Process p = Runtime.getRuntime().exec(run);
            IOUtils.outputProcessStreams(p);
            System.exit(0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Un error a ocurrido mientras se ejecutaba la actualizaci\u00f3n!");
            MsgLog.write(ExceptionUtils.getStackTrace(ex));
        }
    }

    private void actualizarPlantillaBaseDatos() {
        boolean actualizarPlantilla = true;
        Date fechaVersionServidor = MigrateDatabase.getLastModification();
        this.encriptarDesencriptarBases(true);
        MigrateDatabase.actualizarModeloDatos(actualizarPlantilla);
        MigrateDatabase.actualizarModeloDatos(!actualizarPlantilla);
        MigrateDatabase.actualizarVersion("A", 0, fechaVersionServidor, actualizarPlantilla);
        MigrateDatabase.actualizarVersion("A", 0, fechaVersionServidor, !actualizarPlantilla);
        this.encriptarDesencriptarBases(false);
    }

    private void encriptarDesencriptarBases(boolean desencriptar) {
        try {
            if (desencriptar) {
                Util.desencriptaArchivoBB(Util.rutaApp() + Constantes.DIRECTORIO_BASE_DATOS + ObtenerPropiedad.obtenerPropiedadFile("bdd"));
                Util.desencriptaArchivoBB(Util.rutaApp() + Constantes.DIRECTORIO_BASE_DATOS + ObtenerPropiedad.obtenerPropiedadFile("plantilla"));
            } else {
                Util.encriptaArchivoBB(Util.rutaApp() + Constantes.DIRECTORIO_BASE_DATOS + ObtenerPropiedad.obtenerPropiedadFile("bdd"));
                Util.encriptaArchivoBB(Util.rutaApp() + Constantes.DIRECTORIO_BASE_DATOS + ObtenerPropiedad.obtenerPropiedadFile("plantilla"));
            }
        }
        catch (IOException e) {
            try {
                Util.encriptaArchivoBB(Util.rutaApp() + Constantes.DIRECTORIO_BASE_DATOS + ObtenerPropiedad.obtenerPropiedadFile("bdd"));
                Util.encriptaArchivoBB(Util.rutaApp() + Constantes.DIRECTORIO_BASE_DATOS + ObtenerPropiedad.obtenerPropiedadFile("plantilla"));
                MsgLog.write(ExceptionUtils.getStackTrace(e));
            }
            catch (IOException ex) {
                MsgLog.write(ExceptionUtils.getStackTrace(ex));
            }
        }
    }

    private void cleanup() {
        this.outText.setText(this.outText.getText() + "\nLimpiando versiones antiguas...");
        File f = new File("update.zip");
        f.delete();
        this.remove(new File("update/"));
        new File("update/").delete();
    }

    private void cleanupZip() {
        File f = new File("update.zip");
        f.delete();
    }

    private void remove(File f) {
        File[] files;
        for (File ff : files = f.listFiles()) {
            if (ff.isDirectory()) {
                this.remove(ff);
                ff.delete();
                continue;
            }
            ff.delete();
        }
    }

    private void copyFiles(File f, String dir) throws IOException {
        File[] files;
        for (File ff : files = f.listFiles()) {
            if (ff.isDirectory()) {
                new File(dir + "/" + ff.getName()).mkdir();
                this.copyFiles(ff, dir + "/" + ff.getName());
                continue;
            }
            this.copy(ff.getAbsolutePath(), dir + "/" + ff.getName());
        }
    }

    public void copy(String srFile, String dtFile) throws FileNotFoundException, IOException {
        int len;
        File f1 = new File(srFile);
        File f2 = new File(dtFile);
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void unzip() throws IOException {
        int BUFFER = 2048;
        BufferedOutputStream dest = null;
        BufferedInputStream is = null;
        ZipFile zipfile = new ZipFile("update.zip");
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        new File("update/").mkdir();
        while (e.hasMoreElements()) {
            int count;
            ZipEntry entry = e.nextElement();
            this.outText.setText(this.outText.getText() + "\nExtrayendo: " + entry);
            if (entry.isDirectory()) {
                new File("update/" + entry.getName()).mkdir();
                continue;
            }
            new File("update/" + entry.getName()).createNewFile();
            is = new BufferedInputStream(zipfile.getInputStream(entry));
            byte[] data = new byte[BUFFER];
            FileOutputStream fos = new FileOutputStream("update/" + entry.getName());
            dest = new BufferedOutputStream(fos, BUFFER);
            while ((count = is.read(data, 0, BUFFER)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            is.close();
        }
    }

    private void downloadFile(String link) throws MalformedURLException, IOException {
        URL url = new URL(link);
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        this.outText.setText(this.outText.getText() + "\nDescargando actualizaciones...\nPor favor espere...");
        List<JarDTO> elementosControlVersionesDesdeServidor = Util.listarElementosControlVersionesDesdeServidor();
        for (JarDTO jarDTO : Util.listaElementosParaDescargar(urlDirectorioJars, elementosControlVersionesDesdeServidor, "L")) {
            Util.descargarArchivosDesdeUrl(jarDTO.getDireccion(), urlDirectorioJars);
        }
        for (JarDTO jarDTO : Util.listaElementosParaDescargar(urlScriptsBaseDatos, elementosControlVersionesDesdeServidor, "B")) {
            Util.descargarArchivosDesdeUrl(jarDTO.getDireccion(), urlScriptsBaseDatos);
        }
        BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(new File("update.zip")));
        byte[] buffer = new byte[32768];
        int bytesRead = 0;
        int in = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            in += bytesRead;
            fOut.write(buffer, 0, bytesRead);
        }
        fOut.flush();
        fOut.close();
        is.close();
        this.outText.setText(this.outText.getText() + "\nDescarga completa!");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Main_Gui().setVisible(true);
            }
        });
    }
}

