/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.customizer;

import datechooser.beans.customizer.PropertyDescriptorsHolder;
import datechooser.beans.customizer.PropertyTableModel;
import datechooser.beans.customizer.edit.PropertyCellEditor;
import datechooser.beans.customizer.render.CaptionCellRenderer;
import datechooser.beans.customizer.render.ValueCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DateChooserCustomizer
extends JPanel
implements Customizer,
PropertyChangeListener {
    private PropertyDescriptorsHolder holder;
    private JTextArea description;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private JTable table;

    public DateChooserCustomizer(BeanInfo beanInfo) throws IntrospectionException {
        this.holder = new PropertyDescriptorsHolder(beanInfo);
        this.getHolder().addPropertyChangeListener(this);
        this.setLayout(new BorderLayout(2, 2));
        this.description = new JTextArea("");
        this.description.setRows(2);
        this.description.setEditable(false);
        this.description.setWrapStyleWord(true);
        this.description.setLineWrap(true);
        this.description.setOpaque(false);
        this.table = new JTable(new PropertyTableModel(this.getHolder()));
        this.table.setRowHeight(20);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(1).setCellEditor(new PropertyCellEditor(this.getHolder()));
        this.table.setDefaultRenderer(CaptionCellRenderer.class, new CaptionCellRenderer(this.getHolder()));
        this.table.setDefaultRenderer(ValueCellRenderer.class, new ValueCellRenderer(this.getHolder()));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DateChooserCustomizer.this.updateDescriptor();
            }
        });
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)new JScrollPane(this.description), "South");
    }

    public BeanInfo getBeanInfo() {
        return this.getHolder().getBeanInfo();
    }

    private void updateDescriptor() {
        PropertyDescriptor propDescr = this.getHolder().getPropertydescriptor(this.getSelectedProperty());
        String text = propDescr.getShortDescription();
        if (text == null) {
            text = propDescr.getDisplayName();
        }
        if (text == null) {
            text = propDescr.getName();
        }
        this.description.setText(text);
    }

    private String getSelectedProperty() {
        return (String)this.table.getValueAt(this.table.getSelectedRow(), 0);
    }

    public void setObject(Object bean) {
        this.getHolder().prepareForBean(bean);
    }

    public PropertyDescriptorsHolder getHolder() {
        return this.holder;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.changeSupport.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }
}

