/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.appear;

import datechooser.beans.editor.appear.AppearEditor;
import datechooser.beans.editor.backrender.BackRendererEditor;
import datechooser.beans.editor.cell.CellViewEditor;
import datechooser.beans.editor.utils.EditorDialog;
import datechooser.beans.locale.LocaleUtils;
import datechooser.controller.EventHandler;
import datechooser.events.CursorMoveEvent;
import datechooser.events.CursorMoveListener;
import datechooser.model.FooModel;
import datechooser.view.BackRenderer;
import datechooser.view.GridPane;
import datechooser.view.appearance.AppearancesList;
import datechooser.view.appearance.CellAppearance;
import datechooser.view.appearance.ViewAppearance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AppearEditorPane
extends JPanel
implements PropertyChangeListener,
CursorMoveListener {
    private String[] cellTypes = new String[]{LocaleUtils.getEditorLocaleString("disabled"), LocaleUtils.getEditorLocaleString("usual"), LocaleUtils.getEditorLocaleString("selected"), LocaleUtils.getEditorLocaleString("now"), LocaleUtils.getEditorLocaleString("scroll"), LocaleUtils.getEditorLocaleString("caption")};
    private AppearEditor editor;
    private FooModel model;
    private JComboBox cellViews;
    private boolean autoEdit;
    private EditorDialog eDialog;
    private EditorDialog bDialog;
    private GridPane gp;
    private boolean tempEdit;
    private JComboBox views;
    private JButton bEditCellView;
    private JButton bDeleteCellView;
    private JButton bSetBackPicture;

    public AppearEditorPane(AppearEditor editor) {
        LocaleUtils.prepareStandartDialogButtonText();
        this.setEditor(editor);
        this.setAutoEdit(false);
        this.model = new FooModel();
        this.model.addCursorMoveListener(this);
        this.cellViews = this.createCellTypeCombo();
        this.gp = this.createGridPane();
        this.eDialog = new EditorDialog((Frame)this.getParent(), new CellViewEditor());
        this.bDialog = new EditorDialog((Frame)this.getParent(), new BackRendererEditor());
        JPanel control = new JPanel(new GridLayout(2, 4, 5, 5));
        this.bSetBackPicture = this.createBackRendererButton();
        this.createCellEditorButton();
        this.createDeleteViewButton();
        control.add(new JLabel(LocaleUtils.getEditorLocaleString("View"), 4));
        control.add(this.createViewManagerCombo());
        control.add(this.createNewViewButton());
        control.add(this.bDeleteCellView);
        control.add(new JLabel(LocaleUtils.getEditorLocaleString("Cell"), 4));
        control.add(this.cellViews);
        control.add(this.bEditCellView);
        control.add(this.bSetBackPicture);
        this.setLayout(new BorderLayout());
        this.add((Component)control, "North");
        this.add((Component)this.gp, "Center");
    }

    private JPanel getEditorPane() {
        return this;
    }

    private JButton createDeleteViewButton() {
        this.bDeleteCellView = new JButton(LocaleUtils.getEditorLocaleString("Delete"));
        this.bDeleteCellView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selViewName = AppearEditorPane.this.getAppList().getCurrent().getName();
                int ans = JOptionPane.showConfirmDialog(AppearEditorPane.this.getEditorPane().getParent(), MessageFormat.format(LocaleUtils.getEditorLocaleString("Delete_view_prompt"), selViewName), LocaleUtils.getEditorLocaleString("Confirm_delete"), 0);
                if (ans == 0) {
                    if (AppearEditorPane.this.getAppList().unRegisterAppearance(selViewName)) {
                        AppearEditorPane.this.getAppList().setCurrent(AppearancesList.DEFAULT);
                        AppearEditorPane.this.updateEditable();
                        AppearEditorPane.this.refreshViews();
                        AppearEditorPane.this.fireLocalPropertyChange();
                    } else {
                        JOptionPane.showMessageDialog(AppearEditorPane.this.getEditorPane().getParent(), MessageFormat.format(LocaleUtils.getEditorLocaleString("Cant_delete_view"), selViewName), LocaleUtils.getEditorLocaleString("Undelitable_view"), 0);
                    }
                }
            }
        });
        return this.bDeleteCellView;
    }

    private JComboBox createViewManagerCombo() {
        Object mm = null;
        this.views = new JComboBox(new ViewListModel());
        this.updateEditable();
        this.views.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppearEditorPane.this.getAppList().setCurrent((String)AppearEditorPane.this.views.getSelectedItem());
                AppearEditorPane.this.updateEditable();
                AppearEditorPane.this.gp.repaint();
            }
        });
        return this.views;
    }

    private JButton createBackRendererButton() {
        JButton button = new JButton(LocaleUtils.getEditorLocaleString("BackRenderer"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewAppearance currentAppearance = AppearEditorPane.this.getAppList().getCurrent();
                BackRenderer newValue = (BackRenderer)AppearEditorPane.this.bDialog.showDialog(currentAppearance.getRenderer(), LocaleUtils.getEditorLocaleString("BackRenderer"));
                if (!AppearEditorPane.this.bDialog.isCanceled()) {
                    currentAppearance.setRenderer(newValue);
                    AppearEditorPane.this.fireLocalPropertyChange();
                }
                AppearEditorPane.this.gp.repaint();
            }
        });
        return button;
    }

    private void updateEditable() {
        ViewAppearance currentAppearance = this.getAppList().getCurrent();
        this.bEditCellView.setEnabled(currentAppearance.isEditable());
        this.bDeleteCellView.setEnabled(currentAppearance.isEditable());
        this.bSetBackPicture.setEnabled(currentAppearance.isSupportsTransparency() && currentAppearance.isEditable());
    }

    private void refreshViews() {
        this.views.revalidate();
        this.views.repaint();
    }

    private void registerViewAppearance(String newViewName) {
        ViewAppearance newApp = (ViewAppearance)this.getAppList().getCurrent().clone();
        newApp.setName(newViewName);
        newApp.setEditable(true);
        this.getAppList().registerAppearance(newApp);
        this.getAppList().setCurrent(newViewName);
        this.views.setSelectedItem(newViewName);
        this.fireLocalPropertyChange();
        this.refreshViews();
    }

    private JButton createNewViewButton() {
        JButton bSave = new JButton(LocaleUtils.getEditorLocaleString("Create_view_clone"));
        bSave.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void actionPerformed(ActionEvent e) {
                String newViewName = JOptionPane.showInputDialog(LocaleUtils.getEditorLocaleString("View_name_prompt"));
                if (newViewName == null) {
                    return;
                }
                if (AppearEditorPane.this.getAppList().isRegistered(newViewName)) {
                    int ans = JOptionPane.showConfirmDialog(AppearEditorPane.this.getEditorPane().getParent(), MessageFormat.format(LocaleUtils.getEditorLocaleString("View_exist_prompt"), newViewName), LocaleUtils.getEditorLocaleString("Existing_view"), 0);
                    if (ans != 0) return;
                    if (AppearEditorPane.this.getAppList().getAppearance(newViewName).isEditable()) {
                        AppearEditorPane.this.getAppList().unRegisterAppearance(newViewName);
                    } else {
                        JOptionPane.showMessageDialog(AppearEditorPane.this.getEditorPane().getParent(), MessageFormat.format(LocaleUtils.getEditorLocaleString("Cant_replace_view"), newViewName), LocaleUtils.getEditorLocaleString("Uneditable_view"), 0);
                        return;
                    }
                }
                AppearEditorPane.this.registerViewAppearance(newViewName);
            }
        });
        return bSave;
    }

    private void generateClonedValue() {
        if (this.isTempEdit()) {
            return;
        }
        this.setTempEdit(true);
        this.getEditor().setInnerValue(this.getAppList().notDeepClone());
        this.gp.setAppearanceList(this.getAppList());
        this.setTempEdit(false);
    }

    private void fireLocalPropertyChange() {
        this.getEditor().firePropertyChange();
    }

    private CellAppearance getEditing() {
        ViewAppearance curApp = this.getAppList().getCurrent();
        switch (this.cellViews.getSelectedIndex()) {
            case 0: {
                return curApp.getDisabled();
            }
            case 1: {
                return curApp.getUsual();
            }
            case 2: {
                return curApp.getSelected();
            }
            case 3: {
                return curApp.getNow();
            }
            case 4: {
                return curApp.getScroll();
            }
            case 5: {
                return curApp.getCaption();
            }
        }
        return null;
    }

    private JButton createCellEditorButton() {
        this.bEditCellView = new JButton(LocaleUtils.getEditorLocaleString("Edit"));
        this.bEditCellView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellAppearance newValue = (CellAppearance)AppearEditorPane.this.eDialog.showDialog(AppearEditorPane.this.getEditing(), MessageFormat.format(LocaleUtils.getEditorLocaleString("Edit_cell"), AppearEditorPane.this.cellViews.getSelectedItem()));
                if (!AppearEditorPane.this.eDialog.isCanceled()) {
                    AppearEditorPane.this.getEditing().assign(newValue);
                    AppearEditorPane.this.fireLocalPropertyChange();
                }
                AppearEditorPane.this.gp.repaint();
            }
        });
        return this.bEditCellView;
    }

    private JComboBox createCellTypeCombo() {
        this.cellViews = new JComboBox<String>(this.cellTypes);
        this.cellViews.setSelectedIndex(5);
        this.cellViews.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AppearEditorPane.this.isAutoEdit()) {
                    return;
                }
                AppearEditorPane.this.setAutoEdit(true);
                AppearEditorPane.this.model.setTypeSelected(AppearEditorPane.this.cellViews.getSelectedIndex());
                AppearEditorPane.this.setAutoEdit(false);
            }
        });
        return this.cellViews;
    }

    private GridPane createGridPane() {
        GridPane gp = new GridPane(this.getAppList());
        gp.setFocusable(false);
        gp.setFocused(true);
        gp.setPreferredSize(new Dimension(200, 200));
        gp.setModel(this.model);
        gp.setController(new EventHandler());
        return gp;
    }

    public AppearEditor getEditor() {
        return this.editor;
    }

    public void setEditor(AppearEditor editor) {
        if (this.getEditor() != null) {
            this.getEditor().removePropertyChangeListener(this);
        }
        this.editor = editor;
        this.setTempEdit(false);
        if (this.getEditor() != null) {
            this.getEditor().addPropertyChangeListener(this);
        }
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setAutoEdit(boolean autoEdit) {
        this.autoEdit = autoEdit;
    }

    public boolean isTempEdit() {
        return this.tempEdit;
    }

    public void setTempEdit(boolean tempEdit) {
        this.tempEdit = tempEdit;
    }

    private AppearancesList getAppList() {
        return this.getEditor().getAppearancesList();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.generateClonedValue();
        this.gp.repaint();
    }

    public void onCursorMove(CursorMoveEvent evt) {
        if (this.isAutoEdit()) {
            return;
        }
        this.setAutoEdit(true);
        if (!this.model.isSomeSelected()) {
            return;
        }
        int index = 0;
        switch (this.model.getSelectedCellState()) {
            case NORMAL: {
                index = 1;
                break;
            }
            case SELECTED: {
                index = 2;
                break;
            }
            case NOW: {
                index = 3;
                break;
            }
            case NORMAL_SCROLL: {
                index = 4;
                break;
            }
            case UNACCESSIBLE: {
                index = 0;
            }
        }
        this.cellViews.setSelectedIndex(index);
        this.setAutoEdit(false);
    }

    class ViewListModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        public ViewListModel() {
            AppearEditorPane.this.getEditor().addPropertyChangeListener(this);
        }

        public void setSelectedItem(Object anItem) {
            String itemName = (String)anItem;
            AppearEditorPane.this.getAppList().setCurrent(itemName);
        }

        public Object getSelectedItem() {
            return AppearEditorPane.this.getAppList().getCurrent().getName();
        }

        public int getSize() {
            return AppearEditorPane.this.getAppList().getRegisteredCount();
        }

        public Object getElementAt(int index) {
            return AppearEditorPane.this.getAppList().getRegisteredNames()[index];
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }
}

