/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.border.types;

import datechooser.beans.editor.border.types.AbstractBorderEditor;
import datechooser.beans.editor.utils.ColorChooseAction;
import datechooser.beans.editor.utils.ColorHolder;
import datechooser.beans.editor.utils.SpinPane;
import datechooser.beans.locale.LocaleUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LineBorderEditor
extends AbstractBorderEditor
implements PropertyChangeListener {
    private static int MIN_THICK = 1;
    private static int MAX_THICK = 20;
    private ColorHolder color;
    private int thickness;
    private boolean roundedCorners;
    private JCheckBox rounded;
    private SpinnerNumberModel thickModel;

    public LineBorderEditor() {
        this.initialize();
        this.color = new ColorHolder();
        this.setCaption(LocaleUtils.getEditorLocaleString("Line"));
        this.assignValueToParameters();
        this.rounded = new JCheckBox(LocaleUtils.getEditorLocaleString("Rounded_corners"));
        this.rounded.setSelected(this.roundedCorners);
        this.rounded.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineBorderEditor.this.roundedCorners = LineBorderEditor.this.rounded.isSelected();
                LineBorderEditor.this.fireChange();
            }
        });
        this.thickModel = new SpinnerNumberModel(this.thickness, MIN_THICK, MAX_THICK, 1);
        SpinPane thickPane = new SpinPane(this.thickModel, LocaleUtils.getEditorLocaleString("Thickness"));
        this.thickModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LineBorderEditor.this.thickness = LineBorderEditor.this.thickModel.getNumber().intValue();
                LineBorderEditor.this.fireChange();
            }
        });
        JButton bColor = new JButton(LocaleUtils.getEditorLocaleString("Color"));
        ColorChooseAction colorChooseAction = new ColorChooseAction(this.color, LocaleUtils.getEditorLocaleString("Color"), this);
        colorChooseAction.addPropertyChangeListener(this);
        bColor.addActionListener(colorChooseAction);
        this.setLayout(new BorderLayout());
        JPanel pane = new JPanel(new GridLayout(1, 2));
        pane.add(this.getCenteredPane(this.rounded));
        pane.add(this.getCenteredPane(thickPane));
        JPanel paneTotal = new JPanel(new GridLayout(2, 1));
        paneTotal.add(pane);
        paneTotal.add(this.getCenteredPane(bColor));
        this.add((Component)paneTotal, "North");
        this.refreshInterface();
    }

    protected void prepareSelection() {
        this.setValue(new LineBorder(this.color.getColor(), this.thickness, this.roundedCorners));
    }

    private void assignValueToParameters() {
        this.color.setColor(this.getValue().getLineColor());
        this.thickness = this.getValue().getThickness();
        this.roundedCorners = this.getValue().getRoundedCorners();
    }

    protected LineBorder getValue() {
        return (LineBorder)this.value;
    }

    public void refreshInterface() {
        this.assignValueToParameters();
        this.rounded.setSelected(this.roundedCorners);
        this.thickModel.setValue(new Integer(this.thickness));
    }

    protected Border getDefaultValue() {
        return new LineBorder(Color.BLACK);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!"color".equals(evt.getPropertyName())) {
            return;
        }
        this.fireChange();
    }
}

