/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.font;

import datechooser.beans.editor.utils.TextOutput;
import datechooser.beans.locale.LocaleUtils;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class FontPreviewPane
extends JPanel {
    private String sampleText;
    private Font font;
    private Rectangle bounds;

    public FontPreviewPane(Font font) {
        this.setFont(font);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setSampleText(LocaleUtils.getEditorLocaleString("sample_text"));
    }

    public String getSampleText() {
        return this.sampleText;
    }

    public void setSampleText(String sampleText) {
        this.sampleText = sampleText;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.bounds = this.getBounds();
        TextOutput.paintBoxed(g, this.bounds, this.getSampleText(), this.getFont());
    }
}

