/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.utils;

import datechooser.beans.locale.LocaleUtils;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RiseLowPanel
extends JPanel {
    private int raisedValue;
    private int loweredValue;
    JRadioButton bRaised;
    JRadioButton bLowered;

    public RiseLowPanel(int value, int raisedValue, int loweredValue) {
        this.setRaisedValue(raisedValue);
        this.setLoweredValue(loweredValue);
        ButtonGroup bType = new ButtonGroup();
        this.bRaised = new JRadioButton(LocaleUtils.getEditorLocaleString("Raised"));
        this.bLowered = new JRadioButton(LocaleUtils.getEditorLocaleString("Lowered"));
        bType.add(this.bRaised);
        bType.add(this.bLowered);
        this.setLayout(new FlowLayout(1));
        this.add(this.bRaised);
        this.add(this.bLowered);
        this.setType(value);
    }

    public void addActionListener(ActionListener listener) {
        this.bRaised.addActionListener(listener);
        this.bLowered.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.bRaised.removeActionListener(listener);
        this.bLowered.removeActionListener(listener);
    }

    public int getType() {
        if (this.bRaised.isSelected()) {
            return this.getRaisedValue();
        }
        return this.getLoweredValue();
    }

    public void setType(int type) {
        this.bRaised.setSelected(type == this.getRaisedValue());
        this.bLowered.setSelected(type == this.getLoweredValue());
    }

    public int getRaisedValue() {
        return this.raisedValue;
    }

    public void setRaisedValue(int raisedValue) {
        this.raisedValue = raisedValue;
    }

    public int getLoweredValue() {
        return this.loweredValue;
    }

    public void setLoweredValue(int loweredValue) {
        this.loweredValue = loweredValue;
    }
}

