/*
 * Decompiled with CFR 0.152.
 */
package datechooser.controller;

import datechooser.controller.DateChooseController;
import datechooser.controller.GridSelection;
import datechooser.model.DateChoose;
import datechooser.view.GridPane;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;

public class EventHandler
implements MouseListener,
MouseMotionListener,
KeyListener,
DateChooseController,
MouseWheelListener,
Serializable {
    private Rectangle gridBounds;
    private GridSelection tempSel = new GridSelection();
    private GridPane view;
    private boolean mouseDown = false;
    private boolean dragging;
    private boolean dragStarted;
    private boolean autoScroll;
    private int previousLocation;
    private int previousKey;
    private long previousTime;

    public EventHandler() {
        this.setDragging(false);
        this.setDragStarted(false);
        this.previousLocation = 0;
        this.previousKey = 0;
        this.previousTime = 0L;
    }

    public void reBound() {
        this.gridBounds = this.getView().getBounds();
    }

    private GridSelection getCell(int x, int y) {
        this.tempSel.setColumn(x / (this.gridBounds.width / this.getView().getModel().getColsCount()));
        this.tempSel.setRow(y / (this.gridBounds.height / (this.getView().getModel().getRowsCount() + 1)));
        return this.tempSel;
    }

    protected void doSelect(MouseEvent e) {
        GridSelection sel = this.getCell(e.getX(), e.getY());
        if (sel.getRow() == 0) {
            return;
        }
        if (this.getModel().select(sel.getRow() - 1, sel.getColumn()) && !EventHandler.isMask(e.getModifiersEx(), 512)) {
            this.getModel().tryApplySelection();
        }
        this.getView().requestFocus();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.getModel().commit();
            return;
        }
        this.doSelect(e);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.setDragging(false);
        this.setDragStarted(false);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.setDragging(false);
        this.setDragStarted(false);
    }

    public void mouseDragged(MouseEvent e) {
        this.setDragging(true);
        this.doSelect(e);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void setView(GridPane palette) {
        this.view = palette;
        palette.addMouseListener(this);
        palette.addMouseMotionListener(this);
        palette.addKeyListener(this);
        palette.addMouseWheelListener(this);
    }

    public GridPane getView() {
        return this.view;
    }

    public DateChoose getModel() {
        return this.getView().getModel();
    }

    private boolean isDuplet(int key, int keyLocation) {
        boolean result;
        if (this.previousTime == 0L) {
            this.previousTime = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.previousTime > 130L) {
            this.previousTime = System.currentTimeMillis();
            this.previousKey = key;
            this.previousLocation = keyLocation;
            return false;
        }
        boolean bl = result = key == this.previousKey && keyLocation != this.previousLocation;
        if (!result) {
            this.previousKey = key;
            this.previousLocation = keyLocation;
        }
        return result;
    }

    protected void doShift(KeyEvent e) {
        int code = e.getKeyCode();
        if (this.isDuplet(code, e.getKeyLocation())) {
            return;
        }
        switch (code) {
            case 38: {
                this.getModel().shift(-1, 0);
                break;
            }
            case 40: {
                this.getModel().shift(1, 0);
                break;
            }
            case 37: {
                this.getModel().shift(0, -1);
                break;
            }
            case 39: {
                this.getModel().shift(0, 1);
                break;
            }
            case 34: {
                this.getModel().monthShift(-1);
                break;
            }
            case 33: {
                this.getModel().monthShift(1);
                break;
            }
            case 35: {
                this.getModel().yearShift(-1);
                break;
            }
            case 36: {
                this.getModel().yearShift(1);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        this.doShift(e);
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.getModel().tryApplySelection();
        }
        if (e.getKeyCode() == 10) {
            this.getModel().commit();
        }
    }

    protected boolean isDragging() {
        return this.dragging;
    }

    protected void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    protected boolean isDragStarted() {
        return this.dragStarted;
    }

    protected void setDragStarted(boolean dragStarted) {
        if (!dragStarted && this.isDragStarted()) {
            this.onDragEnd();
        }
        this.dragStarted = dragStarted;
        if (dragStarted) {
            this.onDragStart();
        }
    }

    protected void onDragStart() {
        this.setAutoScroll(this.getModel().isAutoScroll());
        this.getModel().setAutoScroll(false);
    }

    protected void onDragEnd() {
        this.getModel().setAutoScroll(this.isAutoScroll());
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.getModel().shift(0, e.getWheelRotation() < 0 ? -1 : 1);
    }

    public static boolean isMask(int modifier, int mask) {
        return (modifier & mask) == mask;
    }
}

