/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view;

import datechooser.view.AbstractNavigatePane;
import datechooser.view.pic.ViewPictures;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ComboNavigatePane
extends AbstractNavigatePane {
    private static int YEAR_SHIFT = 10000;
    private JComboBox months = new JComboBox();
    private JSpinner year;
    private Calendar curDate;
    private SpinnerNumberModel yearModel = new SpinnerNumberModel();
    private JButton nullButton;

    public ComboNavigatePane() {
        this.year = new JSpinner(this.yearModel);
        this.nullButton = this.createNullButton();
        this.yearModel.setStepSize(1);
        this.setLayout(new BorderLayout());
        JPanel mainPane = new JPanel(new GridLayout(1, 2));
        mainPane.add(this.months);
        mainPane.add(this.year);
        this.add((Component)mainPane, "Center");
        this.add((Component)this.nullButton, "West");
        this.editedManually = false;
        this.initMonthList();
        AbstractNavigatePane.OnShowChange listener = new AbstractNavigatePane.OnShowChange();
        this.months.addActionListener(listener);
        this.year.addChangeListener(listener);
        this.months.setEditable(false);
    }

    private JButton createNullButton() {
        JButton newNullButton = new JButton(new ImageIcon(ViewPictures.class.getResource("nothing.gif")));
        newNullButton.setFocusable(false);
        newNullButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComboNavigatePane.this.getModel().selectNothing();
            }
        });
        return newNullButton;
    }

    public int getMonth() {
        return this.months.getSelectedIndex();
    }

    public int getYear() {
        return (Integer)this.yearModel.getValue();
    }

    public void setMonth(int aMonth) {
        this.months.setSelectedIndex(aMonth);
    }

    public void setYear(int aYear) {
        this.yearModel.setValue(aYear);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.months.setEnabled(enabled);
        this.year.setEnabled(enabled);
        this.nullButton.setEnabled(this.isNothingSelectEnabled() ? enabled : false);
    }

    public Font getFont() {
        if (this.year == null || this.months == null || this.nullButton == null) {
            return null;
        }
        return this.months.getFont();
    }

    public void setFont(Font font) {
        if (this.year == null || this.months == null) {
            return;
        }
        try {
            ((JSpinner.DefaultEditor)this.year.getEditor()).getTextField().setFont(font);
        }
        catch (ClassCastException ex) {
            this.year.setFont(font);
        }
        this.months.setFont(font);
        this.nullButton.setFont(font);
    }

    public void updateMonthControl() {
        if (this.months == null) {
            return;
        }
        int selected = this.months.getSelectedIndex();
        this.months.removeAllItems();
        for (int i = 0; i < 12; ++i) {
            this.months.addItem(this.monthsList[i]);
        }
        this.months.validate();
        this.months.setSelectedIndex(selected);
    }

    public void applyNothingSelectEnabled(boolean enabled) {
        this.nullButton.setEnabled(enabled);
    }
}

