/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view.appearance;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.Serializable;

public abstract class CellRenderer
implements Serializable {
    private static final int CURSOR_PART = 5;
    private static final int CURSOR_SHIFT = 2;
    private static final int CURSOR_BOLD = 3;
    private static final BasicStroke boldStroke = new BasicStroke(2.0f);
    private static final BasicStroke usualStroke = new BasicStroke(1.0f);
    private static Stroke savedStroke;

    public abstract void render(Graphics2D var1, Component var2, String var3, int var4, int var5, boolean var6);

    public void render(Graphics2D g, Component c, String text, int width, int height) {
        this.render(g, c, text, width, height, false);
    }

    protected void paintCursor(Graphics2D g2d, Rectangle rec, Color color) {
        g2d.setColor(color);
        int minSize = rec.height < rec.width ? rec.height : rec.width;
        int cursorSize = minSize / 5;
        savedStroke = g2d.getStroke();
        if (cursorSize > 3) {
            g2d.setStroke(boldStroke);
        } else {
            g2d.setStroke(usualStroke);
        }
        int cursorShift = 2;
        int x = rec.x + cursorShift;
        int y = rec.y + cursorShift;
        g2d.drawLine(x, y, x + cursorSize, y);
        g2d.drawLine(x, y, x, y + cursorSize);
        x = rec.x + rec.width - cursorShift;
        y = rec.y + cursorShift;
        g2d.drawLine(x, y, x - cursorSize, y);
        g2d.drawLine(x, y, x, y + cursorSize);
        x = rec.x + rec.width - cursorShift;
        y = rec.y + rec.height - cursorShift;
        g2d.drawLine(x, y, x - cursorSize, y);
        g2d.drawLine(x, y, x, y - cursorSize);
        x = rec.x + cursorShift;
        y = rec.y + rec.height - cursorShift;
        g2d.drawLine(x, y, x + cursorSize, y);
        g2d.drawLine(x, y, x, y - cursorSize);
        g2d.setStroke(savedStroke);
    }
}

