/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ModelSpan {
    private final Set<String> columns = new HashSet<String>();
    private final String valueColumn;
    private final String idColumn;
    private boolean drawAsHeader;

    public ModelSpan(String idColumn, String valueColumn) {
        this.idColumn = idColumn;
        this.valueColumn = valueColumn;
    }

    public boolean isDrawAsHeader() {
        return this.drawAsHeader;
    }

    public void setDrawAsHeader(boolean drawAsHeader) {
        this.drawAsHeader = drawAsHeader;
    }

    public ModelSpan withDrawAsHeader(boolean drawAsHeader) {
        this.setDrawAsHeader(drawAsHeader);
        return this;
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public Set<String> getColumns() {
        return this.columns;
    }

    public ModelSpan withColumn(String column) {
        this.columns.add(column);
        return this;
    }

    public ModelSpan withColumns(String ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("Span of columns [");
        boolean added = false;
        for (String column : this.columns) {
            if (added) {
                ret.append(',');
            }
            ret.append(' ').append(column);
            added = true;
        }
        if (added) {
            ret.append(' ');
        }
        ret.append("] identified by ").append(this.idColumn).append(" showing value of ").append(this.valueColumn);
        if (this.drawAsHeader) {
            ret.append(" drawn as header");
        }
        return ret.toString();
    }
}

