/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.view;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;

public class JBroTableModel
extends AbstractTableModel {
    protected ModelData data;

    public JBroTableModel(ModelData data) {
        this.data = data;
    }

    public ModelData getData() {
        return this.data;
    }

    public void setData(ModelData data) {
        boolean structureChanged;
        if (data == null) {
            if (this.data == null) {
                return;
            }
            structureChanged = true;
        } else if (this.data == null) {
            structureChanged = true;
        } else {
            ModelField[] df1 = data.getFields();
            ModelField[] df2 = this.data.getFields();
            if (df1 == null) {
                structureChanged = df2 != null;
            } else if (df2 == null || df1.length != df2.length) {
                structureChanged = true;
            } else {
                structureChanged = false;
                for (int i = 0; i < df1.length; ++i) {
                    ModelField f1 = df1[i];
                    ModelField f2 = df2[i];
                    if (f1 == null) {
                        if (f2 == null) continue;
                        structureChanged = true;
                        break;
                    }
                    if (f2 != null && f1.equals(f2) && f1.isVisible() == f2.isVisible() && f1.isFixed() == f2.isFixed()) continue;
                    structureChanged = true;
                    break;
                }
            }
        }
        this.data = data;
        if (structureChanged) {
            this.fireTableStructureChanged();
        } else if (data != null) {
            this.fireTableChanged(new TableModelEvent(this, 0, Integer.MAX_VALUE));
        }
    }

    public void removeRow(int row) throws IndexOutOfBoundsException {
        this.data.removeRow(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void addRow(Object[] rowData) {
        int row = this.data.getRowsCount();
        this.data.addRow(rowData);
        this.fireTableRowsInserted(row, row);
    }

    public void addColumn(String addTo, IModelFieldGroup column) throws IllegalArgumentException, ClassCastException {
        this.setData(this.data.withField(addTo, column));
    }

    public void removeColumn(String id) throws IllegalArgumentException {
        this.setData(this.data.withoutField(id));
    }

    @Override
    public int getColumnCount() {
        return this.data == null ? 0 : this.data.getFieldsCount();
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.getRowsCount();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.data == null) {
            return;
        }
        this.data.setValue(row, column, value);
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.data == null ? null : this.data.getValue(row, column);
    }

    @Override
    public String getColumnName(int column) {
        if (this.data == null) {
            return null;
        }
        ModelField[] fields = this.data.getFields();
        if (fields == null || column >= fields.length) {
            return null;
        }
        ModelField field = fields[column];
        return field == null ? null : field.getCaption();
    }
}

