/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.LRUCache;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.model.ModelSpan;
import org.quinto.swing.table.model.Utils;
import org.quinto.swing.table.view.JBroTable;
import org.quinto.swing.table.view.JBroTableColumn;
import org.quinto.swing.table.view.JBroTableColumnModel;
import org.quinto.swing.table.view.JBroTableHeader;
import org.quinto.swing.table.view.JBroTableHeaderUI;

public class JBroTableUI
extends BasicTableUI {
    private final Map<String, Map<String, ModelSpan>> spans = new HashMap<String, Map<String, ModelSpan>>();
    private boolean[][] spanCoveredCells = new boolean[0][0];
    private final JTableHeader innerHeader = new JTableHeader();
    private boolean noDefaults;
    private volatile boolean rowsScrolling;
    private final LRUCache<List<Object>, Image> cellImagesCache = new LRUCache(1000);
    private Image draggedAreaCache;
    private boolean cacheUsed = true;

    public void clearCellImagesCache() {
        if (!this.cellImagesCache.isEmpty()) {
            this.cellImagesCache.clear();
        }
    }

    public void clearDraggedAreaCache() {
        this.draggedAreaCache = null;
    }

    public boolean isCacheUsed() {
        return this.cacheUsed;
    }

    public void setCacheUsed(boolean cacheUsed) {
        this.cacheUsed = cacheUsed;
        if (!cacheUsed) {
            this.rowsScrolling = true;
            this.clearCellImagesCache();
            this.clearDraggedAreaCache();
        }
    }

    void setRowsScrolling(boolean rowsScrolling) {
        if (!this.isCacheUsed()) {
            rowsScrolling = true;
        }
        if (!this.rowsScrolling && rowsScrolling) {
            this.clearCellImagesCache();
        }
        this.rowsScrolling = rowsScrolling;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        int rowCount = this.table.getRowCount();
        int columnCount = this.table.getColumnCount();
        if (rowCount <= 0 || columnCount <= 0 || !bounds.intersects(clip)) {
            this.paintDropLines(g);
            return;
        }
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1 || rMax >= rowCount) {
            rMax = rowCount - 1;
        }
        int cMin = this.table.columnAtPoint(upperLeft);
        int cMax = this.table.columnAtPoint(lowerRight);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1 || cMax >= columnCount) {
            cMax = columnCount - 1;
        }
        JBroTableColumnModel cm = (JBroTableColumnModel)this.table.getColumnModel();
        boolean hasAnySpans = false;
        for (int column = cMin; column <= cMax; ++column) {
            JBroTableColumn aColumn = cm.getColumn(column);
            String columnName = aColumn.getIdentifier();
            if (!this.spans.containsKey(columnName)) continue;
            hasAnySpans = true;
            break;
        }
        if (hasAnySpans) {
            if (this.spanCoveredCells.length <= rMax - rMin || this.spanCoveredCells.length > 0 && this.spanCoveredCells[0].length <= cMax - cMin) {
                this.spanCoveredCells = new boolean[rMax - rMin + 1][cMax - cMin + 1];
            } else {
                for (int i = rMax - rMin; i >= 0; --i) {
                    Arrays.fill(this.spanCoveredCells[i], 0, cMax - cMin + 1, false);
                }
            }
        }
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax, hasAnySpans);
        this.paintDropLines(g);
    }

    private void paintDropLines(Graphics g) {
        JTable.DropLocation loc = this.table.getDropLocation();
        if (loc == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color shortColor = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && shortColor == null) {
            return;
        }
        Rectangle rect = this.getHDropLineRect(loc);
        if (rect != null) {
            int x = rect.x;
            int w = rect.width;
            if (color != null) {
                this.extendRect(rect, true);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertColumn() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(x, rect.y, w, rect.height);
            }
        }
        if ((rect = this.getVDropLineRect(loc)) != null) {
            int y = rect.y;
            int h = rect.height;
            if (color != null) {
                this.extendRect(rect, false);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertRow() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(rect.x, y, rect.width, h);
            }
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return null;
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        if (col >= this.table.getColumnCount()) {
            --col;
        }
        Rectangle rect = this.table.getCellRect(row, col, true);
        if (row >= this.table.getRowCount()) {
            Rectangle prevRect = this.table.getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return null;
        }
        int col = loc.getColumn();
        Rectangle rect = this.table.getCellRect(loc.getRow(), col, true);
        if (col >= this.table.getColumnCount()) {
            rect = this.table.getCellRect(loc.getRow(), --col, true);
            rect.x += rect.width;
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
        return rect;
    }

    private Rectangle extendRect(Rectangle rect, boolean horizontal) {
        if (rect == null) {
            return rect;
        }
        if (horizontal) {
            rect.x = 0;
            rect.width = this.table.getWidth();
        } else {
            rect.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle lastRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rect.height = lastRect.y + lastRect.height;
            } else {
                rect.height = this.table.getHeight();
            }
        }
        return rect;
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        block6: {
            int x;
            g.setColor(this.table.getGridColor());
            Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
            Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            if (this.table.getShowHorizontalLines()) {
                int tableWidth = damagedArea.x + damagedArea.width;
                int y = damagedArea.y;
                for (int row = rMin; row <= rMax; ++row) {
                    g.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
                }
            }
            if (!this.table.getShowVerticalLines()) break block6;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                x = damagedArea.x;
                for (int column = cMax; column >= cMin; --column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            }
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax, boolean hasAnySpans) {
        Rectangle focusedRegion;
        JBroTableHeader header = (JBroTableHeader)this.table.getTableHeader();
        JBroTableColumn draggedColumn = header == null ? null : header.getDraggedGroup();
        JBroTableColumnModel cm = (JBroTableColumnModel)this.table.getColumnModel();
        IModelFieldGroup draggedField = cm.getModelField(draggedColumn);
        int columnMargin = cm.getColumnMargin();
        Rectangle spannedCellRect = new Rectangle();
        int rowCount = this.table.getRowCount();
        int columnCount = this.table.getColumnCount();
        ModelData data = ((JBroTable)this.table).getData();
        if (this.table.isFocusOwner()) {
            focusedRegion = hasAnySpans ? this.getSpanCoordinates(this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex(), this.table.getSelectionModel().getLeadSelectionIndex()) : new Rectangle(this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex(), this.table.getSelectionModel().getLeadSelectionIndex(), 1, 1);
            focusedRegion.width += focusedRegion.x;
            focusedRegion.height += focusedRegion.y;
        } else {
            focusedRegion = new Rectangle(-1, -1, -1, -1);
        }
        for (int row = rMin; row <= rMax; ++row) {
            int modelRow = this.table.convertRowIndexToModel(row);
            Rectangle cellRect = this.table.getCellRect(row, cMin, false);
            for (int column = cMin; column <= cMax; ++column) {
                JBroTableColumn aColumn = cm.getColumn(column);
                ModelField field = (ModelField)cm.getModelField(aColumn);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (!field.isDescendantOf(draggedField, true)) {
                    if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
                        this.paintEditingCell(g, cellRect);
                    } else if (!hasAnySpans || !this.spanCoveredCells[row - rMin][column - cMin]) {
                        Object value = null;
                        boolean valueInitialized = false;
                        boolean drawAsHeader = false;
                        spannedCellRect.setBounds(cellRect);
                        if (hasAnySpans) {
                            String columnName = aColumn.getIdentifier();
                            Map<String, ModelSpan> columnSpans = this.spans.get(columnName);
                            if (columnSpans != null) {
                                for (Map.Entry<String, ModelSpan> spanWithId : columnSpans.entrySet()) {
                                    int toRow;
                                    int fromRow;
                                    JBroTableColumn spanCoveredColumn;
                                    int toCol;
                                    JBroTableColumn spanCoveredColumn2;
                                    int fromCol;
                                    Object id;
                                    String idColumn = spanWithId.getKey();
                                    int idIdx = data.getIndexOfModelField(idColumn);
                                    if (idIdx < 0 || (id = data.getValue(modelRow, idIdx)) == null) continue;
                                    ModelSpan span = spanWithId.getValue();
                                    Set<String> columns = span.getColumns();
                                    for (fromCol = column - 1; fromCol >= 0 && columns.contains((String)((TableColumn)(spanCoveredColumn2 = cm.getColumn(fromCol))).getIdentifier()); --fromCol) {
                                        int width = spanCoveredColumn2.getWidth();
                                        spannedCellRect.width += width;
                                        spannedCellRect.x -= width;
                                    }
                                    for (toCol = column + 1; toCol < columnCount && columns.contains((String)((TableColumn)(spanCoveredColumn = cm.getColumn(toCol))).getIdentifier()); ++toCol) {
                                        spannedCellRect.width += spanCoveredColumn.getWidth();
                                    }
                                    for (fromRow = row - 1; fromRow >= 0 && id.equals(data.getValue(this.table.convertRowIndexToModel(fromRow), idIdx)); --fromRow) {
                                        int height = this.table.getRowHeight(fromRow);
                                        spannedCellRect.height += height;
                                        spannedCellRect.y -= height;
                                    }
                                    for (toRow = row + 1; toRow < rowCount && id.equals(data.getValue(this.table.convertRowIndexToModel(toRow), idIdx)); ++toRow) {
                                        spannedCellRect.height += this.table.getRowHeight(toRow);
                                    }
                                    if ((fromRow -= rMin) < -1) {
                                        fromRow = -1;
                                    }
                                    toRow -= rMin;
                                    if ((fromCol -= cMin) < -1) {
                                        fromCol = -1;
                                    }
                                    toCol -= cMin;
                                    for (int i = fromRow + 1; i < this.spanCoveredCells.length && i < toRow; ++i) {
                                        for (int j = fromCol + 1; j < this.spanCoveredCells[i].length && j < toCol; ++j) {
                                            this.spanCoveredCells[i][j] = true;
                                        }
                                    }
                                    valueInitialized = true;
                                    value = data.getValue(modelRow, span.getValueColumn());
                                    drawAsHeader = span.isDrawAsHeader();
                                    break;
                                }
                            }
                            if (drawAsHeader) {
                                spannedCellRect.height += this.table.getRowMargin();
                                spannedCellRect.width += columnMargin;
                            }
                        }
                        if (!valueInitialized) {
                            value = this.table.getValueAt(row, column);
                        }
                        this.paintCell(g, spannedCellRect, row, column, value, drawAsHeader, focusedRegion.x <= column && column < focusedRegion.width && focusedRegion.y <= row && row < focusedRegion.height, modelRow, field.getIdentifier());
                    }
                }
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, JBroTableColumn draggedColumn, int distance) {
        Graphics gg;
        JBroTableColumnModel cm = (JBroTableColumnModel)this.table.getColumnModel();
        int startIndex = cm.getColumnAbsoluteIndex(draggedColumn);
        int endIndex = startIndex + draggedColumn.getColspan() - 1;
        Rectangle minCell = this.table.getCellRect(rMin, startIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, endIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width - (vacatedColumnRect.width > 0 && this.table.getShowVerticalLines() && endIndex < cm.getColumnCount() - 1 ? 1 : 0), vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        if (this.draggedAreaCache != null) {
            g.drawImage(this.draggedAreaCache, vacatedColumnRect.x - 1, vacatedColumnRect.y, null);
            return;
        }
        if (this.isCacheUsed()) {
            this.draggedAreaCache = new BufferedImage(vacatedColumnRect.width + 1, vacatedColumnRect.height, 1);
            gg = this.draggedAreaCache.getGraphics();
            gg.setColor(this.table.getParent().getBackground());
            gg.fillRect(0, 0, vacatedColumnRect.width + 1, vacatedColumnRect.height);
            gg.translate(1 - vacatedColumnRect.x, -vacatedColumnRect.y);
        } else {
            gg = g;
        }
        gg.setColor(this.table.getBackground());
        gg.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            gg.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x - 1;
            int y1 = vacatedColumnRect.y;
            int y2 = y1 + vacatedColumnRect.height - 1;
            gg.drawLine(x1, y1, x1, y2);
            for (int draggedColumnIndex = startIndex; draggedColumnIndex <= endIndex; ++draggedColumnIndex) {
                gg.drawLine(x1 += cm.getColumn(draggedColumnIndex).getWidth(), y1, x1, y2);
            }
        }
        for (int row = rMin; row <= rMax; ++row) {
            for (int draggedColumnIndex = startIndex; draggedColumnIndex <= endIndex; ++draggedColumnIndex) {
                Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
                r.x += distance;
                this.paintDraggedCell(gg, r, row, draggedColumnIndex);
                if (!this.table.getShowHorizontalLines()) continue;
                gg.setColor(this.table.getGridColor());
                Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
                rcr.x += distance;
                int x1 = rcr.x;
                int y1 = rcr.y;
                int x2 = x1 + rcr.width - 1;
                int y2 = y1 + rcr.height - 1;
                gg.drawLine(x1, y2, x2, y2);
            }
        }
        if (this.isCacheUsed()) {
            g.drawImage(this.draggedAreaCache, vacatedColumnRect.x - 1, vacatedColumnRect.y, null);
        }
    }

    private void paintDraggedCell(Graphics g, Rectangle cellRect, int row, int column) {
        TableCellRenderer renderer = this.table.getCellRenderer(row, column);
        Component comp = this.table.prepareRenderer(renderer, row, column);
        JBroTableHeaderUI.htmlHack(g, comp, cellRect);
        this.rendererPane.paintComponent(g, comp, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private void paintEditingCell(Graphics g, Rectangle cellRect) {
        Component component = this.table.getEditorComponent();
        component.setBounds(cellRect);
        component.validate();
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column, Object value, boolean drawAsHeader, boolean hasFocus, int modelRow, String fieldId) {
        BufferedImage image;
        Graphics gg;
        List<Object> key;
        boolean isSelected = this.table.isCellSelected(row, column);
        if (this.rowsScrolling) {
            key = null;
        } else {
            key = Arrays.asList(String.valueOf(value), modelRow, fieldId, drawAsHeader, hasFocus, isSelected, cellRect.width, cellRect.height);
            Image image2 = (Image)this.cellImagesCache.get(key);
            if (image2 != null) {
                g.drawImage(image2, cellRect.x, cellRect.y, null);
                return;
            }
        }
        TableCellRenderer renderer = null;
        JTableHeader header = null;
        if (drawAsHeader && (header = this.innerHeader) != null) {
            JBroTableHeader gth;
            if (header instanceof JBroTableHeader && (gth = (JBroTableHeader)header).getLevelsQuantity() > 0) {
                renderer = gth.getDefaultRenderer(0);
            }
            if (renderer == null) {
                renderer = header.getDefaultRenderer();
            }
        }
        if (renderer == null) {
            renderer = this.table.getCellRenderer(row, column);
            header = null;
        }
        if (header != null) {
            boolean parentUIdeterminesRolloverColumnItself = JBroTableHeaderUI.hasParentUI(renderer);
            row = -2;
            if (parentUIdeterminesRolloverColumnItself && isSelected) {
                column = -1;
                isSelected = false;
            } else {
                column = -2;
            }
            if (!hasFocus) {
                hasFocus = isSelected;
            }
        }
        Component comp = renderer.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
        if (this.rowsScrolling) {
            gg = g;
            image = null;
        } else {
            image = new BufferedImage(cellRect.width, cellRect.height, 1);
            gg = ((Image)image).getGraphics();
            gg.setColor(this.table.getParent().getBackground());
            gg.fillRect(0, 0, cellRect.width, cellRect.height);
            gg.translate(-cellRect.x, -cellRect.y);
        }
        gg.setColor(header != null ? header.getBackground() : (isSelected ? this.table.getSelectionBackground() : this.table.getBackground()));
        gg.fillRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
        if (header != null) {
            if (this.rendererPane.getParent() != header) {
                header.add(this.rendererPane);
            }
        } else if (this.rendererPane.getParent() != this.table) {
            this.table.add(this.rendererPane);
        }
        JBroTableHeaderUI.htmlHack(gg, comp, cellRect);
        this.rendererPane.paintComponent(gg, comp, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        if (!this.rowsScrolling) {
            g.drawImage(image, cellRect.x, cellRect.y, null);
            this.cellImagesCache.put(key, image);
        }
    }

    public JBroTableUI withSpan(ModelSpan span) {
        if (span == null || span.getIdColumn() == null || span.getColumns().isEmpty()) {
            throw new IllegalArgumentException("Span formed not properly: " + span);
        }
        for (String column : span.getColumns()) {
            ModelSpan prev;
            Map<String, ModelSpan> columnSpans = this.spans.get(column);
            if (columnSpans == null) {
                columnSpans = new LinkedHashMap<String, ModelSpan>();
                this.spans.put(column, columnSpans);
            }
            if ((prev = columnSpans.put(span.getIdColumn(), span)) == null) continue;
            throw new IllegalArgumentException("Span column intersection: column " + column + " is used in both spans " + prev + " and " + span);
        }
        return this;
    }

    @Override
    protected void installDefaults() {
        this.clearCellImagesCache();
        this.innerHeader.updateUI();
        if (!this.noDefaults) {
            super.installDefaults();
        }
        this.table.setShowGrid(true);
        this.table.setIntercellSpacing(new Dimension(1, 1));
        if (Utils.equals(this.table.getGridColor(), this.table.getBackground())) {
            this.table.setGridColor(Color.GRAY.equals(this.table.getBackground()) ? Color.LIGHT_GRAY : Color.GRAY);
        }
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.table.getFont());
        LookAndFeel.installProperty(this.table, "rowHeight", fm.getHeight() + fm.getMaxDescent());
    }

    void setNoDefaults(boolean noDefaults) {
        this.noDefaults = noDefaults;
    }

    public Rectangle getSpanCoordinatesInPixels(int col, int row, boolean includeSpacing) {
        Rectangle rect = this.getSpanCoordinates(col, row);
        return this.table.getCellRect(rect.y, rect.x, includeSpacing).union(this.table.getCellRect(rect.y + rect.height - 1, rect.x + rect.width - 1, includeSpacing));
    }

    public Rectangle getSpanCoordinates(int col, int row) {
        TableColumn spanCoveredColumn;
        TableColumn spanCoveredColumn2;
        Rectangle ret = new Rectangle(col, row, 1, 1);
        SpanWithId spanWithId = this.getSpanWithId(col, row);
        if (spanWithId == null) {
            return ret;
        }
        TableColumnModel cm = this.table.getColumnModel();
        int columnCount = cm.getColumnCount();
        int rowCount = this.table.getRowCount();
        ModelData data = ((JBroTable)this.table).getData();
        int minRow = row;
        int i = row - 1;
        while (i >= 0 && spanWithId.id.equals(data.getValue(this.table.convertRowIndexToModel(i), spanWithId.idColumnIdx))) {
            minRow = i--;
        }
        int maxRow = row;
        int i2 = row + 1;
        while (i2 < rowCount && spanWithId.id.equals(data.getValue(this.table.convertRowIndexToModel(i2), spanWithId.idColumnIdx))) {
            maxRow = i2++;
        }
        Set<String> columns = spanWithId.span.getColumns();
        int minCol = col;
        int i3 = col - 1;
        while (i3 >= 0 && columns.contains((String)(spanCoveredColumn2 = cm.getColumn(i3)).getIdentifier())) {
            minCol = i3--;
        }
        int maxCol = col;
        int i4 = col + 1;
        while (i4 < columnCount && columns.contains((String)(spanCoveredColumn = cm.getColumn(i4)).getIdentifier())) {
            maxCol = i4++;
        }
        ret.setBounds(minCol, minRow, maxCol - minCol + 1, maxRow - minRow + 1);
        return ret;
    }

    public ModelSpan getSpan(int col, int row) {
        SpanWithId spanWithId = this.getSpanWithId(col, row);
        return spanWithId == null ? null : spanWithId.span;
    }

    public Object getSpanValue(int col, int row) {
        ModelSpan span = this.getSpan(col, row);
        if (span == null) {
            return this.table.getValueAt(col, row);
        }
        int modelRow = this.table.convertRowIndexToModel(row);
        ModelData data = ((JBroTable)this.table).getData();
        return data.getValue(modelRow, span.getValueColumn());
    }

    private SpanWithId getSpanWithId(int col, int row) {
        if (col < 0 || row < 0) {
            return null;
        }
        TableColumnModel cm = this.table.getColumnModel();
        if (cm == null) {
            return null;
        }
        int columnCount = cm.getColumnCount();
        if (col >= columnCount) {
            return null;
        }
        TableColumn aColumn = cm.getColumn(col);
        if (aColumn == null) {
            return null;
        }
        String columnName = (String)aColumn.getIdentifier();
        Map<String, ModelSpan> columnSpans = this.spans.get(columnName);
        if (columnSpans == null) {
            return null;
        }
        int rowCount = this.table.getRowCount();
        if (row >= rowCount) {
            return null;
        }
        int modelRow = this.table.convertRowIndexToModel(row);
        if (modelRow < 0) {
            return null;
        }
        ModelData data = ((JBroTable)this.table).getData();
        if (data == null || modelRow >= data.getRowsCount()) {
            return null;
        }
        for (Map.Entry<String, ModelSpan> spanWithId : columnSpans.entrySet()) {
            Object id;
            int idColumnIdx = data.getIndexOfModelField(spanWithId.getKey());
            if (idColumnIdx < 0 || (id = data.getValue(modelRow, idColumnIdx)) == null) continue;
            return new SpanWithId(spanWithId.getValue(), id, idColumnIdx);
        }
        return null;
    }

    public Iterable<ModelSpan> getSpans() {
        if (this.spans.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        IdentityHashMap ret = new IdentityHashMap();
        for (Map<String, ModelSpan> value : this.spans.values()) {
            for (ModelSpan span : value.values()) {
                ret.put(span, null);
            }
        }
        return ret.keySet();
    }

    public Set<String> getSpannedColumns() {
        if (this.spans.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> ret = new HashSet<String>();
        for (Map<String, ModelSpan> value : this.spans.values()) {
            for (ModelSpan span : value.values()) {
                ret.addAll(span.getColumns());
            }
        }
        return ret;
    }

    void onRowsSelected(int firstIndex, int lastIndex) {
        if (this.spans.isEmpty()) {
            return;
        }
        int rc = this.table.getRowCount();
        int cc = this.table.getColumnCount();
        firstIndex = Math.min(Math.max(firstIndex, 0), rc - 1);
        lastIndex = Math.min(Math.max(lastIndex, 0), rc - 1);
        Rectangle firstRowRect = this.table.getCellRect(firstIndex, 0, false);
        Rectangle lastRowRect = this.table.getCellRect(lastIndex, cc - 1, false);
        Rectangle dirtyRegion = firstRowRect.union(lastRowRect);
        for (int s = 0; s < 2; ++s) {
            for (int i = cc - 1; i >= 0; --i) {
                Rectangle rect = this.getSpanCoordinates(i, s == 0 ? firstIndex : lastIndex);
                if (rect.width <= 1 && rect.height <= 1) continue;
                dirtyRegion = dirtyRegion.union(this.table.getCellRect(rect.y, rect.x, false));
                dirtyRegion = dirtyRegion.union(this.table.getCellRect(rect.y + rect.height - 1, rect.x + rect.width - 1, false));
            }
        }
        this.table.repaint(dirtyRegion);
    }

    private static class SpanWithId {
        private final ModelSpan span;
        private final Object id;
        private final int idColumnIdx;

        public SpanWithId(ModelSpan span, Object id, int idColumnIdx) {
            this.span = span;
            this.id = id;
            this.idColumnIdx = idColumnIdx;
        }
    }
}

