/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.utils;

import datechooser.beans.editor.utils.SpinPane;
import datechooser.beans.locale.LocaleUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InsetsPanel
extends JPanel {
    private static int MIN_VALUE = 1;
    private static int MAX_VALUE = 50;
    public static final String INSETS_EVENT_NAME = "insets";
    private Insets insets;
    private SpinnerNumberModel left;
    private SpinnerNumberModel top;
    private SpinnerNumberModel right;
    private SpinnerNumberModel bottom;
    private boolean autoEditing;

    public InsetsPanel(Insets insets) {
        this.setAutoEditing(false);
        this.insets = insets;
        OnChange onChange = new OnChange();
        this.left = new SpinnerNumberModel(this.getInsets().left, MIN_VALUE, MAX_VALUE, 1);
        this.left.addChangeListener(onChange);
        this.top = new SpinnerNumberModel(this.getInsets().top, MIN_VALUE, MAX_VALUE, 1);
        this.top.addChangeListener(onChange);
        this.right = new SpinnerNumberModel(this.getInsets().right, MIN_VALUE, MAX_VALUE, 1);
        this.right.addChangeListener(onChange);
        this.bottom = new SpinnerNumberModel(this.getInsets().bottom, MIN_VALUE, MAX_VALUE, 1);
        this.bottom.addChangeListener(onChange);
        this.setLayout(new GridLayout(3, 3));
        this.add(this.getFoo());
        this.add(new SpinPane(this.top, LocaleUtils.getEditorLocaleString("top")));
        this.add(this.getFoo());
        this.add(new SpinPane(this.left, LocaleUtils.getEditorLocaleString("left")));
        this.add(this.getFoo());
        this.add(new SpinPane(this.right, LocaleUtils.getEditorLocaleString("right")));
        this.add(this.getFoo());
        this.add(new SpinPane(this.bottom, LocaleUtils.getEditorLocaleString("bottom")));
        this.add(this.getFoo());
    }

    private Component getFoo() {
        return new JPanel();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
        this.refresh();
    }

    public void refresh() {
        this.setAutoEditing(true);
        this.left.setValue(new Integer(this.insets.left));
        this.right.setValue(new Integer(this.insets.right));
        this.top.setValue(new Integer(this.insets.top));
        this.bottom.setValue(new Integer(this.insets.bottom));
        this.setAutoEditing(false);
    }

    public boolean isAutoEditing() {
        return this.autoEditing;
    }

    public void setAutoEditing(boolean autoEditing) {
        this.autoEditing = autoEditing;
    }

    class OnChange
    implements ChangeListener {
        OnChange() {
        }

        public void stateChanged(ChangeEvent e) {
            if (InsetsPanel.this.isAutoEditing()) {
                return;
            }
            InsetsPanel.this.insets.set(InsetsPanel.this.top.getNumber().intValue(), InsetsPanel.this.left.getNumber().intValue(), InsetsPanel.this.bottom.getNumber().intValue(), InsetsPanel.this.right.getNumber().intValue());
            InsetsPanel.this.firePropertyChange(InsetsPanel.INSETS_EVENT_NAME, null, null);
        }
    }
}

