/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.logging;

import fr.opensagres.xdocreport.core.logging.AbstractDelegatingLogger;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class LogUtils {
    private static final Object[] NO_PARAMETERS;
    private static Class<? extends AbstractDelegatingLogger> loggerClass;

    static void setLoggerClass(Class<? extends AbstractDelegatingLogger> loggerClass) {
        LogUtils.loggerClass = loggerClass;
    }

    static Class<? extends AbstractDelegatingLogger> getLoggerClass() {
        return loggerClass;
    }

    private LogUtils() {
    }

    public static Logger getLogger(Class<?> cls) {
        return LogUtils.createLogger(cls.getName());
    }

    protected static Logger createLogger(String loggerName) {
        if (loggerClass != null) {
            try {
                Constructor<? extends AbstractDelegatingLogger> cns = loggerClass.getConstructor(String.class);
                return cns.newInstance(loggerName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Logger.getLogger(loggerName, null);
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable, Object parameter) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(message, parameter);
            LogUtils.doLog(logger, level, formattedMessage, throwable);
        }
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable, Object ... parameters) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(message, parameters);
            LogUtils.doLog(logger, level, formattedMessage, throwable);
        }
    }

    public static void log(Logger logger, Level level, String message) {
        LogUtils.log(logger, level, message, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable) {
        LogUtils.log(logger, level, message, throwable, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level, String message, Object parameter) {
        LogUtils.log(logger, level, message, new Object[]{parameter});
    }

    public static void log(Logger logger, Level level, String message, Object[] parameters) {
        if (logger.isLoggable(level)) {
            LogUtils.doLog(logger, level, message, null);
        }
    }

    private static void doLog(Logger log, Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(log.getName());
        record.setResourceBundleName(log.getResourceBundleName());
        record.setResourceBundle(log.getResourceBundle());
        if (t != null) {
            record.setThrown(t);
        }
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String cname = LogUtils.class.getName();
        for (int x = 0; x < stack.length; ++x) {
            StackTraceElement frame = stack[x];
            if (frame.getClassName().equals(cname)) continue;
            record.setSourceClassName(frame.getClassName());
            record.setSourceMethodName(frame.getMethodName());
            break;
        }
        log.log(record);
    }

    public static Logger getLogger(String name) {
        return LogUtils.createLogger(name);
    }

    static {
        block9: {
            NO_PARAMETERS = new Object[0];
            try {
                String cname = null;
                Class.forName("org.slf4j.impl.StaticLoggerBinder");
                Class<?> cls = Class.forName("org.slf4j.LoggerFactory");
                Class<?> fcls = cls.getMethod("getILoggerFactory", new Class[0]).invoke(null, new Object[0]).getClass();
                if (fcls.getName().contains("Log4j")) {
                    cname = "fr.opensagres.xdocreport.core.logging.Log4jLogger";
                } else if (fcls.getName().contains("JCL")) {
                    cls = Class.forName("org.apache.commons.logging.LogFactory");
                    fcls = cls.getMethod("getFactory", new Class[0]).invoke(null, new Object[0]).getClass();
                    if (fcls.getName().contains("Log4j")) {
                        cname = "fr.opensagres.xdocreport.core.logging.Log4jLogger";
                    }
                } else {
                    cname = "fr.opensagres.xdocreport.core.logging.Slf4jLogger";
                }
                if (StringUtils.isEmpty(cname)) break block9;
                try {
                    loggerClass = Class.forName(cname.trim(), true, Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable ex) {
                    loggerClass = Class.forName(cname.trim());
                }
                LogUtils.getLogger(LogUtils.class).fine("Using " + loggerClass.getName() + " for logging.");
            }
            catch (Throwable ex) {
                loggerClass = null;
            }
        }
    }
}

