/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.utils;

import fr.opensagres.xdocreport.core.EncodingConstants;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Logger;

public class StringUtils {
    private static final Logger logger = LogUtils.getLogger(StringUtils.class.getName());
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public static final String replaceAll(String line, String oldString, String newString) {
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuilder buf = new StringBuilder(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean asBoolean(String value) {
        return StringUtils.asBoolean(value, false);
    }

    public static boolean asBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        value = value.trim();
        if (defaultValue) {
            return !FALSE.equals(value.toLowerCase());
        }
        return TRUE.equals(value.toLowerCase());
    }

    public static Boolean asBooleanObject(String value) {
        return StringUtils.asBooleanObject(value, null);
    }

    public static Boolean asBooleanObject(String value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        value = value.trim();
        if (defaultValue.booleanValue()) {
            return !FALSE.equals(value.toLowerCase());
        }
        return TRUE.equals(value.toLowerCase());
    }

    public static Integer asInteger(String value) {
        return StringUtils.asInteger(value, null);
    }

    public static Integer asInteger(String value, Integer defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static Long asLong(String value) {
        return StringUtils.asLong(value, null);
    }

    public static Long asLong(String value, Long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return StringUtils.replaceEach(text, searchList, replacementList, false, 0);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        if (text == null || text.length() == 0 || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        if (timeToLive < 0) {
            throw new IllegalStateException("TimeToLive of " + timeToLive + " is less than 0: " + text);
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].length() == 0 || replacementList[i] == null) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater = replacementList[i].length() - searchList[i].length();
            if (greater <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuffer buf = new StringBuffer(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            tempIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].length() == 0 || replacementList[i] == null) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        if (!repeat) {
            return result;
        }
        return StringUtils.replaceEach(result, searchList, replacementList, repeat, timeToLive - 1);
    }

    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, EncodingConstants.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("String - exception: " + e);
            return s;
        }
    }

    public static String xmlUnescape(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("&amp;", "&");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("&apos;", "'");
        return s;
    }

    public static String xmlEscape(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("\"", "&quot;");
        s = s.replaceAll("'", "&apos;");
        return s;
    }
}

