/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core;

import fr.opensagres.poi.xwpf.converter.core.FileImageExtractor;
import fr.opensagres.poi.xwpf.converter.core.IURIResolver;
import java.io.File;
import java.io.IOException;

public class ImageManager
extends FileImageExtractor
implements IURIResolver {
    private final String imageSubDir;

    public ImageManager(File baseDir, String imageSubDir) {
        super(baseDir);
        this.imageSubDir = imageSubDir;
    }

    @Override
    public void extract(String imagePath, byte[] imageData) throws IOException {
        super.extract(this.getImageRelativePath(imagePath), imageData);
    }

    private String getImageRelativePath(String imagePath) {
        return new File(this.imageSubDir, this.getFileName(imagePath)).toString();
    }

    private String getFileName(String imagePath) {
        return new File(imagePath).getName();
    }

    @Override
    public String resolve(String uri) {
        return this.getImageRelativePath(uri);
    }
}

