/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.images;

import fr.opensagres.xdocreport.core.document.ImageFormat;
import fr.opensagres.xdocreport.document.images.AbstractInputStreamImageProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileImageProvider
extends AbstractInputStreamImageProvider {
    private final File imageFile;
    private final ImageFormat imageFormat;

    public FileImageProvider(File imageFile) {
        this(imageFile, false);
    }

    public FileImageProvider(File imageFile, boolean useImageSize) {
        super(useImageSize);
        this.imageFile = imageFile;
        this.imageFormat = ImageFormat.getFormatByResourceName(imageFile.getName());
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return new FileInputStream(this.imageFile);
    }

    @Override
    public ImageFormat getImageFormat() {
        return this.imageFormat;
    }
}

