/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.AmbitoDestrezaDao;
import Modelos.Entidades.AmbitoDestreza;
import Servicios.ConexionSQLite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class AmbitoDestrezaDaoImpl
extends ConexionSQLite
implements AmbitoDestrezaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaAmbitoDestreza(List<AmbitoDestreza> listaAmbitoDestreza) throws Exception {
        if (null != listaAmbitoDestreza && !listaAmbitoDestreza.isEmpty()) {
            try {
                String sql = " INSERT INTO ambito_destreza(id_aplicacion, nemonico_grado, descripcion, id_asignatura, id_padre)  values(?,?,?,?,?)";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (AmbitoDestreza ambitoDestreza : listaAmbitoDestreza) {
                    if (null == ambitoDestreza) continue;
                    ps.setInt(1, ambitoDestreza.getIdAplicacion());
                    ps.setString(2, ambitoDestreza.getNemonicoGrado());
                    ps.setString(3, ambitoDestreza.getDescripcion());
                    ps.setObject(4, (Object)ambitoDestreza.getIdAsignatura(), 4);
                    ps.setObject(5, (Object)ambitoDestreza.getIdPadre(), 4);
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.cerrar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AmbitoDestreza> listarAmbitosDestrezasPorIdPadre(Integer idPadre) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AmbitoDestreza.class);
        List<AmbitoDestreza> ambitoDestreza = new ArrayList<AmbitoDestreza>();
        try {
            ambitoDestreza = (List)run.query(conn, "SELECT a.id_aplicacion as idAplicacion, a.nemonico_grado as nemonicoGrado, a.descripcion as descripcion, a.id_padre as idPadre FROM ambito_destreza a WHERE a.id_padre=?order by a.descripcion asc ", (ResultSetHandler)handler, new Object[]{idPadre});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return ambitoDestreza;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AmbitoDestreza> listarAmbitos(String nemonico, Integer idAsignatura) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AmbitoDestreza.class);
        List<AmbitoDestreza> ambitoDestreza = new ArrayList<AmbitoDestreza>();
        try {
            ambitoDestreza = (List)run.query(conn, "SELECT a.id_aplicacion as idAplicacion, a.nemonico_grado as nemonicoGrado, a.descripcion as descripcion, a.id_padre as idPadre FROM ambito_destreza a WHERE a.nemonico_grado like ?  and a.nemonico_grado not like '%IB'  and a.id_padre is null  and a.id_asignatura=? order by a.descripcion asc ", (ResultSetHandler)handler, new Object[]{nemonico + "%", idAsignatura});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return ambitoDestreza;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AmbitoDestreza> listarAmbitosBilingue(String nemonico, Integer idAsignatura) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AmbitoDestreza.class);
        List<AmbitoDestreza> ambitoDestreza = new ArrayList<AmbitoDestreza>();
        try {
            ambitoDestreza = (List)run.query(conn, "SELECT a.id_aplicacion as idAplicacion, a.nemonico_grado as nemonicoGrado, a.descripcion as descripcion, a.id_padre as idPadre FROM ambito_destreza a WHERE a.nemonico_grado like ?  and a.nemonico_grado like '%IB'  and a.id_padre is null  and a.id_asignatura=? order by a.descripcion asc ", (ResultSetHandler)handler, new Object[]{nemonico + "%", idAsignatura});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return ambitoDestreza;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmbitoDestreza buscarPorId(Integer id) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(AmbitoDestreza.class);
        AmbitoDestreza ambitoDestreza = null;
        try {
            ambitoDestreza = (AmbitoDestreza)run.query(conn, "SELECT a.id_aplicacion as idAplicacion, a.nemonico_grado as nemonicoGrado, a.descripcion as descripcion, a.id_padre as idPadre FROM ambito_destreza a WHERE a.id_aplicacion=?", (ResultSetHandler)handler, new Object[]{id});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return ambitoDestreza;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarAmbitoDestreza(AmbitoDestreza ambitoDestreza) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO ambito_destreza(id_aplicacion, nemonico_grado, descripcion, id_padre)  values(?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{ambitoDestreza.getIdAplicacion(), ambitoDestreza.getNemonicoGrado(), ambitoDestreza.getDescripcion(), ambitoDestreza.getIdPadre()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }
}

