/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.AsignacionDao;
import Modelos.Entidades.Asignacion;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class AsignacionDaoImpl
extends ConexionSQLite
implements AsignacionDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaAsignacion(List<Asignacion> listaAsignacion) throws Exception {
        if (null != listaAsignacion && !listaAsignacion.isEmpty()) {
            try {
                String sql = "INSERT INTO asignacion(id, id_estudiante, nombre_apellido_estudiante,identificacion_estudiante, id_periodo, id_institucion, nombre_institucion,id_curso, nombre_curso, id_paralelo, nombre_paralelo) values(?,?,?,?,?,?,?,?,?,?,?) ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (Asignacion asignacion : listaAsignacion) {
                    if (null == asignacion) continue;
                    ps.setInt(1, asignacion.getId());
                    ps.setInt(2, asignacion.getIdEstudiante());
                    ps.setString(3, asignacion.getNombreApellidoEstudiante());
                    ps.setString(4, asignacion.getIdentificacionEstudiante());
                    ps.setObject(5, (Object)asignacion.getIdPeriodo(), 4);
                    ps.setObject(6, (Object)asignacion.getIdInstitucion(), 4);
                    ps.setString(7, asignacion.getNombreInstitucion());
                    ps.setObject(8, (Object)asignacion.getIdCurso(), 4);
                    ps.setString(9, asignacion.getNombreCurso());
                    ps.setObject(10, (Object)asignacion.getIdParalelo(), 4);
                    ps.setString(11, asignacion.getNombreParalelo());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Asignacion> buscarPorParalelo(Integer codigoParalelo) {
        ArrayList<Asignacion> estudiantes = new ArrayList<Asignacion>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT * ");
            query.append(" FROM asignacion a ");
            query.append(" WHERE a.id_paralelo = ? order by a.nombre_apellido_estudiante asc ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, codigoParalelo);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Asignacion estudiante = new Asignacion();
                estudiante.setId(rs.getInt("id"));
                estudiante.setIdCurso(rs.getInt("id_curso"));
                estudiante.setIdEstudiante(rs.getInt("id_estudiante"));
                estudiante.setIdInstitucion(rs.getInt("id_institucion"));
                estudiante.setIdParalelo(rs.getInt("id_paralelo"));
                estudiante.setIdPeriodo(rs.getInt("id_periodo"));
                estudiante.setIdentificacionEstudiante(rs.getString("identificacion_estudiante"));
                estudiante.setNombreApellidoEstudiante(rs.getString("nombre_apellido_estudiante"));
                estudiante.setNombreCurso(rs.getString("nombre_curso"));
                estudiante.setNombreInstitucion(rs.getString("nombre_institucion"));
                estudiante.setNombreParalelo(rs.getString("nombre_paralelo"));
                estudiantes.add(estudiante);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrar();
            }
            catch (Exception e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return estudiantes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Asignacion buscarPorId(Integer idAsignacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(Asignacion.class);
        Asignacion asignacion = null;
        try {
            asignacion = (Asignacion)run.query(conn, " SELECT  r.id ,  r.id_estudiante as idEstudiante,  r.nombre_apellido_estudiante as nombreApellidoEstudiante, r.identificacion_estudiante as identificacionEstudiante, r.id_periodo as idPeriodo,  r.anio_inicio as nombrePeriodo, r.id_institucion as idInstitucion,  r.nombre_institucion as nombreInstitucion, r.id_curso as idCurso,  r.nombre_curso as nombreCurso,  r.id_paralelo as idParalelo, r.nombre_paralelo as nombreParalelo FROM asignacion r  WHERE  r.id = ?  ", (ResultSetHandler)handler, new Object[]{idAsignacion});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asignacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarAsignacion(Asignacion asignacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO asignacion(id, id_estudiante, nombre_apellido_estudiante, identificacion_estudiante, id_periodo, id_institucion, nombre_institucion, id_curso, nombre_curso, id_paralelo, nombre_paralelo)  values(?,?,?,?,?,?,?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{asignacion.getId(), asignacion.getIdEstudiante(), asignacion.getNombreApellidoEstudiante(), asignacion.getIdentificacionEstudiante(), asignacion.getIdPeriodo(), asignacion.getIdInstitucion(), asignacion.getNombreInstitucion(), asignacion.getIdCurso(), asignacion.getNombreCurso(), asignacion.getIdParalelo(), asignacion.getNombreParalelo()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }
}

