/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Enumeradores.EstadoEnum;
import Modelos.Dao.PcaDao;
import Modelos.Entidades.Pca;
import Servicios.ConexionSQLite;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class PcaDaoImpl
extends ConexionSQLite
implements PcaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarPca(Pca pca) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" update pca set ");
            sql.append("observacion = ?, ");
            sql.append("semana_trabajo = ?, ");
            sql.append("semana_evaluacion = ?, ");
            sql.append("total_periodo = ?, ");
            sql.append("bibliografia = ?, ");
            sql.append("eje_transversal = ?, ");
            sql.append("estado = ?, ");
            sql.append("editable = ?, ");
            sql.append("id_usuario_creacion = ?, ");
            sql.append("objetivo_grado = ?, ");
            sql.append("id_docente = ?, ");
            sql.append("id = ?, ");
            sql.append("carga_horaria_semanal = ? ");
            sql.append("where id_aplicacion = ? ");
            run.update(conn, sql.toString(), new Object[]{pca.getObservacion(), pca.getSemanaTrabajo(), pca.getSemanaEvaluacion(), pca.getTotalPeriodo(), pca.getBibliografia(), pca.getEjeTransversal(), pca.getEstado(), pca.getEditable(), pca.getIdUsuarioCreacion(), pca.getObjetivoGrado(), pca.getIdDocente(), pca.getId(), pca.getCargaHorariaSemanal(), pca.getIdAplicacion()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public List<Pca> obtenerListaPca() {
        return this.obtenerPca(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> obtenerIdsPcaExistentes() {
        Connection conn = this.getConnection();
        String query = " SELECT p.id_materia, p.id_curso FROM pca p ";
        ArrayList<String> idsPca = new ArrayList<String>();
        try {
            PreparedStatement ps = conn.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                StringBuilder sb = new StringBuilder();
                sb.append(rs.getInt("id_materia"));
                sb.append(rs.getInt("id_curso"));
                idsPca.add(sb.toString());
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return idsPca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaPca(List<Pca> listaPca, Boolean editable) {
        if (null != listaPca && !listaPca.isEmpty()) {
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" INSERT INTO pca(");
                sql.append("id, ");
                sql.append("id_curso, ");
                sql.append("id_materia, ");
                sql.append("id_jefe_area, ");
                sql.append("observacion, ");
                sql.append("semana_trabajo, ");
                sql.append("semana_evaluacion, ");
                sql.append("total_periodo, ");
                sql.append("bibliografia, ");
                sql.append("id_usuario_creacion, ");
                sql.append("fecha_creacion, ");
                sql.append("estado, ");
                sql.append("reg_anio_inicio, ");
                sql.append("editable, ");
                sql.append("nombre_institucion, ");
                sql.append("nombre_curso, ");
                sql.append("nombre_materia, ");
                sql.append("regimen, ");
                sql.append("anio_lectivo_inicio, ");
                sql.append("anio_lectivo_fin, ");
                sql.append("eje_transversal, ");
                sql.append("carga_horaria_semanal, ");
                sql.append("id_grado, ");
                sql.append("nombre_area, ");
                sql.append("nombre_jornada, ");
                sql.append("nombre_nivel_educativo, ");
                sql.append("nemonico_nivel_educativo, ");
                sql.append("objetivo_grado, ");
                sql.append("id_docente, ");
                sql.append("modifica_carga, ");
                sql.append("id_asignatura) ");
                sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )");
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql.toString());
                for (Pca pca : listaPca) {
                    if (null == pca) continue;
                    ps.setObject(1, (Object)pca.getId(), 4);
                    ps.setInt(2, pca.getIdCurso());
                    ps.setInt(3, pca.getIdMateria());
                    ps.setInt(4, pca.getIdJefeArea());
                    ps.setString(5, pca.getObservacion());
                    ps.setObject(6, (Object)pca.getSemanaTrabajo(), 4);
                    ps.setObject(7, (Object)pca.getSemanaEvaluacion(), 4);
                    ps.setObject(8, (Object)pca.getTotalPeriodo(), 4);
                    ps.setString(9, pca.getBibliografia());
                    ps.setObject(10, (Object)pca.getIdUsuarioCreacion(), 4);
                    ps.setObject(11, (Object)pca.getFechaCreacion(), 91);
                    ps.setString(12, pca.getEstado());
                    ps.setString(13, pca.getRegAnioInicio());
                    ps.setString(14, EstadoEnum.ESTADO_INACTIVO.getEstado());
                    ps.setString(15, pca.getNombreInstitucion());
                    ps.setString(16, pca.getNombreCurso());
                    ps.setString(17, pca.getNombreMateria());
                    ps.setString(18, pca.getRegimen());
                    ps.setString(19, pca.getAnioLectivoInicio());
                    ps.setString(20, pca.getAnioLectivoFin());
                    ps.setString(21, pca.getEjeTransversal());
                    ps.setInt(22, pca.getCargaHorariaSemanal());
                    ps.setInt(23, pca.getIdGrado());
                    ps.setString(24, pca.getNombreArea());
                    ps.setString(25, pca.getNombreJornada());
                    ps.setString(26, pca.getNombreNivelEducativo());
                    ps.setString(27, pca.getNemonicoNivelEducativo());
                    ps.setString(28, pca.getObjetivoGrado());
                    ps.setObject(29, (Object)pca.getIdDocente(), 4);
                    ps.setObject(30, (Object)pca.getModificaCargaHorariaSemanal(), 4);
                    ps.setInt(31, pca.getIdAsignatura());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(PcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public List<Pca> obtenerListaPcaEnviar(Integer idPca) {
        StringBuilder where = new StringBuilder();
        where.append(" where ((p.editable = '");
        where.append(EstadoEnum.ESTADO_ACTIVO.getEstado());
        where.append("' and p.estado is not null) or p.estado = '");
        where.append(EstadoEnum.ESTADO_BORRADOR.getEstado());
        where.append("') ");
        if (null != idPca) {
            where.append("and p.id_aplicacion = ");
            where.append(idPca.toString());
            where.append(" ");
        }
        return this.obtenerPca(where.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pca> obtenerPca(String where) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(Pca.class);
        List<Pca> listaPca = new ArrayList<Pca>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT ");
            query.append("p.id, ");
            query.append("p.id_curso as idCurso, ");
            query.append("p.id_materia as idMateria, ");
            query.append("p.id_jefe_area as idJefeArea, ");
            query.append("p.observacion, ");
            query.append("p.semana_trabajo as semanaTrabajo, ");
            query.append("p.semana_evaluacion as semanaEvaluacion, ");
            query.append("p.total_periodo as totalPeriodo, ");
            query.append("p.bibliografia, ");
            query.append("p.id_usuario_creacion as idUsuarioCreacion, ");
            query.append("p.estado, ");
            query.append("p.reg_anio_inicio as regAnioInicio, ");
            query.append("p.editable, ");
            query.append("p.nombre_institucion as nombreInstitucion, ");
            query.append("p.nombre_curso as nombreCurso, ");
            query.append("p.nombre_materia as nombreMateria, ");
            query.append("p.regimen, ");
            query.append("p.anio_lectivo_inicio as anioLectivoInicio, ");
            query.append("p.anio_lectivo_fin as anioLectivoFin, ");
            query.append("p.carga_horaria_semanal as cargaHorariaSemanal, ");
            query.append("p.id_aplicacion as idAplicacion, ");
            query.append("p.eje_transversal as ejeTransversal, ");
            query.append("p.id_grado as idGrado, ");
            query.append("p.nombre_area as nombreArea, ");
            query.append("p.nombre_jornada as nombreJornada, ");
            query.append("p.nombre_nivel_educativo as nombreNivelEducativo, ");
            query.append("p.nemonico_nivel_educativo as nemonicoNivelEducativo, ");
            query.append("p.objetivo_grado as objetivoGrado, ");
            query.append("p.id_docente as idDocente, ");
            query.append("p.modifica_carga as modificaCargaHorariaSemanal, ");
            query.append("p.id_asignatura as idAsignatura ");
            query.append(" FROM pca p ");
            if (null != where) {
                query.append(where);
            }
            listaPca = (List)run.query(conn, query.toString(), (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return listaPca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarPcaSinc(List<Pca> listaPca) {
        if (null != listaPca && !listaPca.isEmpty()) {
            try {
                String sql = " update pca set id = ?, codigo_error = ? where id_aplicacion = ? ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (Pca pca : listaPca) {
                    if (null == pca) continue;
                    ps.setObject(1, (Object)pca.getId(), 4);
                    ps.setInt(2, pca.getCodigoError());
                    ps.setInt(3, pca.getIdAplicacion());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(PcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public List<Pca> obtenerListaPcaEnviarYFinalizar(Integer idPca) {
        String where = " where p.estado = '1' ";
        where = where + "and p.id_aplicacion = " + idPca.toString() + " ";
        return this.obtenerPca(where);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void limipiarPca() {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        try {
            String sql = " delete from detalle_unidad ";
            run.update(conn, sql);
            sql = " delete from unidad_pca ";
            run.update(conn, sql);
            sql = " delete from pca ";
            run.update(conn, sql);
            sql = " delete from criterio_pca ";
            run.update(conn, sql);
            sql = " delete from objetivo_pca ";
            run.update(conn, sql);
            sql = " delete from destreza_pca ";
            run.update(conn, sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarPcaDocente(List<Pca> listaPca) {
        if (null != listaPca && !listaPca.isEmpty()) {
            try {
                String sql = " update pca set id = ?, id_docente = ? where id = ? ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                QueryRunner run = new QueryRunner();
                Integer idDocente = null;
                PreparedStatement psc = this.getConexion().prepareStatement("SELECT i.id_docente FROM instructor i limit 1 ");
                ResultSet rsc = psc.executeQuery();
                if (null != rsc) {
                    idDocente = rsc.getInt("id_docente");
                }
                for (Pca pca : listaPca) {
                    if (null == pca || null == pca.getId() || null != pca.getIdDocente() || !EstadoEnum.ESTADO_ACTIVO.getEstado().equals(pca.getEstado())) continue;
                    String sqlActualiza = " update detalle_unidad set id = null where id_unidad_pca in (select id_aplicacion from unidad_pca where id_pca in (select id_aplicacion from pca where id = ? ) ) ";
                    run.update(this.getConexion(), sqlActualiza, (Object)pca.getId());
                    sqlActualiza = " update unidad_pca set id = null where id_pca in (select id_aplicacion from pca where id = ? ) ";
                    run.update(this.getConexion(), sqlActualiza, (Object)pca.getId());
                    ps.setObject(1, null);
                    ps.setInt(2, idDocente);
                    ps.setInt(3, pca.getId());
                    ps.addBatch();
                    pca.setId(null);
                    pca.setIdDocente(idDocente);
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(PcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public void actualizarPcaDocente(Pca pca) {
        ArrayList<Pca> listaPca = new ArrayList<Pca>();
        listaPca.add(pca);
        this.actualizarPcaDocente(listaPca);
    }
}

