/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.ResgistroAnioLectivoDao;
import Modelos.Entidades.RegistroAnioLectivo;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class RegistroAnioLectivoDaoImpl
extends ConexionSQLite
implements ResgistroAnioLectivoDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaRegAnioLectivo(List<RegistroAnioLectivo> listaRegAnioLectivo) throws Exception {
        if (null != listaRegAnioLectivo && !listaRegAnioLectivo.isEmpty()) {
            try {
                String sql = "INSERT INTO registro_anio_lectivo(id, id_regimen, id_inscrip_anio_lectivo, tipo, fecha_inicio, fecha_fin) values(?,?,?,?,?,?) ";
                this.Conectar();
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (RegistroAnioLectivo regAnioLectivo : listaRegAnioLectivo) {
                    if (null == regAnioLectivo) continue;
                    ps.setInt(1, regAnioLectivo.getId());
                    ps.setInt(2, regAnioLectivo.getIdRegimen());
                    ps.setObject(3, (Object)regAnioLectivo.getIdAnioLectivo(), 4);
                    ps.setString(4, regAnioLectivo.getTipo());
                    ps.setString(5, regAnioLectivo.getFechaInicioClases());
                    ps.setString(6, regAnioLectivo.getFechaFinClases());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegistroAnioLectivo buscarPorId(Integer idMes) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(RegistroAnioLectivo.class);
        RegistroAnioLectivo registroAnioLectivo = null;
        try {
            registroAnioLectivo = (RegistroAnioLectivo)run.query(conn, "SELECT r.id, r.id_regimen as idRegimen, r.id_inscrip_anio_lectivo as idAnioLectivo, r.tipo, r.fecha_inicio as fechaInicioClases, r.fecha_fin as fechaFinClases  FROM registro_anio_lectivo r  WHERE  r.id = ? ", (ResultSetHandler)handler, new Object[]{idMes});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return registroAnioLectivo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarRegAnioLectivo(RegistroAnioLectivo regAnioLectivo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO registro_anio_lectivo(id, id_regimen, id_inscrip_anio_lectivo, tipo, fecha_inicio, fecha_fin) values(?,?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{regAnioLectivo.getId(), regAnioLectivo.getIdRegimen(), regAnioLectivo.getIdAnioLectivo(), regAnioLectivo.getTipo(), regAnioLectivo.getFechaInicioClases(), regAnioLectivo.getFechaFinClases()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }
}

