/*
 * Decompiled with CFR 0.152.
 */
package Servicios.Sincronizacion;

import Enumeradores.NivelEnum;
import Json.ClienteServicioWeb;
import Modelos.Dao.AmbitoDestrezaDao;
import Modelos.Dao.AmbitoDestrezaDaoImpl;
import Modelos.Dao.AsignacionDao;
import Modelos.Dao.AsignacionDaoImpl;
import Modelos.Dao.AsistenciaBachilleratoDao;
import Modelos.Dao.AsistenciaBachilleratoDaoImpl;
import Modelos.Dao.AsistenciaEducacionBasicaDao;
import Modelos.Dao.AsistenciaEducacionBasicaDaoImpl;
import Modelos.Dao.CalificacionDao;
import Modelos.Dao.CalificacionDaoImpl;
import Modelos.Dao.EstudianteRetiradoDao;
import Modelos.Dao.EstudianteRetiradoDaoImpl;
import Modelos.Dao.HoraDao;
import Modelos.Dao.HoraDaoImpl;
import Modelos.Dao.HoraJornadaDao;
import Modelos.Dao.HoraJornadaDaoImpl;
import Modelos.Dao.HorarioDao;
import Modelos.Dao.HorarioDaoImpl;
import Modelos.Dao.InstructorDao;
import Modelos.Dao.InstructorDaoImpl;
import Modelos.Dao.JustificacionEducacionBasicaDao;
import Modelos.Dao.JustificacionEducacionBasicaDaoImpl;
import Modelos.Dao.NotaCualitativaDao;
import Modelos.Dao.NotaCualitativaDaoImpl;
import Modelos.Dao.NotaDao;
import Modelos.Dao.NotaDaoImpl;
import Modelos.Dao.NotaInicialDao;
import Modelos.Dao.NotaInicialDaoImpl;
import Modelos.Dao.PeriodoAnioLectivoDao;
import Modelos.Dao.PeriodoAnioLectivoDaoImpl;
import Modelos.Dao.RecomendacionDao;
import Modelos.Dao.RecomendacionDaoImpl;
import Modelos.Dao.RegistroAnioLectivoDaoImpl;
import Modelos.Dao.ResgistroAnioLectivoDao;
import Modelos.Dao.SupletorioDao;
import Modelos.Dao.SupletorioDaoImpl;
import Modelos.Entidades.AsistenciaBachillerato;
import Modelos.Entidades.AsistenciaEducacionBasica;
import Modelos.Entidades.EntidadesDimDTO;
import Modelos.Entidades.JusticacionEducacionBasica;
import Modelos.Entidades.PeriodoInactividad;
import Util.MsgLog;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;

public class SincronizarServidoresMinEduc {
    private final AsistenciaEducacionBasicaDao asistenciaEducacionBasicaDao = new AsistenciaEducacionBasicaDaoImpl();
    private final AsistenciaBachilleratoDao asistenciaBachilleratoDao = new AsistenciaBachilleratoDaoImpl();
    private final JustificacionEducacionBasicaDao justificacionEducacionBasicaDao = new JustificacionEducacionBasicaDaoImpl();
    private final HoraDao horaDao = new HoraDaoImpl();
    private final HoraJornadaDao horaJornadaDao = new HoraJornadaDaoImpl();
    private final ResgistroAnioLectivoDao regAnioLectivoDao = new RegistroAnioLectivoDaoImpl();
    private final AsignacionDao asignacionDao = new AsignacionDaoImpl();
    private final InstructorDao instructorDao = new InstructorDaoImpl();
    private final HorarioDao horarioDao = new HorarioDaoImpl();
    private final AmbitoDestrezaDao ambitoDestrezaDao = new AmbitoDestrezaDaoImpl();
    private final CalificacionDao calificacionDao = new CalificacionDaoImpl();
    private final NotaDao notaDao = new NotaDaoImpl();
    private final NotaInicialDao notaInicialDao = new NotaInicialDaoImpl();
    private final SupletorioDao supletorioDao = new SupletorioDaoImpl();
    private final NotaCualitativaDao notaCualitativaDao = new NotaCualitativaDaoImpl();
    private final RecomendacionDao recomendacionDao = new RecomendacionDaoImpl();
    private final EstudianteRetiradoDao estudianteRetiradoDao = new EstudianteRetiradoDaoImpl();
    private final PeriodoAnioLectivoDao periodoAnioLectivoDao = new PeriodoAnioLectivoDaoImpl();

    public int asentarAsistenciaEnServidor(List<AsistenciaEducacionBasica> listaAsistencia) {
        int correctaMigracion = 0;
        int contadorErroneos = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<List<AsistenciaEducacionBasica>>(){}.getType();
            String jsonEnvio = gson.toJson(listaAsistencia, type);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/AsistenciaEducacionBasicaServicioJdc", jsonEnvio);
            if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                return -1;
            }
            List asistenciaSincronizada = (List)gson.fromJson(jsonRespuesta, type);
            for (AsistenciaEducacionBasica asistenciaEducacionBasica : asistenciaSincronizada) {
                this.asistenciaEducacionBasicaDao.actualizarAsistenciaSincronizacion(asistenciaEducacionBasica);
                if (!asistenciaEducacionBasica.getCodigoError().equals(1)) continue;
                ++contadorErroneos;
            }
            correctaMigracion = contadorErroneos == 0 ? 1 : 0;
        }
        catch (JsonSyntaxException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return correctaMigracion;
    }

    public int asentarAsistenciaBachilleratoEnServidor(Integer codigoParalelo) {
        List<AsistenciaBachillerato> listaAsistencia = codigoParalelo > 0 ? this.asistenciaBachilleratoDao.buscarAsistenciaEstudiantesPorParalelo(codigoParalelo) : this.asistenciaBachilleratoDao.buscarTodo();
        int correctaMigracion = 0;
        int contadorErroneos = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<List<AsistenciaBachillerato>>(){}.getType();
            String jsonEnvio = gson.toJson(listaAsistencia, type);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/AsistenciaBachilleratoServicioJdc", jsonEnvio);
            if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                return -1;
            }
            List asistenciaSincronizada = (List)gson.fromJson(jsonRespuesta, type);
            for (AsistenciaBachillerato asistenciaBach : asistenciaSincronizada) {
                this.asistenciaBachilleratoDao.actualizarAsistenciaSincronizacion(asistenciaBach);
                if (!asistenciaBach.getCodigoError().equals(1)) continue;
                ++contadorErroneos;
            }
            correctaMigracion = contadorErroneos == 0 ? 1 : 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return correctaMigracion;
    }

    public int asentarJustificacionEGBEnServidor(Integer codigoParalelo, String nemonicoGrado) {
        int correctaMigracion = 0;
        if (nemonicoGrado.equals(NivelEnum.BASICA_SUPERIOR.getNemonico()) || nemonicoGrado.equals(NivelEnum.TECNICO.getNemonico()) || nemonicoGrado.equals(NivelEnum.CIENCIAS.getNemonico()) || nemonicoGrado.equals(NivelEnum.INTERNACIONAL.getNemonico())) {
            correctaMigracion = this.asentarAsistenciaBachilleratoEnServidor(codigoParalelo);
        } else {
            List<JusticacionEducacionBasica> listaJustificacion = this.justificacionEducacionBasicaDao.buscarAsistenciaPorParalelo(codigoParalelo);
            int contadorErroneos = 0;
            try {
                Gson gson = new Gson();
                Type type = new TypeToken<List<JusticacionEducacionBasica>>(){}.getType();
                String jsonEnvio = gson.toJson(listaJustificacion, type);
                String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/JustificacionAsistenciaEducBasiServicioJdc", jsonEnvio);
                if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                    return -1;
                }
                List justificacionSincronizada = (List)gson.fromJson(jsonRespuesta, type);
                for (JusticacionEducacionBasica justificacionBach : justificacionSincronizada) {
                    this.justificacionEducacionBasicaDao.actualizarJustificacionSincronizacion(justificacionBach);
                    if (!justificacionBach.getCodigoError().equals(1)) continue;
                    ++contadorErroneos;
                }
                correctaMigracion = contadorErroneos == 0 ? 1 : 0;
            }
            catch (JsonSyntaxException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return correctaMigracion;
    }

    public int descargarInformacionInicial(String cedulaDocente) {
        int correctaMigracion = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<String>(){}.getType();
            Type typeRecibido = new TypeToken<EntidadesDimDTO>(){}.getType();
            String jsonEnvio = gson.toJson((Object)cedulaDocente, type);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/InformacionEntidadesDIM", jsonEnvio);
            EntidadesDimDTO recibidoObjeto = (EntidadesDimDTO)gson.fromJson(jsonRespuesta, typeRecibido);
            if (recibidoObjeto.getInstructores().size() > 0) {
                this.horaDao.guardarHoraList(recibidoObjeto.getHoras());
                this.horaJornadaDao.guardarListaHoraJornada(recibidoObjeto.getHorasJornadasTutor());
                this.horaJornadaDao.guardarListaHoraJornada(recibidoObjeto.getHorasJornadas());
                this.regAnioLectivoDao.guardarListaRegAnioLectivo(recibidoObjeto.getRegistroAniosLectivos());
                this.asignacionDao.guardarListaAsignacion(recibidoObjeto.getAsignaciones());
                this.instructorDao.guardarListaInstructor(recibidoObjeto.getInstructores());
                this.horarioDao.guardarListaHorario(recibidoObjeto.getHorarios());
                this.horarioDao.guardarListaHorario(recibidoObjeto.getHorariosTutor());
                this.ambitoDestrezaDao.guardarListaAmbitoDestreza(recibidoObjeto.getAmbitosDestrezas());
                this.calificacionDao.guardarListaCalificacion(recibidoObjeto.getCalificaciones());
                this.supletorioDao.guardarLista(recibidoObjeto.getSupletorios());
                this.notaDao.guardarListaNota(recibidoObjeto.getNotas());
                this.asistenciaBachilleratoDao.guardarListaAsistencia(recibidoObjeto.getAsistencias());
                this.asistenciaBachilleratoDao.guardarListaAsistencia(recibidoObjeto.getAsistenciasTutor());
                this.notaInicialDao.guardarListaNota(recibidoObjeto.getNotasIniciales());
                this.notaCualitativaDao.guardarListaNota(recibidoObjeto.getNotasCualitativas());
                this.asistenciaEducacionBasicaDao.guardarListaAsistencia(recibidoObjeto.getAsistenciaEducacionBasica());
                this.justificacionEducacionBasicaDao.guardarListaJustificacion(recibidoObjeto.getJustificacionesEducacionBasica());
                this.recomendacionDao.guardarListaRecomendacion(recibidoObjeto.getRecomendaciones());
                this.estudianteRetiradoDao.guardarEstudianteRetirado(recibidoObjeto.getPeriodoInactividad());
                this.periodoAnioLectivoDao.guardarListaPeriodoAnioLectivo(recibidoObjeto.getPeriodoAnioLectivo());
                correctaMigracion = 1;
            }
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return correctaMigracion;
    }

    public int asentarPeriodoInactividadEnServidor(Integer codigoParalelo) {
        List<PeriodoInactividad> listaAsistencia = codigoParalelo > 0 ? this.estudianteRetiradoDao.obtenerPorParalelo(codigoParalelo) : this.estudianteRetiradoDao.buscarTodo();
        int correctaMigracion = 0;
        int contadorErroneos = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<List<PeriodoInactividad>>(){}.getType();
            String jsonEnvio = gson.toJson(listaAsistencia, type);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/PeridoInactividadServicioJdc", jsonEnvio);
            if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                return -1;
            }
            List asistenciaSincronizada = (List)gson.fromJson(jsonRespuesta, type);
            for (PeriodoInactividad asistenciaBach : asistenciaSincronizada) {
                this.estudianteRetiradoDao.actualizarEstudianteRetiradoSincronizacion(asistenciaBach);
                if (!asistenciaBach.getCodigoError().equals(1)) continue;
                ++contadorErroneos;
            }
            correctaMigracion = contadorErroneos == 0 ? 1 : 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return correctaMigracion;
    }
}

