/*
 * Decompiled with CFR 0.152.
 */
package Versionador;

import Json.ClienteServicioWeb;
import Util.MsgLog;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.exception.ExceptionUtils;

public class Updater {
    public static String getLatestVersion() throws Exception {
        String data = Updater.getData("https://www.educarecuador.gob.ec/anexos/academico/app/update/version.html");
        return data.substring(data.indexOf("[version]") + 9, data.indexOf("[/version]"));
    }

    public static String getWhatsNew() throws Exception {
        String data = Updater.getData("https://www.educarecuador.gob.ec/anexos/academico/app/update/history.html");
        return data.substring(data.indexOf("[history]") + 9, data.indexOf("[/history]"));
    }

    private static String getData(String address) throws Exception {
        URL url = new URL(address);
        InputStream html = null;
        html = url.openStream();
        int c = 0;
        StringBuffer buffer = new StringBuffer("");
        while (c != -1) {
            c = html.read();
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    public static Date getLastModification() {
        Date lastModification = null;
        try {
            String fechaActualizacion = ClienteServicioWeb.servicioWebGet("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/UltimaFechaActualizacionApp");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            lastModification = format.parse(fechaActualizacion);
        }
        catch (ParseException ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return lastModification;
    }

    public static Date getLastModificationReadMetadata() {
        Date lastModification = null;
        try {
            URL url = new URL("https://www.educarecuador.gob.ec/anexos/academico/app/update/aplicacionDistribuir.zip");
            HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
            long date = httpCon.getLastModified();
            if (date != 0L) {
                lastModification = new Date(date);
            }
        }
        catch (MalformedURLException ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        catch (IOException ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return lastModification;
    }

    public static String getDownloadLinkFromHost() throws MalformedURLException, IOException {
        URL url = new URL("https://www.educarecuador.gob.ec/anexos/academico/app/update/url.html");
        InputStream html = null;
        html = url.openStream();
        int c = 0;
        StringBuilder buffer = new StringBuilder("");
        while (c != -1) {
            c = html.read();
            buffer.append((char)c);
        }
        return buffer.substring(buffer.indexOf("[url]") + 5, buffer.indexOf("[/url]"));
    }
}

