/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Enumeradores.MaximoCaracteres;
import Modelos.Dao.CriterioPcaDao;
import Modelos.Dao.CriterioPcaDaoImpl;
import Modelos.Dao.IndicadorPcaDao;
import Modelos.Dao.IndicadorPcaDaoImpl;
import Modelos.Entidades.CriterioPca;
import Modelos.Entidades.IndicadorPca;
import Modelos.Entidades.Pca;
import Modelos.Entidades.UnidadPca;
import Util.Constantes;
import Util.DestrezaPcaUtil;
import Util.Util;
import Vistas.FuncionesAuxiliar;
import Vistas.VistaPrincipal;
import Vistas.VistaSeleccionarDestrezaPCA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang.ArrayUtils;

public class PanelUnidadesPCA
extends JPanel {
    private UnidadPca unidadPca;
    private Pca pca;
    private JEditorPane jepObjetivos;
    private JEditorPane jepOrientaciones;
    private JEditorPane jepDestrezas;
    private JEditorPane jepEvaluacion;
    private JSpinner jtfDuracion;
    private List<DestrezaPcaUtil> listaDestrezas;
    private List<DestrezaPcaUtil> listaDestrezasSeleccionadas;
    private Map<Integer, List<CriterioPca>> mapCriterios;
    private JButton jbtEditarT1 = new JButton();
    private JButton jbtEditarT2 = new JButton();
    private JButton jbtEditarT3 = new JButton();
    private JTextField jtfTituloUnidad = new JTextField();
    private JLabel jlbTituloD;
    private VistaPrincipal jfrParent;
    public JButton jbtEliminarUnidad = new JButton();
    private final CriterioPcaDao criterioPcaDao = new CriterioPcaDaoImpl();
    private final IndicadorPcaDao indicadorPcaDao = new IndicadorPcaDaoImpl();

    public PanelUnidadesPCA() {
    }

    public PanelUnidadesPCA(UnidadPca unidadPca, VistaPrincipal jfrParent, Pca pca) {
        String txtUnidad = "Unidad";
        if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)pca.getNemonicoNivelEducativo())) {
            txtUnidad = "Experiencia";
        }
        this.jfrParent = jfrParent;
        this.pca = pca;
        this.unidadPca = unidadPca;
        this.jepObjetivos = new JEditorPane();
        this.jepObjetivos.setContentType("text/html");
        this.jepObjetivos.setEditable(false);
        this.jepOrientaciones = new JEditorPane();
        this.jepOrientaciones.setContentType("text/html");
        this.jepOrientaciones.setEditable(false);
        this.jepDestrezas = new JEditorPane();
        this.jepDestrezas.setContentType("text/html");
        this.jepDestrezas.setEditable(false);
        this.jepEvaluacion = new JEditorPane();
        this.jepEvaluacion.setContentType("text/html");
        this.jepEvaluacion.setEditable(false);
        SpinnerNumberModel sm = new SpinnerNumberModel(1, 1, 37, 1);
        this.obtenerDestrezas();
        this.jtfDuracion = new JSpinner(sm);
        this.listaDestrezasSeleccionadas = new ArrayList<DestrezaPcaUtil>();
        this.setLayout(new BorderLayout());
        JPanel jpnCuerpoTitulo = new JPanel();
        jpnCuerpoTitulo.setLayout(new BorderLayout());
        JPanel jpnTitulo = new JPanel(new FlowLayout());
        Util.setMaxCaracteres(this.jtfTituloUnidad, MaximoCaracteres.MAX_1000.getValor());
        this.jtfTituloUnidad.setText(unidadPca.getDescripcion());
        this.jtfTituloUnidad.setForeground(Color.BLUE);
        this.jtfTituloUnidad.setPreferredSize(new Dimension(300, 20));
        this.jtfTituloUnidad.setHorizontalAlignment(2);
        this.jtfTituloUnidad.setFont(new FuncionesAuxiliar().establecerFont(3));
        this.jlbTituloD = new JLabel();
        this.setJlbTituloDText();
        this.jbtEliminarUnidad.setText(Util.concatena("Eliminar ", txtUnidad));
        jpnTitulo.add(this.getJlbTituloD());
        jpnTitulo.add(this.jtfTituloUnidad);
        jpnCuerpoTitulo.add((Component)jpnTitulo, "Before");
        if (unidadPca.getOrden() != 1) {
            jpnCuerpoTitulo.add((Component)this.jbtEliminarUnidad, "After");
        }
        JPanel jpnTabla = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        jpnTabla.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        String tituloObjetivos = "<html>Objetivos de la unidad<br/>de planificaci\u00f3n</html>";
        if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)pca.getNemonicoNivelEducativo())) {
            tituloObjetivos = "<html>Objetivos espec\u00edficos de la<br/>experiencia de aprendizaje</html>";
        }
        JLabel t1 = new JLabel(tituloObjetivos);
        t1.setHorizontalAlignment(0);
        JLabel t2 = new JLabel("<html>Contenidos (Destrezas<br/>con Criterios de Desempe\u00f1o)</html>");
        t2.setHorizontalAlignment(0);
        JLabel t3 = new JLabel("<html>Orientaciones metodol\u00f3gicas<br/>&nbsp;</html>");
        t3.setHorizontalAlignment(0);
        JLabel t4 = new JLabel("<html>Evaluaci\u00f3n<br/>&nbsp;</html>");
        t4.setHorizontalAlignment(0);
        JLabel t5 = new JLabel("<html>Duraci\u00f3n<br/>(semanas)</html>");
        t5.setHorizontalAlignment(0);
        t5.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.BLACK));
        ImageIcon imiEditar = new ImageIcon(this.getClass().getResource("/Imagenes/imagenNotas_nueva.png"));
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        JPanel jpnEditT1 = new JPanel(new FlowLayout());
        jpnEditT1.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        Insets insetsGeneral = new Insets(0, 0, 0, 0);
        this.jbtEditarT1.setIcon(imiEditar);
        this.jbtEditarT1.setMargin(insetsGeneral);
        this.jbtEditarT1.setBackground(null);
        this.jbtEditarT1.setBorder(null);
        jpnEditT1.add(t1);
        jpnEditT1.add(this.jbtEditarT1);
        jpnTabla.add((Component)jpnEditT1, gc);
        gc.gridx = 1;
        JPanel jpnEditT2 = new JPanel(new FlowLayout());
        jpnEditT2.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.BLACK));
        this.jbtEditarT2.setIcon(imiEditar);
        this.jbtEditarT2.setMargin(insetsGeneral);
        this.jbtEditarT2.setBackground(null);
        this.jbtEditarT2.setBorder(null);
        jpnEditT2.add(t2);
        jpnEditT2.add(this.jbtEditarT2);
        jpnTabla.add((Component)jpnEditT2, gc);
        gc.gridx = 2;
        JPanel jpnEditT3 = new JPanel(new FlowLayout());
        jpnEditT3.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.BLACK));
        this.jbtEditarT3.setIcon(imiEditar);
        this.jbtEditarT3.setMargin(insetsGeneral);
        this.jbtEditarT3.setBackground(null);
        this.jbtEditarT3.setBorder(null);
        jpnEditT3.add(t3);
        jpnEditT3.add(this.jbtEditarT3);
        jpnTabla.add((Component)jpnEditT3, gc);
        gc.gridx = 3;
        JPanel jpnEditT4 = new JPanel(new FlowLayout());
        jpnEditT4.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.BLACK));
        jpnEditT4.add(t4);
        jpnTabla.add((Component)jpnEditT4, gc);
        gc.gridx = 4;
        gc.fill = 1;
        jpnTabla.add((Component)t5, gc);
        gc.weightx = 0.0;
        this.jepObjetivos.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.jepDestrezas.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.BLACK));
        this.jepOrientaciones.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.BLACK));
        this.jepEvaluacion.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.BLACK));
        JPanel jpnDuracion = new JPanel(new FlowLayout());
        jpnDuracion.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.BLACK));
        Dimension dPanelTabla = new Dimension(200, 200);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weighty = 1.0;
        gc.fill = 1;
        jpnTabla.add((Component)Util.obtenerScrollPaneTextos(this.jepObjetivos, dPanelTabla), gc);
        gc.gridx = 1;
        jpnTabla.add((Component)Util.obtenerScrollPaneTextos(this.jepDestrezas, dPanelTabla), gc);
        gc.gridx = 2;
        jpnTabla.add((Component)Util.obtenerScrollPaneTextos(this.jepOrientaciones, dPanelTabla), gc);
        gc.gridx = 3;
        jpnTabla.add((Component)Util.obtenerScrollPaneTextos(this.jepEvaluacion, dPanelTabla), gc);
        gc.gridx = 4;
        gc.anchor = 11;
        jpnDuracion.add(this.jtfDuracion);
        jpnTabla.add((Component)jpnDuracion, gc);
        this.add((Component)jpnCuerpoTitulo, "First");
        this.add((Component)jpnTabla, "Center");
        this.acciones();
    }

    public List<DestrezaPcaUtil> obtenerDestrezas() {
        this.listaDestrezas = this.pca.getListaDestrezas();
        return this.listaDestrezas;
    }

    private void acciones() {
        this.jbtEditarT1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                final VistaSeleccionarDestrezaPCA vistaEditarObjetivos = new VistaSeleccionarDestrezaPCA((Frame)PanelUnidadesPCA.this.jfrParent, true);
                String txtUnidad = "Unidad";
                if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)PanelUnidadesPCA.this.pca.getNemonicoNivelEducativo())) {
                    txtUnidad = "Experiencia";
                }
                vistaEditarObjetivos.jlbTitulo.setText(Util.concatena("EDITAR OBJETIVOS DE LA ", txtUnidad.toUpperCase(), " ", PanelUnidadesPCA.this.unidadPca.getOrden().toString()));
                vistaEditarObjetivos.addTexto();
                vistaEditarObjetivos.jbtAceptar.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (MaximoCaracteres.MAX_5000.getValor() > vistaEditarObjetivos.getJepTexto().getText().length()) {
                            PanelUnidadesPCA.this.jepObjetivos.setText(vistaEditarObjetivos.getJepTexto().getText());
                            vistaEditarObjetivos.dispose();
                        } else {
                            JOptionPane.showMessageDialog(null, "Ha superado el l\u00edmite de caract\u00e9res para este campo, por favor reducir el texto", "Advertencia", 2);
                        }
                    }
                });
                vistaEditarObjetivos.asignarTexto(PanelUnidadesPCA.this.jepObjetivos);
                vistaEditarObjetivos.setVisible(true);
            }
        });
        this.jbtEditarT2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                final VistaSeleccionarDestrezaPCA seleccionarDestreza = new VistaSeleccionarDestrezaPCA((Frame)PanelUnidadesPCA.this.jfrParent, true);
                if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)PanelUnidadesPCA.this.pca.getNemonicoNivelEducativo())) {
                    seleccionarDestreza.jlbTitulo.setText(Util.concatena("DESTREZAS ASIGNADAS A LA EXPERIENCIA ", PanelUnidadesPCA.this.unidadPca.getOrden().toString()));
                }
                seleccionarDestreza.jbtAceptar.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        PanelUnidadesPCA.this.listaDestrezasSeleccionadas = new ArrayList();
                        for (JCheckBox key : seleccionarDestreza.getMapDestrezas().keySet()) {
                            if (!key.isSelected()) continue;
                            DestrezaPcaUtil d = seleccionarDestreza.getMapDestrezas().get(key);
                            PanelUnidadesPCA.this.listaDestrezasSeleccionadas.add(d);
                        }
                        PanelUnidadesPCA.this.setearPanelDestrezas();
                        PanelUnidadesPCA.this.jfrParent.getVistaPcaPlantilla().setearObjetivos();
                        seleccionarDestreza.dispose();
                    }
                });
                seleccionarDestreza.addDestrezas(PanelUnidadesPCA.this.listaDestrezas);
                seleccionarDestreza.asignarDestrezasSeleccionadas(PanelUnidadesPCA.this.listaDestrezasSeleccionadas);
                seleccionarDestreza.setVisible(true);
            }
        });
        this.jbtEditarT3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                final VistaSeleccionarDestrezaPCA vistaEditarOrientaciones = new VistaSeleccionarDestrezaPCA((Frame)PanelUnidadesPCA.this.jfrParent, true);
                String txtUnidad = "Unidad";
                if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)PanelUnidadesPCA.this.pca.getNemonicoNivelEducativo())) {
                    txtUnidad = "Experiencia";
                }
                vistaEditarOrientaciones.jlbTitulo.setText(Util.concatena("EDITAR ORIENTACIONES METODOL\u00d3GICAS DE LA ", txtUnidad.toUpperCase(), " ", PanelUnidadesPCA.this.unidadPca.getOrden().toString()));
                vistaEditarOrientaciones.addTexto();
                vistaEditarOrientaciones.jbtAceptar.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (MaximoCaracteres.MAX_5000.getValor() > vistaEditarOrientaciones.getJepTexto().getText().length()) {
                            PanelUnidadesPCA.this.jepOrientaciones.setText(vistaEditarOrientaciones.getJepTexto().getText());
                            vistaEditarOrientaciones.dispose();
                        } else {
                            JOptionPane.showMessageDialog(null, "Ha superado el l\u00edmite de caract\u00e9res para este campo, por favor reducir el texto", "Advertencia", 2);
                        }
                    }
                });
                vistaEditarOrientaciones.asignarTexto(PanelUnidadesPCA.this.jepOrientaciones);
                vistaEditarOrientaciones.setVisible(true);
            }
        });
    }

    public void setearPanelDestrezas() {
        this.mapCriterios = new LinkedHashMap<Integer, List<CriterioPca>>();
        StringBuilder sb = new StringBuilder();
        sb.append("<html style=\"text-align: justify; text-justify: inter-word;\">");
        if (!this.listaDestrezasSeleccionadas.isEmpty()) {
            int size = this.listaDestrezasSeleccionadas.size();
            for (int i = 0; i < size; ++i) {
                DestrezaPcaUtil d = this.listaDestrezasSeleccionadas.get(i);
                ArrayList<Integer> listaIdsDestrezas = new ArrayList<Integer>();
                listaIdsDestrezas.add(d.getId());
                List<CriterioPca> listaCriteriosAux = this.criterioPcaDao.obtenerListaCriterioPorIdDestreza(listaIdsDestrezas);
                if (null != listaCriteriosAux && !listaCriteriosAux.isEmpty()) {
                    this.mapCriterios.put(d.getId(), listaCriteriosAux);
                }
                sb.append("<p>");
                switch (d.getTipo()) {
                    case IMPRESCINDIBLE: {
                        sb.append("<span style=\"background:#C6C6C6;\">");
                        break;
                    }
                    default: {
                        sb.append("<span>");
                    }
                }
                sb.append(d.getJepDetalle().getText().substring(d.getJepDetalle().getText().toLowerCase().indexOf("<body>") + 6, d.getJepDetalle().getText().toLowerCase().lastIndexOf("</body>")));
                sb.append("</span>");
                sb.append("</p>");
            }
            sb.append("</html>");
            this.jepDestrezas.setText(sb.toString());
            this.actualizarEvaluacion();
        } else {
            this.jepDestrezas.setText("");
            this.jepOrientaciones.setText("");
            this.jepEvaluacion.setText("");
        }
    }

    private void actualizarEvaluacion() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html style=\"text-align: justify; text-justify: inter-word;\">");
        for (Integer key : this.mapCriterios.keySet()) {
            for (CriterioPca c : this.mapCriterios.get(key)) {
                List<IndicadorPca> listaIndicadores = this.indicadorPcaDao.obtenerListaIndicadorPcaPorIdCriterio(c.getId());
                sb.append("<p>");
                sb.append(c.getNombre());
                sb.append(" ");
                sb.append(c.getDescripcion());
                sb.append("<ul>");
                int size = listaIndicadores.size();
                for (int i = 0; i < size; ++i) {
                    IndicadorPca indicador = listaIndicadores.get(i);
                    sb.append("<li>");
                    sb.append(indicador.getDescripcion());
                    sb.append("</li>");
                }
                sb.append("</ul></p>");
            }
            sb.append("<hr></hr>");
        }
        sb.append("</html>");
        this.jepEvaluacion.setText(sb.toString());
    }

    public UnidadPca getUnidadPca() {
        return this.unidadPca;
    }

    public void setUnidadPca(UnidadPca unidadPca) {
        this.unidadPca = unidadPca;
    }

    public JLabel getJlbTituloD() {
        return this.jlbTituloD;
    }

    public void setJlbTituloDText() {
        String txtUnidad = "Unidad";
        if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)this.pca.getNemonicoNivelEducativo())) {
            txtUnidad = "Experiencia";
        }
        this.jlbTituloD.setText(Util.concatena("T\u00edtulo de la ", txtUnidad, " ", this.unidadPca.getOrden().toString(), ": "));
    }

    public void setJlbTituloD(JLabel jlbTituloD) {
        this.jlbTituloD = jlbTituloD;
    }

    public JSpinner getJtfDuracion() {
        return this.jtfDuracion;
    }

    public void setJtfDuracion(JSpinner jtfDuracion) {
        this.jtfDuracion = jtfDuracion;
    }

    public List<DestrezaPcaUtil> getListaDestrezasSeleccionadas() {
        return this.listaDestrezasSeleccionadas;
    }

    public void setListaDestrezasSeleccionadas(List<DestrezaPcaUtil> listaDestrezasSeleccionadas) {
        this.listaDestrezasSeleccionadas = listaDestrezasSeleccionadas;
    }

    public JTextField getJtfTituloUnidad() {
        return this.jtfTituloUnidad;
    }

    public void setJtfTituloUnidad(JTextField jtfTituloUnidad) {
        this.jtfTituloUnidad = jtfTituloUnidad;
    }

    public JEditorPane getJepObjetivos() {
        return this.jepObjetivos;
    }

    public void setJepObjetivos(JEditorPane jepObjetivos) {
        this.jepObjetivos = jepObjetivos;
    }

    public Pca getPca() {
        return this.pca;
    }

    public void setPca(Pca pca) {
        this.pca = pca;
    }

    public List<DestrezaPcaUtil> getListaDestrezas() {
        return this.listaDestrezas;
    }

    public void setListaDestrezas(List<DestrezaPcaUtil> listaDestrezas) {
        this.listaDestrezas = listaDestrezas;
    }

    public JButton getJbtEditarT1() {
        return this.jbtEditarT1;
    }

    public void setJbtEditarT1(JButton jbtEditarT1) {
        this.jbtEditarT1 = jbtEditarT1;
    }

    public JButton getJbtEditarT3() {
        return this.jbtEditarT3;
    }

    public void setJbtEditarT3(JButton jbtEditarT3) {
        this.jbtEditarT3 = jbtEditarT3;
    }

    public JButton getJbtEditarT2() {
        return this.jbtEditarT2;
    }

    public void setJbtEditarT2(JButton jbtEditarT2) {
        this.jbtEditarT2 = jbtEditarT2;
    }

    public JEditorPane getJepOrientaciones() {
        return this.jepOrientaciones;
    }

    public void setJepOrientaciones(JEditorPane jepOrientaciones) {
        this.jepOrientaciones = jepOrientaciones;
    }

    public JEditorPane getJepDestrezas() {
        return this.jepDestrezas;
    }

    public void setJepDestrezas(JEditorPane jepDestrezas) {
        this.jepDestrezas = jepDestrezas;
    }

    public JEditorPane getJepEvaluacion() {
        return this.jepEvaluacion;
    }

    public void setJepEvaluacion(JEditorPane jepEvaluacion) {
        this.jepEvaluacion = jepEvaluacion;
    }
}

