/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Controladores.ControladorLogin;
import Controladores.ControladorMateria;
import Controladores.ControladorPCA;
import Enumeradores.EnlacesEnum;
import Enumeradores.EstadoEnum;
import Modelos.Dao.AsistenciaEducacionBasicaDaoImpl;
import Modelos.Dao.InstructorDao;
import Modelos.Dao.InstructorDaoImpl;
import Modelos.Dao.UsuarioDaoImpl;
import Servicios.Sincronizacion.SincronizarNotas;
import Servicios.Sincronizacion.SincronizarPca;
import Servicios.Sincronizacion.SincronizarServidoresMinEduc;
import Util.FileUtil;
import Util.MsgLog;
import Util.ObtenerPropiedad;
import Util.Util;
import Versionador.MigrateDatabase;
import Versionador.UpdateInfo;
import Versionador.Updater;
import Vistas.FuncionesAuxiliar;
import Vistas.GestionArchivo;
import Vistas.LabelLink;
import Vistas.PanelFondo;
import Vistas.PanelListaMateria;
import Vistas.VistaAsistencia;
import Vistas.VistaAsistenciaBachillerato;
import Vistas.VistaJustificarAsistencia;
import Vistas.VistaLogin;
import Vistas.VistaNota;
import Vistas.VistaNotaInicial;
import Vistas.VistaPcaPlantilla;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang.exception.ExceptionUtils;
import vo.InfoUsuarioVO;

public class VistaPrincipal
extends JFrame
implements ActionListener {
    Container cp = this.getContentPane();
    JPanel jpnPie = new JPanel();
    JPanel jpnCabecera = new JPanel();
    JPanel jpnMenu = new JPanel();
    public JPanel jpnTrabajo = new JPanel();
    JPanel jpnCuerpoMenu;
    JPanel jpnUsuario;
    JPanel jpnOpciones1;
    JPanel jpnOpciones2;
    JPanel jpnCabeceraTrabajo = new JPanel();
    PanelFondo pnlConexion;
    PanelFondo pnlSinConexion;
    PanelFondo pnlCabecera;
    public PanelListaMateria pnlListaMateria = new PanelListaMateria();
    JPanel jpnTituloLista = new JPanel();
    public VistaNota vistaNota = new VistaNota();
    public VistaNotaInicial vistaNotaInicial = new VistaNotaInicial();
    public VistaJustificarAsistencia vistaJustificarAsistencia = new VistaJustificarAsistencia();
    JPanel jpnOpcionesPCA;
    public VistaPcaPlantilla vistaPcaPlantilla;
    private ControladorPCA controladorPCA;
    JButton jbtPCA;
    JButton jbtRegresarPCA;
    JButton jbtCargarPCA;
    JButton jbtEnviarPCA;
    JButton jbtLogos;
    JButton jbtConexion;
    JButton jbtIngresarNotas;
    JButton jbtIngresarAsistencia;
    JButton jbtSalir;
    JButton jbtNuevo;
    JButton jbtAbrir;
    JButton jbtExportar;
    JButton jbtImportar;
    JButton jbtRegresarM;
    JButton jbtEnviar;
    Image imgPie;
    URL urlImage;
    JLabel jlbConexion = new JLabel();
    JLabel jlbUsuario;
    Timer t = new Timer();
    boolean blnAutorizado = false;
    private int indiceVentana = 0;
    private String institucion;
    private String materia;
    private String paralelo;
    private String regimenAnioLectivo;
    int contadorImg = 0;
    Border empty = BorderFactory.createEmptyBorder();
    JPanel panelConexion = new JPanel();
    public JScrollPane scrollListaMateria;
    public VistaAsistencia vistaAsistencia = new VistaAsistencia();
    public VistaAsistenciaBachillerato vistaAsistenciaBach = new VistaAsistenciaBachillerato();
    String usuario;
    String contrasenia;
    String opcionMenu;
    String nombreArchivo = "";
    int errorArchivoImportar;
    InstructorDao instructorDao = new InstructorDaoImpl();

    public int getIndiceVentana() {
        return this.indiceVentana;
    }

    public void setIndiceVentana(int indiceVentana) {
        this.indiceVentana = indiceVentana;
    }

    public String getInstitucion() {
        return this.institucion;
    }

    public void setInstitucion(String institucion) {
        this.institucion = institucion;
    }

    public String getMateria() {
        return this.materia;
    }

    public void setMateria(String materia) {
        this.materia = materia;
    }

    public String getParalelo() {
        return this.paralelo;
    }

    public void setParalelo(String paralelo) {
        this.paralelo = paralelo;
    }

    public VistaPrincipal() {
        this.jbtLogos = new JButton();
        this.jpnPie = new JPanel();
        this.pnlConexion = new PanelFondo("conectado_nueva.png");
        this.pnlSinConexion = new PanelFondo("sin_conexion_nueva.png");
        this.pnlConexion.setPreferredSize(new Dimension(200, 43));
        this.pnlSinConexion.setPreferredSize(new Dimension(200, 43));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/Imagenes/iconolibro.png")));
        this.setDefaultCloseOperation(3);
        VerificarConexion verificarConexion = new VerificarConexion();
        this.t.scheduleAtFixedRate((TimerTask)verificarConexion, 0L, 1000L);
        this.setExtendedState(6);
        this.setMinimumSize(new Dimension(1200, 700));
        this.setLocationRelativeTo(null);
        this.setTitle("REGISTRO DE NOTAS Y ASISTENCIA");
        this.panelConexion.setBackground(Color.white);
        this.jpnCabecera.setBackground(Color.WHITE);
        this.jpnTrabajo.setBackground(Color.white);
        this.jpnMenu.setBackground(Color.WHITE);
        this.jpnCabecera.setPreferredSize(new Dimension(this.getWidth(), 105));
        this.cp.setLayout(new BorderLayout());
        this.cp.add((Component)this.jpnMenu, "West");
        this.cp.add((Component)this.jpnCabecera, "North");
        this.cp.add((Component)this.jpnTrabajo, "Center");
        this.jpnTrabajo.setLayout(new BorderLayout());
        this.jpnCabeceraTrabajo.setBackground(new Color(0, 140, 205));
        this.pnlListaMateria.setLayout(new FlowLayout());
        this.pnlListaMateria.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.pnlListaMateria.setOpaque(false);
        this.pnlListaMateria.setBackground(new Color(0, 0, 0, 55));
        this.scrollListaMateria = new JScrollPane(this.pnlListaMateria);
        this.scrollListaMateria.setHorizontalScrollBarPolicy(30);
        this.scrollListaMateria.setVerticalScrollBarPolicy(20);
        this.formarCabecera();
        this.formarMenu();
        this.formarTrabajo();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                VistaPrincipal.this.cerrarAplicacion();
            }
        });
    }

    private void cerrarAplicacion() {
        try {
            int confirm = JOptionPane.showOptionDialog(null, "<html>\u00bfDesea realmente salir del sistema?</html>", "Confirmaci\u00f3n", 0, 3, null, null, null);
            if (confirm == 0) {
                String url = ObtenerPropiedad.obtenerPropiedad("bdd");
                String urlPlantilla = ObtenerPropiedad.obtenerPropiedadFile("plantilla");
                if (!urlPlantilla.equals(url) && this.blnAutorizado) {
                    Util.encriptaArchivoBB(FileUtil.rutaApp() + "/config/" + url);
                }
                System.exit(0);
            }
        }
        catch (Exception ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public void formarPie() {
        JButton jbtLogo = new JButton();
        jbtLogo.setIcon(new ImageIcon(this.getClass().getResource("/Imagenes/footer.png")));
        this.jpnPie.setLayout(new GridLayout());
        this.jpnPie.add(jbtLogo);
    }

    public void formarExtremosMenu() {
        this.pnlCabecera = new PanelFondo("imagenSistema_nueva.png");
        this.pnlCabecera.setBackground(Color.white);
        this.pnlCabecera.setPreferredSize(new Dimension(200, 100));
        JPanel panelLink = new JPanel();
        panelLink.setBackground(Color.white);
        panelLink.setForeground(new Color(9, 113, 206));
        LabelLink lblEducar = new LabelLink();
        lblEducar.setText(EnlacesEnum.EDUCAR_ECUADOR.getUrl());
        lblEducar.setTextLink(EnlacesEnum.EDUCAR_ECUADOR.getUrl());
        lblEducar.setLink("http://www.educarecuador.gob.ec");
        lblEducar.setForeground(new Color(9, 113, 206));
        lblEducar.setFont(new FuncionesAuxiliar().establecerFont(5));
        panelLink.add(lblEducar);
        this.jpnPie.setPreferredSize(new Dimension(200, 100));
        this.jpnPie.setBackground(Color.white);
        this.pnlConexion.setVisible(false);
        this.pnlSinConexion.setVisible(true);
        this.jpnPie.add((Component)this.panelConexion, "North");
        this.jpnPie.add((Component)panelLink, "South");
        this.jpnMenu.add((Component)this.pnlCabecera, "North");
        this.jpnMenu.add((Component)this.jpnPie, "South");
    }

    public void formarMenu() {
        ImageIcon imiIngresoNota = new ImageIcon(this.getClass().getResource("/Imagenes/imagenNotas_nueva.png"));
        ImageIcon imiIngresoAsistencia = new ImageIcon(this.getClass().getResource("/Imagenes/imagenAsistencias_nueva.png"));
        ImageIcon imiNuevo = new ImageIcon(this.getClass().getResource("/Imagenes/imagenNuevo_nueva.png"));
        ImageIcon imiAbrir = new ImageIcon(this.getClass().getResource("/Imagenes/imagenAbrir_nueva.png"));
        ImageIcon imiExportar = new ImageIcon(this.getClass().getResource("/Imagenes/imagenExportar_nueva.png"));
        ImageIcon imiImportar = new ImageIcon(this.getClass().getResource("/Imagenes/imagenImportar_nueva.png"));
        ImageIcon imiSalir = new ImageIcon(this.getClass().getResource("/Imagenes/imagenSalir_nueva.png"));
        ImageIcon imiRegresar = new ImageIcon(this.getClass().getResource("/Imagenes/imagenSalir_nueva.png"));
        ImageIcon imiEnviar = new ImageIcon(this.getClass().getResource("/Imagenes/imagenEnviar.png"));
        Font fuente3 = new FuncionesAuxiliar().establecerFont(3);
        this.jpnOpciones1 = new JPanel();
        this.jpnOpciones2 = new JPanel();
        this.jpnCuerpoMenu = new JPanel();
        this.jpnCuerpoMenu.setPreferredSize(new Dimension(200, 212));
        this.jpnUsuario = new JPanel();
        this.jpnUsuario.setBackground(Color.WHITE);
        this.jbtIngresarNotas = new JButton();
        this.jbtIngresarAsistencia = new JButton();
        this.jbtSalir = new JButton();
        this.jbtNuevo = new JButton();
        this.jbtAbrir = new JButton();
        this.jbtExportar = new JButton();
        this.jbtImportar = new JButton();
        this.jbtRegresarM = new JButton();
        this.jbtEnviar = new JButton();
        this.jpnCuerpoMenu.setBackground(Color.white);
        this.jpnOpciones2.setBackground(Color.white);
        this.jpnOpciones1.setBackground(Color.white);
        this.jbtIngresarNotas.setIcon(imiIngresoNota);
        this.jbtIngresarNotas.setIconTextGap(10);
        this.jbtIngresarNotas.setHorizontalAlignment(2);
        this.jbtIngresarNotas.setVerticalAlignment(0);
        this.jbtIngresarNotas.setHorizontalTextPosition(4);
        this.jbtIngresarNotas.setVerticalTextPosition(0);
        this.jbtIngresarNotas.setBorderPainted(false);
        this.jbtIngresarNotas.setContentAreaFilled(false);
        this.jbtIngresarNotas.setOpaque(false);
        this.jbtIngresarNotas.setForeground(new Color(9, 113, 206));
        this.jbtIngresarAsistencia.setIcon(imiIngresoAsistencia);
        this.jbtIngresarAsistencia.setIconTextGap(10);
        this.jbtIngresarAsistencia.setHorizontalAlignment(2);
        this.jbtIngresarAsistencia.setVerticalAlignment(0);
        this.jbtIngresarAsistencia.setHorizontalTextPosition(4);
        this.jbtIngresarAsistencia.setVerticalTextPosition(0);
        this.jbtIngresarAsistencia.setBorderPainted(false);
        this.jbtIngresarAsistencia.setContentAreaFilled(false);
        this.jbtIngresarAsistencia.setOpaque(false);
        this.jbtIngresarAsistencia.setForeground(new Color(9, 113, 206));
        this.jbtSalir.setIcon(imiSalir);
        this.jbtSalir.setIconTextGap(10);
        this.jbtSalir.setHorizontalAlignment(2);
        this.jbtSalir.setVerticalAlignment(0);
        this.jbtSalir.setHorizontalTextPosition(4);
        this.jbtSalir.setVerticalTextPosition(0);
        this.jbtSalir.setBorderPainted(false);
        this.jbtSalir.setContentAreaFilled(false);
        this.jbtSalir.setOpaque(false);
        this.jbtSalir.setForeground(new Color(9, 113, 206));
        this.jbtNuevo.setIcon(imiNuevo);
        this.jbtNuevo.setIconTextGap(5);
        this.jbtNuevo.setHorizontalAlignment(2);
        this.jbtNuevo.setVerticalAlignment(0);
        this.jbtNuevo.setHorizontalTextPosition(4);
        this.jbtNuevo.setVerticalTextPosition(0);
        this.jbtNuevo.setBorderPainted(false);
        this.jbtNuevo.setContentAreaFilled(false);
        this.jbtNuevo.setOpaque(false);
        this.jbtNuevo.setForeground(new Color(9, 113, 206));
        this.jbtAbrir.setIcon(imiAbrir);
        this.jbtAbrir.setIconTextGap(5);
        this.jbtAbrir.setHorizontalAlignment(2);
        this.jbtAbrir.setVerticalAlignment(0);
        this.jbtAbrir.setHorizontalTextPosition(4);
        this.jbtAbrir.setVerticalTextPosition(0);
        this.jbtAbrir.setBorderPainted(false);
        this.jbtAbrir.setContentAreaFilled(false);
        this.jbtAbrir.setOpaque(false);
        this.jbtAbrir.setForeground(new Color(9, 113, 206));
        this.jbtExportar.setIcon(imiExportar);
        this.jbtExportar.setIconTextGap(5);
        this.jbtExportar.setHorizontalAlignment(2);
        this.jbtExportar.setVerticalAlignment(0);
        this.jbtExportar.setHorizontalTextPosition(4);
        this.jbtExportar.setVerticalTextPosition(0);
        this.jbtExportar.setBorderPainted(false);
        this.jbtExportar.setContentAreaFilled(false);
        this.jbtExportar.setOpaque(false);
        this.jbtExportar.setForeground(new Color(9, 113, 206));
        this.jbtImportar.setIcon(imiImportar);
        this.jbtImportar.setIconTextGap(5);
        this.jbtImportar.setHorizontalAlignment(2);
        this.jbtImportar.setVerticalAlignment(0);
        this.jbtImportar.setHorizontalTextPosition(4);
        this.jbtImportar.setVerticalTextPosition(0);
        this.jbtImportar.setBorderPainted(false);
        this.jbtImportar.setContentAreaFilled(false);
        this.jbtImportar.setOpaque(false);
        this.jbtImportar.setForeground(new Color(9, 113, 206));
        this.jbtRegresarM.setIcon(imiRegresar);
        this.jbtRegresarM.setIconTextGap(5);
        this.jbtRegresarM.setHorizontalAlignment(2);
        this.jbtRegresarM.setVerticalAlignment(0);
        this.jbtRegresarM.setHorizontalTextPosition(4);
        this.jbtRegresarM.setVerticalTextPosition(0);
        this.jbtRegresarM.setBorderPainted(false);
        this.jbtRegresarM.setContentAreaFilled(false);
        this.jbtRegresarM.setOpaque(false);
        this.jbtRegresarM.setForeground(new Color(9, 113, 206));
        this.jbtEnviar.setIcon(imiEnviar);
        this.jbtEnviar.setIconTextGap(5);
        this.jbtEnviar.setHorizontalAlignment(2);
        this.jbtEnviar.setVerticalAlignment(0);
        this.jbtEnviar.setHorizontalTextPosition(4);
        this.jbtEnviar.setVerticalTextPosition(0);
        this.jbtEnviar.setBorderPainted(false);
        this.jbtEnviar.setContentAreaFilled(false);
        this.jbtEnviar.setOpaque(false);
        this.jbtEnviar.setForeground(new Color(9, 113, 206));
        this.jbtIngresarNotas.setText("<html>Ingresar notas</html>");
        this.jbtIngresarAsistencia.setText("<html>Ingresar<br/>asistencia</html>");
        this.jbtSalir.setText("Salir");
        this.jbtIngresarNotas.setFont(fuente3);
        this.jbtIngresarAsistencia.setFont(fuente3);
        this.jbtSalir.setFont(fuente3);
        this.jbtNuevo.setText("<html>Cargar listas<br/>de estudiantes</html>");
        this.jbtAbrir.setText("<html>Abrir listas<br/>de estudiantes</html>");
        this.jbtExportar.setText("<html>Exportar listas<br/>de estudiantes</html>");
        this.jbtImportar.setText("<html>Importar listas<br/>de estudiantes</html>");
        this.jbtRegresarM.setText("Regresar");
        this.jbtEnviar.setText("Enviar");
        this.jbtNuevo.setFont(fuente3);
        this.jbtAbrir.setFont(fuente3);
        this.jbtExportar.setFont(fuente3);
        this.jbtImportar.setFont(fuente3);
        this.jbtRegresarM.setFont(fuente3);
        this.jbtEnviar.setFont(fuente3);
        this.jbtIngresarNotas.addActionListener(this);
        this.jbtIngresarAsistencia.addActionListener(this);
        this.jbtSalir.addActionListener(this);
        this.jbtNuevo.addActionListener(this);
        this.jbtAbrir.addActionListener(this);
        this.jbtExportar.addActionListener(this);
        this.jbtImportar.addActionListener(this);
        this.jbtRegresarM.addActionListener(this);
        this.jbtEnviar.addActionListener(this);
        this.jbtEnviar.setEnabled(false);
        this.jpnOpciones2.setLayout(new GridLayout(5, 1, 1, 1));
        this.jpnOpciones2.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.jpnOpciones2.add(this.jbtIngresarNotas);
        this.jpnOpciones2.add(this.jbtIngresarAsistencia);
        this.jpnOpciones2.add(this.jbtExportar);
        this.jpnOpciones2.add(this.jbtEnviar);
        this.jpnOpciones2.add(this.jbtRegresarM);
        this.jbtRegresarPCA = new JButton();
        this.jbtRegresarPCA.setIcon(imiRegresar);
        this.jbtRegresarPCA.setIconTextGap(5);
        this.jbtRegresarPCA.setHorizontalAlignment(2);
        this.jbtRegresarPCA.setVerticalAlignment(0);
        this.jbtRegresarPCA.setHorizontalTextPosition(4);
        this.jbtRegresarPCA.setVerticalTextPosition(0);
        this.jbtRegresarPCA.setBorderPainted(false);
        this.jbtRegresarPCA.setContentAreaFilled(false);
        this.jbtRegresarPCA.setOpaque(false);
        this.jbtRegresarPCA.setForeground(new Color(9, 113, 206));
        this.jbtRegresarPCA.setText("<html>Regresar</html>");
        this.jbtRegresarPCA.setFont(fuente3);
        this.jbtRegresarPCA.addActionListener(this);
        this.jbtCargarPCA = new JButton();
        this.jbtCargarPCA.setIcon(imiNuevo);
        this.jbtCargarPCA.setIconTextGap(5);
        this.jbtCargarPCA.setHorizontalAlignment(2);
        this.jbtCargarPCA.setVerticalAlignment(0);
        this.jbtCargarPCA.setHorizontalTextPosition(4);
        this.jbtCargarPCA.setVerticalTextPosition(0);
        this.jbtCargarPCA.setBorderPainted(false);
        this.jbtCargarPCA.setContentAreaFilled(false);
        this.jbtCargarPCA.setOpaque(false);
        this.jbtCargarPCA.setForeground(new Color(9, 113, 206));
        this.jbtCargarPCA.setText("<html>Cargar PCA</html>");
        this.jbtCargarPCA.setFont(fuente3);
        this.jbtCargarPCA.addActionListener(this);
        this.jbtEnviarPCA = new JButton();
        this.jbtEnviarPCA.setIcon(imiEnviar);
        this.jbtEnviarPCA.setIconTextGap(5);
        this.jbtEnviarPCA.setHorizontalAlignment(2);
        this.jbtEnviarPCA.setVerticalAlignment(0);
        this.jbtEnviarPCA.setHorizontalTextPosition(4);
        this.jbtEnviarPCA.setVerticalTextPosition(0);
        this.jbtEnviarPCA.setBorderPainted(false);
        this.jbtEnviarPCA.setContentAreaFilled(false);
        this.jbtEnviarPCA.setOpaque(false);
        this.jbtEnviarPCA.setForeground(new Color(9, 113, 206));
        this.jbtEnviarPCA.setText("<html>Enviar PCA</html>");
        this.jbtEnviarPCA.setFont(fuente3);
        this.jbtEnviarPCA.addActionListener(this);
        this.jbtPCA = new JButton();
        this.jbtPCA.setIcon(imiImportar);
        this.jbtPCA.setIconTextGap(5);
        this.jbtPCA.setHorizontalAlignment(2);
        this.jbtPCA.setVerticalAlignment(0);
        this.jbtPCA.setHorizontalTextPosition(4);
        this.jbtPCA.setVerticalTextPosition(0);
        this.jbtPCA.setBorderPainted(false);
        this.jbtPCA.setContentAreaFilled(false);
        this.jbtPCA.setOpaque(false);
        this.jbtPCA.setForeground(new Color(9, 113, 206));
        this.jbtPCA.setText("<html>Administrar PCA</html>");
        this.jbtPCA.setFont(fuente3);
        this.jbtPCA.addActionListener(this);
        this.jpnOpciones1.setLayout(new GridLayout(5, 1, 1, 1));
        this.jpnOpciones1.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.jpnOpciones1.add(this.jbtNuevo);
        this.jpnOpciones1.add(this.jbtAbrir);
        this.jpnOpciones1.add(this.jbtImportar);
        this.jpnOpciones1.add(this.jbtPCA);
        this.jpnOpciones1.add(this.jbtSalir);
        this.jpnOpcionesPCA = new JPanel();
        this.jpnOpcionesPCA.setBackground(Color.white);
        this.jpnOpcionesPCA.setLayout(new GridLayout(3, 1, 1, 1));
        this.jpnOpcionesPCA.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.jpnOpcionesPCA.add(this.jbtCargarPCA);
        this.jpnOpcionesPCA.add(this.jbtEnviarPCA);
        this.jpnOpcionesPCA.add(this.jbtRegresarPCA);
        this.jpnCuerpoMenu.setLayout(new BorderLayout());
        this.jpnCuerpoMenu.add((Component)this.jpnUsuario, "North");
        this.jpnCuerpoMenu.add((Component)this.jpnOpcionesPCA, "Center");
        this.jpnCuerpoMenu.add((Component)this.jpnOpciones2, "Center");
        this.jpnCuerpoMenu.add((Component)this.jpnOpciones1, "Center");
        this.jpnOpcionesPCA.setVisible(false);
        this.jpnOpciones2.setVisible(false);
        this.jpnOpciones1.setVisible(true);
        this.jpnMenu.setLayout(new BorderLayout());
        this.formarExtremosMenu();
        this.jpnMenu.add((Component)this.jpnCuerpoMenu, "Center");
    }

    public void formarCabecera() {
        JPanel jpnTituloCabecera = new JPanel();
        PanelFondo pnlMinisterio = new PanelFondo("ministerio_nuevo1.png");
        PanelFondo pnlEscudo = new PanelFondo("escudo.png");
        PanelFondo pnlEducar = new PanelFondo("educar_nuevo.png");
        JPanel jpnVacio = new JPanel();
        pnlMinisterio.setPreferredSize(new Dimension(266, 103));
        pnlEscudo.setPreferredSize(new Dimension(165, 100));
        pnlEducar.setPreferredSize(new Dimension(101, 100));
        jpnTituloCabecera.setBackground(Color.WHITE);
        jpnVacio.setBackground(Color.WHITE);
        this.jpnCabecera.setLayout(new BorderLayout());
        jpnTituloCabecera.setLayout(new BorderLayout());
        pnlEscudo.setBorder(this.empty);
        pnlMinisterio.setBorder(this.empty);
        pnlEducar.setBorder(this.empty);
        jpnVacio.setBorder(this.empty);
        jpnTituloCabecera.add((Component)pnlMinisterio, "West");
        jpnTituloCabecera.add((Component)pnlEscudo, "East");
        jpnTituloCabecera.add((Component)jpnVacio, "Center");
        this.jpnCabecera.add((Component)jpnTituloCabecera, "Center");
        this.jpnCabecera.add((Component)pnlEducar, "East");
        this.jpnCabecera.setBorder(this.empty);
    }

    public void formarTrabajo() {
        this.jpnTrabajo.setBackground(new Color(232, 232, 232));
        this.jbtLogos.setBackground(new Color(232, 232, 232));
        switch (this.getIndiceVentana()) {
            case 0: {
                this.jpnOpciones1.setVisible(true);
                this.jpnOpciones2.setVisible(false);
                this.jpnOpcionesPCA.setVisible(false);
                if (!this.blnAutorizado) break;
                this.jpnCuerpoMenu.add((Component)this.jpnUsuario, "North");
                this.jpnCuerpoMenu.add((Component)this.jpnOpciones1, "Center");
                break;
            }
            case 2: {
                this.scrollListaMateria.setVisible(true);
            }
            case 3: 
            case 4: {
                this.scrollListaMateria.setVisible(false);
                this.jpnTrabajo.updateUI();
                break;
            }
            case 5: 
            case 6: {
                this.jpnOpciones1.setVisible(false);
                this.jpnOpciones2.setVisible(false);
                this.jpnOpcionesPCA.setVisible(true);
                this.jpnCuerpoMenu.add((Component)this.jpnOpcionesPCA, "Center");
                break;
            }
            default: {
                this.jpnOpciones1.setVisible(false);
                this.jpnOpciones2.setVisible(true);
                this.jpnOpcionesPCA.setVisible(false);
            }
        }
        switch (this.getIndiceVentana()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.jbtLogos.setVisible(false);
                this.jpnCabeceraTrabajo.setPreferredSize(new Dimension(this.jpnTrabajo.getWidth(), 100));
                this.jpnCabeceraTrabajo.setLayout(new BorderLayout());
                this.jpnTrabajo.add((Component)this.jpnCabeceraTrabajo, "North");
                this.jpnCabeceraTrabajo.setVisible(true);
                this.formarTituloTrabajo();
                break;
            }
            default: {
                this.jbtLogos.setVisible(true);
                this.jpnTrabajo.add((Component)this.jbtLogos, "Center");
                this.pnlListaMateria.setVisible(false);
                this.jpnCabeceraTrabajo.setVisible(false);
            }
        }
    }

    public void formarTituloTrabajo() {
        this.jpnTituloLista.removeAll();
        this.jpnTituloLista.setBackground(new Color(0, 140, 205));
        Font fuente2 = new FuncionesAuxiliar().establecerFont(2);
        Font fuente3 = new FuncionesAuxiliar().establecerFont(3);
        Font fuente4 = new FuncionesAuxiliar().establecerFont(4);
        if (null != this.vistaPcaPlantilla) {
            this.vistaPcaPlantilla.setVisible(false);
        }
        switch (this.getIndiceVentana()) {
            case 2: {
                this.jpnTituloLista.setLayout(new BorderLayout());
                JLabel jlbTituloLista = new JLabel("");
                jlbTituloLista.setForeground(Color.WHITE);
                jlbTituloLista.setFont(fuente2);
                this.jpnTituloLista.add((Component)jlbTituloLista, "Center");
                this.jbtLogos.setVisible(false);
                this.pnlListaMateria.setVisible(true);
                this.vistaNota.setVisible(false);
                this.vistaNotaInicial.setVisible(false);
                this.vistaAsistencia.setVisible(false);
                this.vistaAsistenciaBach.setVisible(false);
                this.vistaJustificarAsistencia.setVisible(false);
                this.pnlListaMateria.establecerSize();
                this.scrollListaMateria.setPreferredSize(this.pnlListaMateria.getPreferredSize());
                this.jpnTrabajo.add((Component)this.scrollListaMateria, "Center");
                this.scrollListaMateria.setVisible(true);
                break;
            }
            case 3: {
                Object jlbTituloLista = null;
                this.jpnTituloLista.setLayout(new GridLayout(4, 2));
                this.jpnTituloLista.setBorder(new EmptyBorder(15, 0, 15, 15));
                JLabel jlbInstitucion = new JLabel("<html>Instituci\u00f3n:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreInstitucion = new JLabel(this.institucion);
                JLabel jlbRegimen = new JLabel("<html>R\u00e9gimen - A\u00f1o lectivo:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreRegimen = new JLabel(this.regimenAnioLectivo);
                JLabel jlbMateria = new JLabel("<html>Materia:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreMateria = new JLabel(this.materia);
                JLabel jlbCurso = new JLabel("<html>Grado/Curso:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreCurso = new JLabel(this.paralelo);
                jlbInstitucion.setForeground(Color.WHITE);
                jlbInstitucion.setFont(fuente4);
                jlbInstitucion.setHorizontalAlignment(4);
                jlbMateria.setForeground(Color.WHITE);
                jlbMateria.setFont(fuente4);
                jlbMateria.setHorizontalAlignment(4);
                jlbMateria.setForeground(Color.WHITE);
                jlbMateria.setFont(fuente4);
                jlbMateria.setHorizontalAlignment(4);
                jlbCurso.setForeground(Color.WHITE);
                jlbCurso.setFont(fuente4);
                jlbCurso.setHorizontalAlignment(4);
                jlbRegimen.setForeground(Color.WHITE);
                jlbRegimen.setFont(fuente4);
                jlbRegimen.setHorizontalAlignment(4);
                jlbNombreInstitucion.setForeground(Color.WHITE);
                jlbNombreInstitucion.setFont(fuente3);
                jlbNombreMateria.setForeground(Color.WHITE);
                jlbNombreMateria.setFont(fuente3);
                jlbNombreCurso.setForeground(Color.WHITE);
                jlbNombreCurso.setFont(fuente3);
                jlbNombreRegimen.setForeground(Color.WHITE);
                jlbNombreRegimen.setFont(fuente3);
                this.jpnTituloLista.add(jlbInstitucion);
                this.jpnTituloLista.add(jlbNombreInstitucion);
                this.jpnTituloLista.add(jlbRegimen);
                this.jpnTituloLista.add(jlbNombreRegimen);
                this.jpnTituloLista.add(jlbMateria);
                this.jpnTituloLista.add(jlbNombreMateria);
                this.jpnTituloLista.add(jlbCurso);
                this.jpnTituloLista.add(jlbNombreCurso);
                this.jbtLogos.setVisible(false);
                this.pnlListaMateria.setVisible(false);
                if (!this.materia.contains("PROYECTOS ESCOLARES") && (this.paralelo.contains("Grupo") || this.paralelo.contains("1er a\u00f1o B\u00e1sica"))) {
                    this.vistaNotaInicial.setVisible(true);
                    this.jpnTrabajo.add((Component)this.vistaNotaInicial, "Center");
                } else {
                    this.vistaNota.setVisible(true);
                    this.jpnTrabajo.add((Component)this.vistaNota, "Center");
                }
                this.jbtEnviar.setEnabled(true);
                break;
            }
            case 4: {
                Object jlbTituloLista = null;
                this.jpnTituloLista.setLayout(new GridLayout(4, 2));
                this.jpnTituloLista.setBorder(new EmptyBorder(15, 0, 15, 15));
                JLabel jlbInstitucion = new JLabel("<html>Instituci\u00f3n:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreInstitucion = new JLabel(this.institucion);
                JLabel jlbRegimen = new JLabel("<html>R\u00e9gimen - A\u00f1o lectivo:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreRegimen = new JLabel(this.regimenAnioLectivo);
                JLabel jlbMateria = new JLabel("<html>Materia:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreMateria = new JLabel(this.materia != null ? this.materia : "TRONCO COM\u00daN");
                JLabel jlbCurso = new JLabel("<html>Grado/Curso:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreCurso = new JLabel(this.paralelo);
                jlbInstitucion.setForeground(Color.WHITE);
                jlbInstitucion.setFont(fuente4);
                jlbInstitucion.setHorizontalAlignment(4);
                jlbMateria.setForeground(Color.WHITE);
                jlbMateria.setFont(fuente4);
                jlbMateria.setHorizontalAlignment(4);
                jlbCurso.setForeground(Color.WHITE);
                jlbCurso.setFont(fuente4);
                jlbCurso.setHorizontalAlignment(4);
                jlbRegimen.setForeground(Color.WHITE);
                jlbRegimen.setFont(fuente4);
                jlbRegimen.setHorizontalAlignment(4);
                jlbNombreInstitucion.setForeground(Color.WHITE);
                jlbNombreInstitucion.setFont(fuente3);
                jlbNombreMateria.setForeground(Color.WHITE);
                jlbNombreMateria.setFont(fuente3);
                jlbNombreCurso.setForeground(Color.WHITE);
                jlbNombreCurso.setFont(fuente3);
                jlbNombreRegimen.setForeground(Color.WHITE);
                jlbNombreRegimen.setFont(fuente3);
                this.jpnTituloLista.add(jlbInstitucion);
                this.jpnTituloLista.add(jlbNombreInstitucion);
                this.jpnTituloLista.add(jlbRegimen);
                this.jpnTituloLista.add(jlbNombreRegimen);
                this.jpnTituloLista.add(jlbMateria);
                this.jpnTituloLista.add(jlbNombreMateria);
                this.jpnTituloLista.add(jlbCurso);
                this.jpnTituloLista.add(jlbNombreCurso);
                this.jbtLogos.setVisible(false);
                this.pnlListaMateria.setVisible(false);
                if (this.materia != null && this.materia.equals("FALTA")) {
                    this.vistaJustificarAsistencia.setVisible(true);
                    this.jpnTrabajo.add((Component)this.vistaJustificarAsistencia, "Center");
                } else if (this.materia == null) {
                    this.vistaAsistencia.setVisible(true);
                    this.jpnTrabajo.add((Component)this.vistaAsistencia, "Center");
                } else {
                    this.vistaAsistenciaBach.setVisible(true);
                    this.jpnTrabajo.add((Component)this.vistaAsistenciaBach, "Center");
                }
                this.jbtEnviar.setEnabled(true);
                break;
            }
            case 5: {
                this.jpnTituloLista.setLayout(new BorderLayout());
                JLabel jlbTituloLista = new JLabel("Planificaci\u00f3n Curricular Anual");
                jlbTituloLista.setForeground(Color.WHITE);
                jlbTituloLista.setFont(fuente2);
                this.jbtCargarPCA.setEnabled(Boolean.TRUE);
                this.jbtEnviarPCA.setEnabled(false);
                this.jpnTituloLista.add((Component)jlbTituloLista, "Center");
                this.jbtLogos.setVisible(false);
                this.vistaNota.setVisible(false);
                this.vistaNotaInicial.setVisible(false);
                this.vistaAsistencia.setVisible(false);
                this.vistaAsistenciaBach.setVisible(false);
                this.vistaJustificarAsistencia.setVisible(false);
                this.pnlListaMateria.establecerSize();
                this.scrollListaMateria.setPreferredSize(this.pnlListaMateria.getPreferredSize());
                this.jpnTrabajo.add((Component)this.scrollListaMateria, "Center");
                this.pnlListaMateria.setVisible(true);
                this.scrollListaMateria.setVisible(true);
                this.pnlListaMateria.repaint();
                this.jpnTrabajo.repaint();
                break;
            }
            case 6: {
                FuncionesAuxiliar objAuxiliar = new FuncionesAuxiliar();
                Object jlbTituloLista = null;
                this.jpnTituloLista.setLayout(new GridLayout(4, 2));
                this.jpnTituloLista.setBorder(new EmptyBorder(15, 0, 15, 15));
                JLabel jlbInstitucion = new JLabel("<html>Instituci\u00f3n:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreInstitucion = new JLabel(this.institucion);
                JLabel jlbRegimen = new JLabel("<html>R\u00e9gimen - A\u00f1o lectivo:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreRegimen = new JLabel(this.regimenAnioLectivo);
                JLabel jlbMateria = new JLabel("<html>Materia:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreMateria = new JLabel(this.materia);
                JLabel jlbCurso = new JLabel("<html>Grado/Curso:&#32;&#32;&#32;&#32;</html>");
                JLabel jlbNombreCurso = new JLabel(this.paralelo);
                jlbInstitucion.setForeground(Color.WHITE);
                jlbInstitucion.setFont(objAuxiliar.establecerFont(3));
                jlbInstitucion.setHorizontalAlignment(4);
                jlbMateria.setForeground(Color.WHITE);
                jlbMateria.setFont(objAuxiliar.establecerFont(3));
                jlbMateria.setHorizontalAlignment(4);
                jlbMateria.setForeground(Color.WHITE);
                jlbMateria.setFont(objAuxiliar.establecerFont(3));
                jlbMateria.setHorizontalAlignment(4);
                jlbCurso.setForeground(Color.WHITE);
                jlbCurso.setFont(objAuxiliar.establecerFont(3));
                jlbCurso.setHorizontalAlignment(4);
                jlbRegimen.setForeground(Color.WHITE);
                jlbRegimen.setFont(objAuxiliar.establecerFont(3));
                jlbRegimen.setHorizontalAlignment(4);
                jlbNombreInstitucion.setForeground(Color.WHITE);
                jlbNombreInstitucion.setFont(objAuxiliar.establecerFont(3));
                jlbNombreMateria.setForeground(Color.WHITE);
                jlbNombreMateria.setFont(objAuxiliar.establecerFont(3));
                jlbNombreCurso.setForeground(Color.WHITE);
                jlbNombreCurso.setFont(objAuxiliar.establecerFont(3));
                jlbNombreRegimen.setForeground(Color.WHITE);
                jlbNombreRegimen.setFont(objAuxiliar.establecerFont(3));
                this.jbtCargarPCA.setEnabled(Boolean.FALSE);
                this.jbtEnviarPCA.setEnabled(objAuxiliar.comprobarConexion());
                this.jpnTituloLista.add(jlbInstitucion);
                this.jpnTituloLista.add(jlbNombreInstitucion);
                this.jpnTituloLista.add(jlbRegimen);
                this.jpnTituloLista.add(jlbNombreRegimen);
                this.jpnTituloLista.add(jlbMateria);
                this.jpnTituloLista.add(jlbNombreMateria);
                this.jpnTituloLista.add(jlbCurso);
                this.jpnTituloLista.add(jlbNombreCurso);
                this.jbtLogos.setVisible(false);
                this.pnlListaMateria.setVisible(true);
                this.vistaNota.setVisible(false);
                this.vistaNotaInicial.setVisible(false);
                this.vistaAsistencia.setVisible(false);
                this.vistaAsistenciaBach.setVisible(false);
                this.vistaJustificarAsistencia.setVisible(false);
                this.scrollListaMateria.setVisible(false);
                this.vistaPcaPlantilla.setVisible(true);
                this.jpnTrabajo.add((Component)this.vistaPcaPlantilla, "Center");
                this.jpnTrabajo.repaint();
            }
        }
        this.jpnCabeceraTrabajo.add((Component)this.jpnTituloLista, "After");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VistaPrincipal().setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GestionArchivo objGestionArchivo = new GestionArchivo();
        String mensajeConfirmar = "";
        String mensajeResultado = "";
        int baseCrear = -1;
        try {
            if (e.getSource() == this.jbtIngresarNotas) {
                if (!this.blnAutorizado) {
                    this.autorizarIngreso();
                }
                if (this.blnAutorizado) {
                    this.pnlListaMateria.removeAll();
                    ControladorMateria controladorMateria = new ControladorMateria(this);
                    this.setIndiceVentana(2);
                    this.formarTrabajo();
                    this.jpnTrabajo.updateUI();
                    this.jbtEnviar.setEnabled(false);
                }
            } else if (e.getSource() == this.jbtSalir) {
                this.cerrarAplicacion();
            } else if (e.getSource() == this.jbtRegresarM) {
                if (this.indiceVentana == 3 || this.indiceVentana == 4) {
                    this.jbtEnviar.setEnabled(false);
                    this.setIndiceVentana(2);
                    this.formarTrabajo();
                } else {
                    this.setIndiceVentana(this.indiceVentana - 1);
                    this.jpnOpciones1.setVisible(true);
                    this.jpnOpciones2.setVisible(false);
                    this.jpnCuerpoMenu.add((Component)this.jpnUsuario, "North");
                    this.jpnCuerpoMenu.add((Component)this.jpnOpciones1, "Center");
                    this.jpnOpciones2.repaint();
                    this.formarTrabajo();
                }
            } else if (e.getSource() == this.jbtIngresarAsistencia) {
                if (!this.blnAutorizado) {
                    this.autorizarIngreso();
                }
                if (this.blnAutorizado) {
                    this.pnlListaMateria.removeAll();
                    ControladorMateria controladorMateria = new ControladorMateria();
                    controladorMateria.consultarParalelosAsignaturasAsistencia(this);
                    this.setIndiceVentana(2);
                    this.formarTrabajo();
                    this.jpnTrabajo.updateUI();
                    this.jbtEnviar.setEnabled(false);
                }
            } else if (e.getSource() == this.jbtAbrir) {
                this.opcionMenu = "Abrir";
                if (!this.blnAutorizado) {
                    this.autorizarIngreso();
                }
                if (this.blnAutorizado) {
                    this.jpnCuerpoMenu.add((Component)this.jpnOpciones2, "Center");
                    this.setIndiceVentana(1);
                    this.formarTrabajo();
                }
            } else if (e.getSource() == this.jbtNuevo) {
                FuncionesAuxiliar objAuxiliar = new FuncionesAuxiliar();
                this.opcionMenu = "Nuevo";
                if (objAuxiliar.comprobarConexion()) {
                    if (!this.blnAutorizado) {
                        this.autorizarIngreso();
                    }
                    if (this.blnAutorizado) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        baseCrear = this.copiarBase("");
                        if (baseCrear == 1) {
                            JOptionPane.showMessageDialog(this, "Se cargaron los listados de estudiantes al sistema.", "Informaci\u00f3n", 1);
                        } else if (baseCrear == 0) {
                            JOptionPane.showMessageDialog(this, "No se cargaron los listados de estudiantes al sistema. Por favor comun\u00edquese con el rector de la instituci\u00f3n a la que pertenece.", "Error", 0);
                        } else if (baseCrear == 3) {
                            JOptionPane.showMessageDialog(this, "No puede acceder al sistema porque es un Rector sin carga horaria.", "Error", 0);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Para cargar los listados de estudiantes al sistema debe estar conectado a Internet. Por favor verifique.", "Informaci\u00f3n", 1);
                }
            } else if (e.getSource() == this.jbtExportar) {
                if (!this.blnAutorizado) {
                    this.autorizarIngreso();
                }
                if (this.blnAutorizado) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    objGestionArchivo.exportarArchivo(this);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            } else if (e.getSource() == this.jbtImportar) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                JFileChooser file = new JFileChooser();
                file.setAcceptAllFileFilterUsed(false);
                FileNameExtensionFilter filtroArchivo = new FileNameExtensionFilter("Listas", "med");
                file.setFileFilter(filtroArchivo);
                if (file.showOpenDialog(this) == 0) {
                    String rutaArchivo = file.getSelectedFile().getAbsolutePath();
                    this.nombreArchivo = file.getSelectedFile().getName();
                    GestionArchivo gestionArchivo = new GestionArchivo();
                    this.opcionMenu = "Importar";
                    if (gestionArchivo.importarArchivo(rutaArchivo, file.getSelectedFile().getName())) {
                        this.opcionMenu = "Importar";
                        if (!this.blnAutorizado) {
                            this.autorizarIngreso();
                            if (!this.blnAutorizado) {
                                gestionArchivo.eliminarArchivo(FileUtil.rutaApp() + "/config/" + this.nombreArchivo);
                                this.setCursor(Cursor.getPredefinedCursor(0));
                                return;
                            }
                        } else if (!this.validarBaseUsuario(FileUtil.rutaApp() + "/config/" + this.nombreArchivo)) {
                            if (this.errorArchivoImportar == 26) {
                                JOptionPane.showMessageDialog(this, "El archivo a importar no tiene la extensi\u00f3n aceptada por la aplicaci\u00f3n", "Error", 0);
                            } else {
                                JOptionPane.showMessageDialog(this, "Las listas a importar no pertenecen al usuario de la sesi\u00f3n actual. ", "Error", 0);
                            }
                            gestionArchivo.eliminarArchivo(FileUtil.rutaApp() + "/config/" + this.nombreArchivo);
                            this.setCursor(Cursor.getPredefinedCursor(0));
                            return;
                        }
                        if ((baseCrear = this.copiarBase(FileUtil.rutaApp() + "/config/" + this.nombreArchivo)) == 1) {
                            JOptionPane.showMessageDialog(this, "Se import\u00f3 correctamente los listados de estudiantes.", "Informaci\u00f3n", 1);
                        } else if (baseCrear == 0) {
                            JOptionPane.showMessageDialog(this, "No se pudo importar los listados de estudiantes. Por favor verifique el archivo y vuelva a intentar.", "Error", 0);
                        }
                        gestionArchivo.eliminarArchivo(FileUtil.rutaApp() + "/config/" + this.nombreArchivo);
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (e.getSource() == this.jbtEnviar) {
                FuncionesAuxiliar objAuxiliar = new FuncionesAuxiliar();
                this.opcionMenu = "Enviar";
                SincronizarServidoresMinEduc sincronizar = new SincronizarServidoresMinEduc();
                SincronizarNotas sincronizarNotas = new SincronizarNotas();
                if (objAuxiliar.comprobarConexion()) {
                    int enviarDatos = -1;
                    int opcionSincronizacion = 0;
                    boolean opcionNivel = false;
                    if (this.getIndiceVentana() == 3) {
                        mensajeConfirmar = "\u00bfEst\u00e1 seguro de enviar las notas de los estudiantes?";
                        mensajeResultado = "El env\u00edo de las notas de los estudiantes se realiz\u00f3 correctamente.";
                        opcionSincronizacion = 1;
                    } else if (this.getIndiceVentana() == 4) {
                        mensajeConfirmar = "\u00bfEst\u00e1 seguro de enviar las asistencias de los estudiantes?";
                        mensajeResultado = "El env\u00edo de las asistencias de los estudiantes se realiz\u00f3 correctamente.";
                        opcionSincronizacion = this.materia == null ? 2 : (this.materia.equals("FALTA") ? 4 : 3);
                    }
                    enviarDatos = JOptionPane.showConfirmDialog(this, mensajeConfirmar);
                    if (enviarDatos == 0) {
                        String mensajeEnvio;
                        int migracionCorrecta = 1;
                        if (opcionSincronizacion == 1) {
                            migracionCorrecta = this.materia.contains("PROYECTOS ESCOLARES") ? sincronizarNotas.asentarNotaCualitativaEnServidor(this.vistaNota.getIdEscenarioSeleccionado(), this.vistaNota.getIdEscenarioDiscrecionSeleccionado()) : (this.materia.contains("RECOMENDACIONES") ? sincronizarNotas.asentarRecomendacionesEnServidor(this.vistaNota.getIdEscenarioSeleccionado(), this.vistaNota.getIdEscenarioDiscrecionSeleccionado()) : (this.materia.contains("COMPORTAMIENTO") ? sincronizarNotas.asentarNotaCualitativaEnServidor(this.vistaNota.getIdEscenarioSeleccionado(), this.vistaNota.getIdEscenarioDiscrecionSeleccionado()) : (this.paralelo.contains("Grupo") ? sincronizarNotas.asentarNotasInicialEnServidor(this.vistaNotaInicial.getCodigoParaleloSeleccionado()) : (this.paralelo.contains("1er a\u00f1o B\u00e1sica") ? sincronizarNotas.asentarNotasInicialEnServidor(this.vistaNotaInicial.getCodigoParaleloSeleccionado()) : sincronizarNotas.asentarCalificacionesEnServidor(this.vistaNota.getIdEscenarioSeleccionado(), this.vistaNota.getIdEscenarioDiscrecionSeleccionado())))));
                            mensajeEnvio = migracionCorrecta == 1 ? "" : "El env\u00edo de las notas present\u00f3 inconvenientes. Por favor verifique la conexi\u00f3n de internet y vuelva a intentar.";
                        } else {
                            migracionCorrecta = opcionSincronizacion == 4 ? sincronizar.asentarJustificacionEGBEnServidor(this.vistaJustificarAsistencia.getCodigoParaleloSeleccionado(), this.vistaJustificarAsistencia.getGrado().getNemonico()) : (opcionSincronizacion == 2 ? sincronizar.asentarAsistenciaEnServidor(this.vistaAsistencia.getAsistencia()) : sincronizar.asentarAsistenciaBachilleratoEnServidor(this.vistaAsistenciaBach.getCodigoParaleloSeleccionado()));
                            String string = mensajeEnvio = migracionCorrecta == 1 ? "" : "El env\u00edo de la asistencia present\u00f3 inconvenientes. Por favor verifique la conexi\u00f3n de internet y vuelva a intentar.";
                        }
                        if (migracionCorrecta == -1) {
                            mensajeResultado = "El servicio de env\u00edo de notas no est\u00e1 disponible. Por favor espere unos minutos mientras se reestablece la conexi\u00f3n y vuelva a intentar.";
                        }
                        if (migracionCorrecta == 0) {
                            mensajeResultado = mensajeEnvio;
                        } else {
                            switch (opcionSincronizacion) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    this.vistaAsistencia.getMesSeleccionado();
                                    this.vistaAsistencia.updateUI();
                                    break;
                                }
                                case 3: {
                                    this.vistaAsistenciaBach.getRangoSeleccionado();
                                    this.vistaAsistenciaBach.updateUI();
                                }
                            }
                        }
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        JOptionPane.showMessageDialog(this, mensajeResultado, "Informaci\u00f3n", 1);
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Para enviar los datos de notas y asistencias debe estar conectado a Internet. Por favor verifique.", "Informaci\u00f3n", 1);
                }
                this.jbtEnviar.setEnabled(true);
            } else if (e.getSource() == this.jbtPCA) {
                this.opcionMenu = "PCA";
                if (!this.blnAutorizado) {
                    this.autorizarIngreso();
                }
                if (this.blnAutorizado) {
                    String nombreBDD = this.usuario.substring(0, this.usuario.indexOf(".")) + this.usuario.substring(this.usuario.indexOf(".") + 1);
                    if (objGestionArchivo.validarExistenciaBDD(nombreBDD)) {
                        Integer idUsuarioCreacion = this.instructorDao.obtenerIdUsuario();
                        if (null == idUsuarioCreacion) {
                            JOptionPane.showMessageDialog(this, "No dispone de lista de estudiantes cargadas.\n Por favor ejecute la opci\u00f3n cargar la lista de estudiantes.", "Informaci\u00f3n", 1);
                        } else {
                            this.cargarMateriasPCA();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this, "No dispone de lista de estudiantes cargadas.\n Por favor ejecute la opci\u00f3n cargar la lista de estudiantes.", "Informaci\u00f3n", 1);
                    }
                }
            } else if (e.getSource() == this.jbtCargarPCA) {
                if (JOptionPane.showConfirmDialog(this, "\u00bfDesea descargar los PCA asignados?", "Confirmaci\u00f3n", 0) == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (this.copiarBasePCA().booleanValue()) {
                        this.cargarMateriasPCA();
                        JOptionPane.showMessageDialog(this, "Los PCA fueron cargados exitosamente.", "Informaci\u00f3n", 1);
                    } else {
                        Integer idUsuarioCreacion = this.instructorDao.obtenerIdUsuario();
                        if (null == idUsuarioCreacion) {
                            JOptionPane.showMessageDialog(this, "No dispone de lista de estudiantes cargadas.\n Por favor ejecute la opci\u00f3n cargar la lista de estudiantes.", "Informaci\u00f3n", 1);
                        } else {
                            JOptionPane.showMessageDialog(this, "No se encontraron PCA para cargar.", "Informaci\u00f3n", 1);
                        }
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            } else if (e.getSource() == this.jbtEnviarPCA) {
                FuncionesAuxiliar objAuxiliar = new FuncionesAuxiliar();
                if (objAuxiliar.comprobarConexion()) {
                    if (null != this.vistaPcaPlantilla.getPca().getEstado() && EstadoEnum.ESTADO_ACTIVO.getEstado().equals(this.vistaPcaPlantilla.getPca().getEstado())) {
                        if (JOptionPane.showConfirmDialog(this, "\u00bfEst\u00e1 seguro de enviar el PCA seleccionado?", "Confirmaci\u00f3n", 0) == 0) {
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            this.vistaPcaPlantilla.enviar(false);
                            this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    } else {
                        Object[] options = new Object[]{"Enviar", "Enviar y Finalizar", "Cancelar"};
                        int n = JOptionPane.showOptionDialog(this, "\u00bfEst\u00e1 seguro de enviar el PCA seleccionado?", "Confirmaci\u00f3n", 1, 3, null, options, options[0]);
                        switch (n) {
                            case 0: {
                                this.setCursor(Cursor.getPredefinedCursor(3));
                                this.vistaPcaPlantilla.enviar(false);
                                this.setCursor(Cursor.getPredefinedCursor(0));
                                break;
                            }
                            case 1: {
                                if (JOptionPane.showConfirmDialog(this, "Se enviar\u00e1 el PCA para que los docentes lo puedan descargar\n \u00bfEst\u00e1 seguro de continuar?", "Confirmaci\u00f3n", 0) != 0) break;
                                this.setCursor(Cursor.getPredefinedCursor(3));
                                this.vistaPcaPlantilla.enviar(true);
                                this.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Para enviar datos del PCA debe estar conectado a Internet. Por favor verifique.", "Informaci\u00f3n", 1);
                }
            } else if (e.getSource() == this.jbtRegresarPCA) {
                this.regresarPCA();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Ha ocurrido un error, por favor comunicarse con el rector de la instituci\u00f3n a la que pertenece." + ex.getMessage(), "Error", 0);
            Logger.getLogger(VistaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public void regresarPCA() {
        if (this.getIndiceVentana() == 6) {
            if (null != this.vistaPcaPlantilla) {
                this.vistaPcaPlantilla.setVisible(false);
            }
            this.setIndiceVentana(5);
        } else {
            this.controladorPCA = null;
            this.setIndiceVentana(0);
        }
        Util.ejecutarGC();
        this.formarTrabajo();
        this.pnlListaMateria.updateUI();
        this.jpnTrabajo.updateUI();
    }

    public void cargarMateriasPCA() {
        this.pnlListaMateria.removeAll();
        this.controladorPCA = new ControladorPCA();
        this.controladorPCA.cargarPCA(this);
        this.setIndiceVentana(5);
        this.formarTrabajo();
        this.pnlListaMateria.updateUI();
        this.jpnTrabajo.updateUI();
    }

    public void autorizarIngreso() {
        VistaLogin vistaLogin = new VistaLogin((Frame)this, true);
        vistaLogin.setBlnAutorizado(false);
        UsuarioDaoImpl usuarioDao = new UsuarioDaoImpl();
        FuncionesAuxiliar objAuxiliar = new FuncionesAuxiliar();
        ControladorLogin controladorLogin = new ControladorLogin(vistaLogin, usuarioDao, objAuxiliar.comprobarConexion());
        controladorLogin.setOpcionMenu(this.opcionMenu);
        if (this.nombreArchivo != "") {
            controladorLogin.setNombreArchivo(this.nombreArchivo);
        }
        vistaLogin.setVisible(true);
        if (vistaLogin.isBlnAutorizado() && this.aplicacionActualizada()) {
            InfoUsuarioVO infoUsuario = InfoUsuarioVO.obtenerInstancia();
            JLabel jlBienvenido = new JLabel("<html>BIENVENIDO</html>");
            jlBienvenido.setFont(new Font("Arial Narrow", 0, 18));
            jlBienvenido.setVerticalAlignment(0);
            jlBienvenido.setForeground(new Color(9, 113, 206));
            if (infoUsuario.getUsuario() != null) {
                JLabel jlbUsuario = new JLabel("<html>" + infoUsuario.getUsuario().getNombre() + "</html>");
                JLabel jlbIdentificacion = new JLabel("<html>" + infoUsuario.getUsuario().getIdentificacion() + "</html>");
                jlbIdentificacion.setFont(new FuncionesAuxiliar().establecerFont(3));
                jlbIdentificacion.setHorizontalAlignment(2);
                jlbIdentificacion.setVerticalAlignment(0);
                jlbIdentificacion.setForeground(new Color(102, 105, 107));
                jlbUsuario.setFont(new FuncionesAuxiliar().establecerFont(3));
                jlbUsuario.setHorizontalAlignment(2);
                jlbUsuario.setVerticalAlignment(0);
                jlbUsuario.setForeground(new Color(59, 60, 61));
                this.jpnUsuario.setLayout(new GridLayout(3, 1));
                this.jpnUsuario.setBorder(new EmptyBorder(10, 25, 0, 10));
                this.jpnUsuario.add(jlBienvenido);
                this.jpnUsuario.add(jlbUsuario);
                this.jpnUsuario.add(jlbIdentificacion);
            }
            this.jpnCuerpoMenu.setLayout(new BorderLayout());
            this.jpnCuerpoMenu.add((Component)this.jpnUsuario, "North");
            this.jpnCuerpoMenu.add((Component)this.jpnOpciones2, "Center");
            this.usuario = vistaLogin.jtxUsuario.getText().trim();
            this.contrasenia = vistaLogin.jtxContrasenia.getText().trim();
            vistaLogin.dispose();
            this.blnAutorizado = true;
        } else {
            this.errorArchivoImportar = controladorLogin.getErrorArchivo();
        }
    }

    public int copiarBase(String origen) {
        GestionArchivo objGestionar = new GestionArchivo();
        int copiar = 0;
        int sobreescribir = -1;
        int descarga = 0;
        FuncionesAuxiliar objAuxiliar = new FuncionesAuxiliar();
        try {
            String nombreBDD = this.usuario.substring(0, this.usuario.indexOf(".")) + this.usuario.substring(this.usuario.indexOf(".") + 1);
            boolean existeBDD = objGestionar.validarExistenciaBDD(nombreBDD);
            if (existeBDD && objAuxiliar.comprobarConexion()) {
                sobreescribir = JOptionPane.showConfirmDialog(this, "Existen listas cargadas actualmente.  Desea reemplazar las listas cargadas actualmente?");
                if (this.opcionMenu.equals("Nuevo") && sobreescribir == 0) {
                    this.envioMasivo(InfoUsuarioVO.obtenerInstancia().getUsuario().getIdentificacion());
                }
            } else {
                sobreescribir = existeBDD ? JOptionPane.showConfirmDialog(this, "Existen listas cargadas actualmente. Desea reemplazar las listas cargadas actualmente?") : 0;
            }
            if (sobreescribir == 0) {
                if (origen == "") {
                    if (objGestionar.crearBDD(nombreBDD, origen, existeBDD)) {
                        descarga = new SincronizarServidoresMinEduc().descargarInformacionInicial(InfoUsuarioVO.obtenerInstancia().getUsuario().getIdentificacion());
                        if (descarga == 1) {
                            ControladorLogin controladorLogin = new ControladorLogin();
                            controladorLogin.InsertarCredenciales(InfoUsuarioVO.obtenerInstancia().getUsuario());
                            copiar = 1;
                        } else if (InfoUsuarioVO.obtenerInstancia().getUsuario().getTipo().equals("Rector")) {
                            copiar = 3;
                        }
                    }
                } else if (objGestionar.crearBDD(nombreBDD, origen, existeBDD)) {
                    copiar = 1;
                }
            } else {
                copiar = 2;
            }
        }
        catch (Exception ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return copiar;
    }

    public JLabel getJlbConexion() {
        return this.jlbConexion;
    }

    public void setJlbConexion(JLabel jlbConexion) {
        this.jlbConexion = jlbConexion;
    }

    public String getRegimenAnioLectivo() {
        return this.regimenAnioLectivo;
    }

    public void setRegimenAnioLectivo(String regimenAnioLectivo) {
        this.regimenAnioLectivo = regimenAnioLectivo;
    }

    public boolean aplicacionActualizada() {
        boolean actualizada = true;
        System.out.println(FileUtil.rutaApp() + "/config/");
        try {
            System.out.println(FileUtil.rutaApp() + "/config/" + ObtenerPropiedad.obtenerPropiedadFile("plantilla"));
        }
        catch (Exception ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        boolean consultarPlantilla = true;
        boolean conectadoYConVistaAlServidor = false;
        try {
            String urlPlantilla = FileUtil.rutaApp() + "/config/" + ObtenerPropiedad.obtenerPropiedadFile("plantilla");
            Util.desencriptaArchivoBB(urlPlantilla);
            Date fechaVersionAPPServidor = Updater.getLastModification();
            Date fechaVersionBasePlantilla = MigrateDatabase.consultarUltimaActualizacionApp("A", fechaVersionAPPServidor, consultarPlantilla);
            Date fechaVersionBaseUsuarioConectado = MigrateDatabase.consultarUltimaActualizacionApp("A", fechaVersionAPPServidor, !consultarPlantilla);
            if (this.pnlConexion.isVisible() && fechaVersionAPPServidor != null) {
                if (fechaVersionAPPServidor.after(fechaVersionBasePlantilla) || fechaVersionBaseUsuarioConectado.after(fechaVersionBasePlantilla)) {
                    conectadoYConVistaAlServidor = true;
                    UpdateInfo updateInfo = new UpdateInfo("", this, true, conectadoYConVistaAlServidor);
                    updateInfo.setVisible(true);
                    actualizada = false;
                }
            } else if (null != fechaVersionBaseUsuarioConectado && fechaVersionBaseUsuarioConectado.after(fechaVersionBasePlantilla)) {
                UpdateInfo updateInfo = new UpdateInfo("<html><b>LA APLICACI\u00d3N NECESITA ACTUALIZARSE.</b><br/> POR FAVOR CONECTARSE A INTERNET Y ACTUALIZARLA PARA SU CORRECTO FUNCIONAMIENTO.<br/> SI EL PROBLEMA PERSISTE FAVOR COMUNICARSE CON EL RECTOR DE LA INSTITUCI\u00d3N.</htm>", this, true, conectadoYConVistaAlServidor);
                updateInfo.setVisible(true);
                actualizada = false;
            }
            if (actualizada) {
                Util.encriptaArchivoBB(urlPlantilla);
            }
        }
        catch (Exception ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return actualizada;
    }

    public boolean envioMasivo(String identificacion) {
        boolean envio = false;
        SincronizarServidoresMinEduc sincronizar = new SincronizarServidoresMinEduc();
        SincronizarNotas sincronizarNotas = new SincronizarNotas();
        AsistenciaEducacionBasicaDaoImpl asistenciaEducacionBasicaDao = new AsistenciaEducacionBasicaDaoImpl();
        SincronizarPca sincronizarPca = new SincronizarPca();
        try {
            sincronizarNotas.asentarCalificacionesEnServidor(0, 0);
            sincronizarNotas.asentarNotasInicialEnServidor(0);
            sincronizarNotas.asentarNotaCualitativaEnServidor(0, 0);
            sincronizarNotas.asentarRecomendacionesEnServidor(0, 0);
            sincronizar.asentarAsistenciaBachilleratoEnServidor(0);
            sincronizar.asentarAsistenciaEnServidor(asistenciaEducacionBasicaDao.buscarTodo());
            sincronizarPca.enviarInformacion(null);
        }
        catch (Exception ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return envio;
    }

    public boolean validarBaseUsuario(String nombreArchivo) throws FileNotFoundException {
        UsuarioDaoImpl usuarioDao = new UsuarioDaoImpl();
        List<Object> listaUsuario = new ArrayList();
        boolean validar = false;
        try {
            if (this.blnAutorizado) {
                Util.desencriptaArchivoBB(nombreArchivo);
                String usu = InfoUsuarioVO.obtenerInstancia().getUsuario().getResu();
                String pass = InfoUsuarioVO.obtenerInstancia().getUsuario().getSsap();
                listaUsuario = usuarioDao.BuscarUsuarioImportar(usu, pass, nombreArchivo);
                if (listaUsuario.size() > 0) {
                    validar = true;
                }
            }
        }
        catch (SQLException ex) {
            this.errorArchivoImportar = ex.getErrorCode();
        }
        catch (Exception ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return validar;
    }

    public Boolean copiarBasePCA() {
        GestionArchivo objGestionar = new GestionArchivo();
        boolean descarga = false;
        FuncionesAuxiliar objAuxiliar = new FuncionesAuxiliar();
        try {
            String nombreBDD = this.usuario.substring(0, this.usuario.indexOf(".")) + this.usuario.substring(this.usuario.indexOf(".") + 1);
            if (objAuxiliar.comprobarConexion()) {
                boolean existeBDD = objGestionar.validarExistenciaBDD(nombreBDD);
                if (!existeBDD) {
                    this.copiarBase("");
                    existeBDD = objGestionar.validarExistenciaBDD(nombreBDD);
                }
                if (existeBDD) {
                    SincronizarPca sincronizarPca = new SincronizarPca();
                    if (sincronizarPca.tieneInformacionParaEnviar().booleanValue()) {
                        Object[] options = new Object[]{"Enviar", "No Enviar", "Cancelar"};
                        int n = JOptionPane.showOptionDialog(this, "Existen datos de PCA almacenados \u00bfDesea enviarlos antes de cargar nuevos datos del PCA?", "Confirmaci\u00f3n", 1, 3, null, options, options[0]);
                        switch (n) {
                            case 0: {
                                sincronizarPca.enviarInformacion(null);
                                sincronizarPca.limipiarPca();
                                descarga = sincronizarPca.descargarInformacion(InfoUsuarioVO.obtenerInstancia().getUsuario().getIdentificacion());
                                break;
                            }
                            case 1: {
                                if (JOptionPane.showConfirmDialog(this, "Se eliminar\u00e1n los datos de los PCA y se cargar\u00e1n los nuevos, \u00bfest\u00e1 seguro de continuar?", "Confirmaci\u00f3n", 0) != 0) break;
                                sincronizarPca.limipiarPca();
                                descarga = sincronizarPca.descargarInformacion(InfoUsuarioVO.obtenerInstancia().getUsuario().getIdentificacion());
                            }
                        }
                    } else {
                        descarga = sincronizarPca.descargarInformacion(InfoUsuarioVO.obtenerInstancia().getUsuario().getIdentificacion());
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Lo sentimos no pudimos crear el archivo de configuraci\u00f3n necesario, por favor intente en unos minutos", "Error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Para descargar datos del PCA debe estar conectado a Internet. Por favor verifique.", "Informaci\u00f3n", 1);
            }
        }
        catch (Exception ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return descarga;
    }

    public VistaPcaPlantilla getVistaPcaPlantilla() {
        return this.vistaPcaPlantilla;
    }

    public void setVistaPcaPlantilla(VistaPcaPlantilla vistaPcaPlantilla) {
        this.vistaPcaPlantilla = vistaPcaPlantilla;
    }

    class VerificarConexion
    extends TimerTask {
        VerificarConexion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int puerto = 80;
            Socket s = null;
            try {
                s = new Socket(EnlacesEnum.GOOGLE.getUrl(), puerto);
                if (s.isConnected()) {
                    VistaPrincipal.this.panelConexion.add((Component)VistaPrincipal.this.pnlConexion, "After");
                    VistaPrincipal.this.pnlConexion.setVisible(true);
                    VistaPrincipal.this.pnlSinConexion.setVisible(false);
                } else {
                    VistaPrincipal.this.panelConexion.add((Component)VistaPrincipal.this.pnlSinConexion, "After");
                    VistaPrincipal.this.pnlConexion.setVisible(false);
                    VistaPrincipal.this.pnlSinConexion.setVisible(true);
                }
                if (VistaPrincipal.this.contadorImg == 3) {
                    VistaPrincipal.this.contadorImg -= 3;
                } else {
                    if (VistaPrincipal.this.contadorImg == 0) {
                        VistaPrincipal.this.jbtLogos.setIcon(new ImageIcon(this.getClass().getResource("/Imagenes/imagen1.png")));
                    } else if (VistaPrincipal.this.contadorImg == 1) {
                        VistaPrincipal.this.jbtLogos.setIcon(new ImageIcon(this.getClass().getResource("/Imagenes/imagen2.png")));
                    } else if (VistaPrincipal.this.contadorImg == 2) {
                        VistaPrincipal.this.jbtLogos.setIcon(new ImageIcon(this.getClass().getResource("/Imagenes/imagen3.png")));
                    }
                    ++VistaPrincipal.this.contadorImg;
                }
            }
            catch (Exception e) {
                VistaPrincipal.this.panelConexion.add((Component)VistaPrincipal.this.pnlSinConexion, "After");
                VistaPrincipal.this.pnlSinConexion.setVisible(true);
                VistaPrincipal.this.pnlConexion.setVisible(false);
            }
            finally {
                if (null != s) {
                    try {
                        s.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(VistaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }
}

