/*
 * Decompiled with CFR 0.152.
 */
package Controladores;

import Controladores.ControladorNota;
import Modelos.Dao.UsuarioDao;
import Modelos.Dao.UsuarioDaoImpl;
import Modelos.Entidades.Usuario;
import Servicios.ConexionDA;
import Servicios.MD5;
import Util.FileUtil;
import Util.MessageWithLink;
import Util.MsgLog;
import Util.ObtenerPropiedad;
import Util.Util;
import Vistas.GestionArchivo;
import Vistas.VistaLogin;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.exception.ExceptionUtils;
import vo.InfoUsuarioVO;

public class ControladorLogin
implements ActionListener,
KeyListener {
    VistaLogin vistaLogin;
    UsuarioDao usuarioDao = new UsuarioDaoImpl();
    List<Usuario> listaUsuario = new ArrayList<Usuario>();
    boolean conexionInternet = false;
    private String opcionMenu;
    private String nombreArchivo;
    private int errorArchivo = -1;

    public ControladorLogin() {
        JFrame jprueba = new JFrame();
        this.vistaLogin = new VistaLogin((Frame)jprueba, true);
    }

    public ControladorLogin(VistaLogin vistaLogin, UsuarioDao usuarioDao, boolean conexion) {
        this.vistaLogin = vistaLogin;
        this.usuarioDao = usuarioDao;
        this.vistaLogin.btnIngresar.addActionListener(this);
        this.vistaLogin.btnIngresar.addKeyListener(this);
        this.vistaLogin.jtxContrasenia.addActionListener(this);
        this.vistaLogin.jtxUsuario.getText();
        this.vistaLogin.jtxContrasenia.getText();
        this.conexionInternet = conexion;
        this.vistaLogin.jpnLogo.setBackground(new Color(0, 140, 205));
        this.vistaLogin.jpnLogo.setBackground(new Color(0, 140, 205));
        this.vistaLogin.btnIngresar.setBackground(new Color(0, 140, 205));
        this.vistaLogin.btnIngresar.setForeground(Color.WHITE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.validarUsuario();
        }
        catch (Exception ex) {
            Logger.getLogger(ControladorLogin.class.getName()).log(Level.SEVERE, null, ex);
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean ActualizarCredenciales(String resu, String ssap) {
        try {
            String resuLargo = resu.concat(ObtenerPropiedad.obtenerPropiedad("dominioLargo"));
            this.listaUsuario = this.usuarioDao.BuscarPorNombreUsuario(MD5.getMD5(resuLargo));
            if (this.listaUsuario.size() == 1) {
                this.usuarioDao.ActualizarCredenciales(MD5.getMD5(resuLargo), MD5.getMD5(ssap), this.listaUsuario.get(0).getId());
                InfoUsuarioVO infoUsuario = InfoUsuarioVO.obtenerInstancia();
                infoUsuario.setUsuario(this.listaUsuario.get(0));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ControladorNota.class.getName()).log(Level.SEVERE, null, ex);
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return true;
    }

    public boolean InsertarCredenciales(String resu, String ssap) {
        try {
            String string = resu.concat(ObtenerPropiedad.obtenerPropiedad("dominioLargo"));
        }
        catch (Exception ex) {
            Logger.getLogger(ControladorNota.class.getName()).log(Level.SEVERE, null, ex);
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return true;
    }

    public boolean InsertarCredenciales(Usuario usuario) {
        try {
            String resuLargo = usuario.getResu().concat(ObtenerPropiedad.obtenerPropiedad("dominioLargo"));
            this.usuarioDao.InsertarCredenciales(usuario.getResu(), usuario.getSsap(), usuario.getIdentificacion(), usuario.getNombre(), usuario.getTipo());
        }
        catch (Exception ex) {
            Logger.getLogger(ControladorNota.class.getName()).log(Level.SEVERE, null, ex);
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return true;
    }

    public boolean validarUsuarioImportar(String usuario, String pass) throws Exception {
        boolean validar = false;
        Util.desencriptaArchivoBB(FileUtil.rutaApp() + "/config/" + this.nombreArchivo);
        this.listaUsuario = this.usuarioDao.BuscarUsuarioImportar(MD5.getMD5(usuario), MD5.getMD5(pass), FileUtil.rutaApp() + "/config/" + this.nombreArchivo);
        if (!this.listaUsuario.isEmpty()) {
            validar = true;
        }
        return validar;
    }

    public void validarUsuario() {
        try {
            if (this.vistaLogin.jtxUsuario.getText().isEmpty() || this.vistaLogin.jtxContrasenia.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.vistaLogin, "No existen credenciales de acceso para ingresar al sistema. Por favor ingrese el usuario y contrase\u00f1a.", "Informaci\u00f3n", 1);
            } else {
                String resu = this.vistaLogin.jtxUsuario.getText();
                resu = resu.toLowerCase();
                String ssap = String.valueOf(this.vistaLogin.jtxContrasenia.getPassword());
                String resuCorto = resu.concat(ObtenerPropiedad.obtenerPropiedad("dominioCorto"));
                String resuLargo = resu.concat(ObtenerPropiedad.obtenerPropiedad("dominioLargo"));
                boolean blnAutenticado = false;
                GestionArchivo objGestionar = new GestionArchivo();
                Usuario usuario = new Usuario();
                String nombreBDD = resu.substring(0, resu.indexOf(".")) + resu.substring(resu.indexOf(".") + 1);
                boolean existeBDD = objGestionar.validarExistenciaBDD(nombreBDD);
                if (!existeBDD && this.getOpcionMenu().equals("Abrir")) {
                    JOptionPane.showMessageDialog(this.vistaLogin, "No se cargaron los listados de estudiantes. Por favor dar clic en \"Cargar listas de estudiantes\" para importar los listados", "Informaci\u00f3n", 1);
                    this.vistaLogin.setVisible(false);
                    return;
                }
                if (this.getOpcionMenu().equals("Importar")) {
                    if (this.validarUsuarioImportar(resuLargo, ssap)) {
                        blnAutenticado = true;
                    }
                } else {
                    if (existeBDD) {
                        Util.desencriptaArchivoBB(FileUtil.rutaApp() + "/config/" + nombreBDD.concat(".med"));
                    }
                    if (this.conexionInternet) {
                        ConexionDA objConexion = new ConexionDA();
                        usuario = objConexion.ValidarUsuarioWS(resuCorto, ssap);
                        if (usuario != null) {
                            if (usuario.getIdentificacion() != null) {
                                blnAutenticado = true;
                                if (existeBDD) {
                                    this.listaUsuario = this.usuarioDao.BuscarPorNombreUsuario(MD5.getMD5(resuLargo));
                                    if (this.listaUsuario.size() > 0) {
                                        this.listaUsuario = this.usuarioDao.BuscarPorCredenciales(MD5.getMD5(resuLargo), MD5.getMD5(ssap));
                                        if (this.listaUsuario.size() == 0) {
                                            this.usuarioDao.ActualizarCredenciales(MD5.getMD5(resuLargo), MD5.getMD5(ssap), this.usuarioDao.BuscarPorNombreUsuario(MD5.getMD5(resuLargo)).get(0).getId());
                                            this.listaUsuario = this.usuarioDao.BuscarPorCredenciales(MD5.getMD5(resuLargo), MD5.getMD5(ssap));
                                        }
                                    } else {
                                        usuario.setResu(MD5.getMD5(resuLargo));
                                        usuario.setSsap(MD5.getMD5(ssap));
                                    }
                                }
                            } else if (null != usuario.getEstado() && "cambiarclave".equals(usuario.getEstado())) {
                                JOptionPane.showMessageDialog(null, new MessageWithLink("Debe cambiar su contrase\u00f1a, <a href=\"https://correo.educacion.gob.ec\">click aqu\u00ed</a>"));
                            }
                        }
                    } else if (existeBDD) {
                        this.listaUsuario = this.usuarioDao.BuscarPorCredenciales(MD5.getMD5(resuLargo), MD5.getMD5(ssap));
                        if (this.listaUsuario.isEmpty()) {
                            JOptionPane.showMessageDialog(this.vistaLogin, "El usuario no existe o las credenciales se encuentran incorrectas.", "Informaci\u00f3n", 0);
                        } else {
                            JOptionPane.showMessageDialog(this.vistaLogin, "Usuario correcto.", "Informaci\u00f3n", 1);
                            blnAutenticado = true;
                            this.vistaLogin.setVisible(false);
                        }
                    }
                }
                if (blnAutenticado) {
                    InfoUsuarioVO infoUsuario = InfoUsuarioVO.obtenerInstancia();
                    if (this.listaUsuario.size() > 0) {
                        infoUsuario.setUsuario(this.listaUsuario.get(0));
                    } else {
                        usuario.setResu(MD5.getMD5(resuLargo));
                        usuario.setSsap(MD5.getMD5(ssap));
                        infoUsuario.setUsuario(usuario);
                    }
                } else if (this.getOpcionMenu().equals("Importar")) {
                    JOptionPane.showMessageDialog(this.vistaLogin, "Las listas a importar no pertenecen al usuario de la sesi\u00f3n actual. Seleccione el archivo que corresponda al usuario.", "Informaci\u00f3n", 1);
                } else {
                    JOptionPane.showMessageDialog(this.vistaLogin, "El usuario no existe o las credenciales se encuentran incorrectas.", "Error Usuario", 0);
                }
                this.vistaLogin.setVisible(false);
                this.vistaLogin.setBlnAutorizado(blnAutenticado);
            }
        }
        catch (SQLException ex) {
            this.errorArchivo = ex.getErrorCode();
            if (this.errorArchivo == 26) {
                JOptionPane.showMessageDialog(this.vistaLogin, "El archivo a importar no tiene la extensi\u00f3n aceptada por la aplicaci\u00f3n", "Error", 0);
            } else {
                JOptionPane.showMessageDialog(this.vistaLogin, "Los datos ingresados son incorrectos.", "Informaci\u00f3n", 1);
            }
            Logger.getLogger(ControladorLogin.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            String mensaje = "Ocurri\u00f3 un error en el proceso interno de validaci\u00f3n. Por favor comun\u00edquese con el administrador del sistema.";
            if (ex.getMessage() != null && ex.getMessage().contains("404")) {
                mensaje = "Las credenciales son incorrectas. Por favor verifique.";
            } else if (ex.getMessage() != null && ex.getMessage().contains("400")) {
                mensaje = "Informaci\u00f3n incompleta del usuario en el Directorio Activo. Por favor comun\u00edquese con el administrador del sistema.";
            } else if (ex.getMessage() != null && ex.getMessage().contains("204")) {
                mensaje = "El usuario no es docente o rector. Por favor verifique.";
            } else if (ex.getMessage() != null && ex.getMessage().contains("500")) {
                mensaje = "Error de conexi\u00f3n al Directorio Activo. Por favor comun\u00edquese con el administrador del sistema.";
            }
            JOptionPane.showMessageDialog(this.vistaLogin, mensaje, "Informaci\u00f3n", 1);
            Logger.getLogger(ControladorLogin.class.getName()).log(Level.SEVERE, null, ex);
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public String getOpcionMenu() {
        return this.opcionMenu;
    }

    public void setOpcionMenu(String opcionMenu) {
        this.opcionMenu = opcionMenu;
    }

    public String getNombreArchivo() {
        return this.nombreArchivo;
    }

    public void setNombreArchivo(String nombreArchivo) {
        this.nombreArchivo = nombreArchivo;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.validarUsuario();
        } else {
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getErrorArchivo() {
        return this.errorArchivo;
    }
}

