/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Enumeradores.NivelEnum;
import Modelos.Dao.DestrezaPcaDao;
import Modelos.Entidades.DestrezaPca;
import Servicios.ConexionSQLite;
import Util.Constantes;
import Util.DestrezaPcaUtil;
import Util.Util;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.ArrayUtils;

public class DestrezaPcaDaoImpl
extends ConexionSQLite
implements DestrezaPcaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaDestrezaPcaDao(List<DestrezaPca> listaDestrezaPca) {
        if (null != listaDestrezaPca && !listaDestrezaPca.isEmpty()) {
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" INSERT INTO destreza_pca(");
                sql.append("id, ");
                sql.append("id_materia, ");
                sql.append("nombre, ");
                sql.append("descripcion, ");
                sql.append("tipo_destreza, ");
                sql.append("color, ");
                sql.append("id_usuario_creacion, ");
                sql.append("fecha_creacion, ");
                sql.append("reg_anio_inicio, ");
                sql.append("nemonico_nivel) ");
                sql.append(" values(?,?,?,?,?,?,?,?,?,? ) ");
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql.toString());
                for (DestrezaPca destreza : listaDestrezaPca) {
                    if (null == destreza) continue;
                    ps.setObject(1, (Object)destreza.getId(), 4);
                    ps.setInt(2, destreza.getIdMateria());
                    ps.setString(3, destreza.getNombre());
                    ps.setString(4, destreza.getDescripcion());
                    ps.setString(5, destreza.getTipo());
                    ps.setString(6, destreza.getColor());
                    ps.setInt(7, destreza.getIdUsuarioCreacion());
                    ps.setObject(8, (Object)destreza.getFechaCreacion(), 91);
                    ps.setString(9, destreza.getRegAnioInicio());
                    ps.setString(10, destreza.getNemonicoNivelEducativo());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(DestrezaPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DestrezaPcaUtil> obtenerDestrezasPcaPorIdMateriaNemonicoNivel(Integer idMateria, String nemonicoNivel) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(DestrezaPca.class);
        ArrayList<DestrezaPca> listaDestrezaPca = new ArrayList();
        List<DestrezaPcaUtil> listaDestrezaPcaUtil = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append("d.id, ");
        sql.append("d.nombre, ");
        sql.append("d.descripcion, ");
        sql.append("d.tipo_destreza as tipo, ");
        sql.append("d.color ");
        sql.append(" FROM destreza_pca d where d.id_materia = ? and d.nemonico_nivel = ? ");
        if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)nemonicoNivel)) {
            nemonicoNivel = NivelEnum.BASICA_PREPARATORIA.getNemonico();
        }
        try {
            listaDestrezaPca = (List)run.query(conn, sql.toString(), (ResultSetHandler)handler, new Object[]{idMateria, nemonicoNivel});
            listaDestrezaPcaUtil = Util.obtenerDestrezaPcaUtil(listaDestrezaPca);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return listaDestrezaPcaUtil;
    }
}

