/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Enumeradores.EstadoEnum;
import Modelos.Dao.DetalleUnidadPcaDao;
import Modelos.Entidades.DestrezaPca;
import Modelos.Entidades.DetalleUnidadPca;
import Modelos.Entidades.UnidadPca;
import Servicios.ConexionSQLite;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class DetalleUnidadPcaDaoImpl
extends ConexionSQLite
implements DetalleUnidadPcaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaSincDetalleUnidadPca(List<DetalleUnidadPca> listaDetalleUnidadPcaDao) {
        if (null != listaDetalleUnidadPcaDao && !listaDetalleUnidadPcaDao.isEmpty()) {
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" INSERT INTO detalle_unidad(");
                sql.append("id, ");
                sql.append("id_unidad_pca, ");
                sql.append("id_detreza_pca, ");
                sql.append("observacion, ");
                sql.append("id_usuario_creacion, ");
                sql.append("fecha_creacion, ");
                sql.append("estado, ");
                sql.append("codigo_error, ");
                sql.append("reg_anio_inicio) ");
                sql.append(" values(?,?,?,?,?,?,?,?,? )");
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql.toString());
                for (DetalleUnidadPca detalleUnidadPca : listaDetalleUnidadPcaDao) {
                    if (null == detalleUnidadPca) continue;
                    PreparedStatement psc = this.getConexion().prepareStatement("SELECT id_aplicacion FROM unidad_pca WHERE id = ? ");
                    psc.setInt(1, detalleUnidadPca.getIdUnidadPca());
                    ResultSet rsc = psc.executeQuery();
                    if (null == rsc) continue;
                    ps.setInt(1, detalleUnidadPca.getId());
                    ps.setInt(2, rsc.getInt("id_aplicacion"));
                    ps.setInt(3, detalleUnidadPca.getIdDestrezaPca());
                    ps.setString(4, detalleUnidadPca.getObservacion());
                    ps.setInt(5, detalleUnidadPca.getIdUsuarioCreacion());
                    ps.setObject(6, (Object)detalleUnidadPca.getFechaCreacion(), 91);
                    ps.setString(7, detalleUnidadPca.getEstado());
                    ps.setObject(8, (Object)detalleUnidadPca.getCodigoError(), 4);
                    ps.setString(9, detalleUnidadPca.getRegAnioInicio());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(DetalleUnidadPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DestrezaPca> obtenerListaDestrezasDetalleUnidadPorIdUnidad(Integer idUnidad) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(DestrezaPca.class);
        List<DestrezaPca> listaDetalleUnidadPca = new ArrayList<DestrezaPca>();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append("d.id, ");
        sql.append("d.nombre, ");
        sql.append("d.descripcion, ");
        sql.append("d.tipo_destreza as tipo, ");
        sql.append("d.color ");
        sql.append("FROM destreza_pca d ");
        sql.append("join detalle_unidad du on du.id_detreza_pca = d.id ");
        sql.append("where du.id_unidad_pca = ? ");
        sql.append(" and du.estado = ? ");
        try {
            listaDetalleUnidadPca = (List)run.query(conn, sql.toString(), (ResultSetHandler)handler, new Object[]{idUnidad, EstadoEnum.ESTADO_ACTIVO.getEstado()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return listaDetalleUnidadPca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DetalleUnidadPca> obtenerListaDetalleUnidadEnviar(List<UnidadPca> listaUnidadesRecibidas) {
        CharSequence[] ids = new String[listaUnidadesRecibidas.size()];
        for (int i = 0; i < listaUnidadesRecibidas.size(); ++i) {
            ids[i] = listaUnidadesRecibidas.get(i).getIdAplicacion().toString();
        }
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(DetalleUnidadPca.class);
        List<DetalleUnidadPca> listaDetalleUnidadPca = new ArrayList<DetalleUnidadPca>();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append("du.id_aplicacion as idAplicacion, ");
        sql.append("u.id as idUnidadPca, ");
        sql.append("du.id_detreza_pca as idDestrezaPca, ");
        sql.append("du.id_usuario_creacion as idUsuarioCreacion, ");
        sql.append("du.estado, ");
        sql.append("du.id, ");
        sql.append("du.reg_anio_inicio as regAnioInicio ");
        sql.append("from detalle_unidad du ");
        sql.append("join unidad_pca u on u.id_aplicacion = du.id_unidad_pca ");
        sql.append("where du.id_unidad_pca in ( ");
        sql.append(String.join((CharSequence)",", ids));
        sql.append(") and (du.estado = ? or (du.id is not null and du.estado = ? ))");
        try {
            listaDetalleUnidadPca = (List)run.query(conn, sql.toString(), (ResultSetHandler)handler, new Object[]{EstadoEnum.ESTADO_ACTIVO.getEstado(), EstadoEnum.ESTADO_INACTIVO.getEstado()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return listaDetalleUnidadPca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarDetalleUnidadSinc(List<DetalleUnidadPca> listaDetalleUnidad) {
        if (null != listaDetalleUnidad && !listaDetalleUnidad.isEmpty()) {
            try {
                String sql = " update detalle_unidad set id = ?, codigo_error = ? where id_aplicacion = ? ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (DetalleUnidadPca unidad : listaDetalleUnidad) {
                    if (null == unidad) continue;
                    ps.setObject(1, (Object)unidad.getId(), 4);
                    ps.setInt(2, unidad.getCodigoError());
                    ps.setInt(3, unidad.getIdAplicacion());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(DetalleUnidadPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }
}

