/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Enumeradores.NivelEnum;
import Modelos.Dao.InstructorDao;
import Modelos.Entidades.Instructor;
import Servicios.ConexionSQLite;
import Util.Grado;
import Util.MsgLog;
import Util.Paralelo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class InstructorDaoImpl
extends ConexionSQLite
implements InstructorDao {
    @Override
    public Integer obtenerIdUsuario() throws Exception {
        Integer idUsuario = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT i.id_usuario FROM instructor i limit 1 ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                idUsuario = rs.getInt("id_usuario");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return idUsuario;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaInstructor(List<Instructor> listaInstructor) throws Exception {
        if (null != listaInstructor && !listaInstructor.isEmpty()) {
            try {
                String sql = " INSERT INTO instructor(id, id_docente, nombre_apellido_docente, identificacion_docente, id_periodo, nombre_periodo, id_institucion, nombre_institucion, id_curso, nombre_curso, id_paralelo, nombre_paralelo, id_materia, nombre_materia, tutor, id_tipo_nivel, nem_tipo_nivel, id_regimen, regimen, id_anio_lectivo, anio_lectivo_inicio, anio_lectivo_fin, id_reg_anio_lectivo, id_usuario, id_grado, nemonico_materia, id_tipo_cultura, id_esquema, nombre_jornada , nombre_especialidad, id_escenario, id_escenario_discrecion)  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (Instructor instructor : listaInstructor) {
                    if (null == instructor) continue;
                    ps.setInt(1, instructor.getId());
                    ps.setInt(2, instructor.getIdDocente());
                    ps.setString(3, instructor.getNombreApellidoDocente());
                    ps.setString(4, instructor.getIdentificacionDocente());
                    ps.setObject(5, (Object)instructor.getIdPeriodo(), 4);
                    ps.setString(6, instructor.getNombrePeriodo());
                    ps.setObject(7, (Object)instructor.getIdInstitucion(), 4);
                    ps.setString(8, instructor.getNombreInstitucion());
                    ps.setObject(9, (Object)instructor.getIdCurso(), 4);
                    ps.setString(10, instructor.getNombreCurso());
                    ps.setObject(11, (Object)instructor.getIdParalelo(), 4);
                    ps.setString(12, instructor.getNombreParalelo());
                    ps.setObject(13, (Object)instructor.getIdMateria(), 4);
                    ps.setString(14, instructor.getNombreMateria());
                    ps.setString(15, instructor.getTutor());
                    ps.setObject(16, (Object)instructor.getIdTipoNivel(), 4);
                    ps.setString(17, instructor.getNemTipoNivel());
                    ps.setObject(18, (Object)instructor.getIdRegimen(), 4);
                    ps.setString(19, instructor.getRegimen());
                    ps.setObject(20, (Object)instructor.getIdAnioLectivo(), 4);
                    ps.setString(21, instructor.getAnioLectivoInicio());
                    ps.setString(22, instructor.getAnioLectivoFin());
                    ps.setObject(23, (Object)instructor.getIdRegistroAnioLectivo(), 4);
                    ps.setObject(24, (Object)instructor.getIdUsuario(), 4);
                    ps.setObject(25, (Object)instructor.getIdGrado(), 4);
                    ps.setString(26, instructor.getNemonicoMateria());
                    ps.setObject(27, (Object)instructor.getIdTipoCultura(), 4);
                    ps.setObject(28, (Object)instructor.getIdEsquema(), 4);
                    ps.setString(29, instructor.getJornada());
                    ps.setString(30, instructor.getEspecialidad() == null ? "" : instructor.getEspecialidad());
                    ps.setObject(31, (Object)instructor.getIdEscenario(), 4);
                    ps.setObject(32, (Object)instructor.getIdEscenarioDiscrecion(), 4);
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    @Override
    public List<Instructor> BuscarPorIdentificacion(String identificacion) throws Exception {
        ArrayList<Instructor> listaInstructores = new ArrayList<Instructor>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT * ");
            query.append(" FROM instructor i ");
            query.append(" WHERE i.identificacion_docente = ? order by i.id_curso, i.id_paralelo asc ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setString(1, identificacion);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Instructor instructor = new Instructor();
                instructor.setId(rs.getInt("id"));
                instructor.setIdCurso(rs.getInt("id_curso"));
                instructor.setIdDocente(rs.getInt("id_docente"));
                instructor.setIdInstitucion(rs.getInt("id_institucion"));
                instructor.setIdMateria(rs.getInt("id_materia"));
                instructor.setIdParalelo(rs.getInt("id_paralelo"));
                instructor.setIdPeriodo(rs.getInt("id_periodo"));
                instructor.setIdentificacionDocente(identificacion);
                instructor.setNombreApellidoDocente(rs.getString("nombre_apellido_docente"));
                instructor.setNombreCurso(rs.getString("nombre_curso"));
                instructor.setNombreInstitucion(rs.getString("nombre_institucion"));
                instructor.setNombreMateria(rs.getString("nombre_materia"));
                instructor.setNombreParalelo(rs.getString("nombre_paralelo"));
                instructor.setNombrePeriodo(rs.getString("nombre_periodo"));
                instructor.setTutor(rs.getString("tutor"));
                instructor.setIdTipoNivel(rs.getInt("id_tipo_nivel"));
                instructor.setNemTipoNivel(rs.getString("nem_tipo_nivel"));
                instructor.setIdRegimen(rs.getInt("id_regimen"));
                instructor.setRegimen(rs.getString("regimen"));
                instructor.setIdAnioLectivo(rs.getInt("id_anio_lectivo"));
                instructor.setAnioLectivoInicio(rs.getString("anio_lectivo_inicio"));
                instructor.setAnioLectivoFin(rs.getString("anio_lectivo_fin"));
                instructor.setIdRegistroAnioLectivo(rs.getInt("id_reg_anio_lectivo"));
                instructor.setNemonicoMateria(rs.getString("nemonico_materia"));
                instructor.setIdGrado(rs.getInt("id_grado"));
                instructor.setIdUsuario(rs.getInt("id_usuario"));
                instructor.setIdTipoCultura(rs.getInt("id_tipo_cultura"));
                instructor.setIdEsquema(rs.getInt("id_esquema"));
                instructor.setJornada(rs.getString("nombre_jornada"));
                instructor.setEspecialidad(rs.getString("nombre_especialidad"));
                instructor.setIdEscenario(rs.getInt("id_escenario"));
                instructor.setIdEscenarioDiscrecion(rs.getInt("id_escenario_discrecion"));
                listaInstructores.add(instructor);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return listaInstructores;
    }

    @Override
    public List<Instructor> buscarPorIdentificacionTutores(String identificacion) throws Exception {
        ArrayList<Instructor> listaInstructores = new ArrayList<Instructor>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT distinct i.id_docente, i.nombre_apellido_docente, i.identificacion_docente, i.id_periodo, i.nombre_periodo, i.id_institucion, i.nombre_institucion, i.id_curso, i.nombre_curso, i.id_paralelo, i.nombre_paralelo, i.tutor, i.id_tipo_nivel, i.nem_tipo_nivel, i.id_regimen, i.regimen, i.id_anio_lectivo, i.anio_lectivo_inicio, i.anio_lectivo_fin, i.id_reg_anio_lectivo, id_usuario, i.nombre_jornada, i.nombre_especialidad ");
            query.append(" FROM instructor i ");
            query.append(" WHERE i.identificacion_docente = ? and i.tutor = ? and i.nem_tipo_nivel in (?, ?) order by i.id_curso, i.id_paralelo asc ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setString(1, identificacion);
            ps.setString(2, "1");
            ps.setString(3, NivelEnum.BASICA_ELEMENTAL.getNemonico());
            ps.setString(4, NivelEnum.BASICA_MEDIA.getNemonico());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Instructor instructor = new Instructor();
                instructor.setIdCurso(rs.getInt("id_curso"));
                instructor.setIdDocente(rs.getInt("id_docente"));
                instructor.setIdInstitucion(rs.getInt("id_institucion"));
                instructor.setIdParalelo(rs.getInt("id_paralelo"));
                instructor.setIdPeriodo(rs.getInt("id_periodo"));
                instructor.setIdentificacionDocente(identificacion);
                instructor.setNombreApellidoDocente(rs.getString("nombre_apellido_docente"));
                instructor.setNombreCurso(rs.getString("nombre_curso"));
                instructor.setNombreInstitucion(rs.getString("nombre_institucion"));
                instructor.setNombreParalelo(rs.getString("nombre_paralelo"));
                instructor.setNombrePeriodo(rs.getString("nombre_periodo"));
                instructor.setTutor(rs.getString("tutor"));
                instructor.setIdTipoNivel(rs.getInt("id_tipo_nivel"));
                instructor.setNemTipoNivel(rs.getString("nem_tipo_nivel"));
                instructor.setIdRegimen(rs.getInt("id_regimen"));
                instructor.setRegimen(rs.getString("regimen"));
                instructor.setIdAnioLectivo(rs.getInt("id_anio_lectivo"));
                instructor.setAnioLectivoInicio(rs.getString("anio_lectivo_inicio"));
                instructor.setAnioLectivoFin(rs.getString("anio_lectivo_fin"));
                instructor.setIdRegistroAnioLectivo(rs.getInt("id_reg_anio_lectivo"));
                instructor.setIdUsuario(rs.getInt("id_usuario"));
                instructor.setJornada(rs.getString("nombre_jornada"));
                instructor.setEspecialidad(rs.getString("nombre_especialidad"));
                listaInstructores.add(instructor);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return listaInstructores;
    }

    @Override
    public List<Instructor> buscarPorIdentificacionTipoNivel(String identificacion, List<String> tiposNiveles) throws Exception {
        ArrayList<Instructor> listaInstructores = new ArrayList<Instructor>();
        try {
            StringBuilder query = new StringBuilder();
            String cantidadParametros = "";
            query.append(" SELECT * ");
            query.append(" FROM instructor i ");
            query.append(" WHERE i.identificacion_docente = ? ");
            query.append(" and i.nem_tipo_nivel in ( ");
            for (int i = 0; i < tiposNiveles.size(); ++i) {
                cantidadParametros = cantidadParametros + " ?, ";
            }
            query.append(cantidadParametros);
            query.append(" '') ");
            query.append(" order by i.id_curso, i.id_paralelo asc ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setString(1, identificacion);
            int i = 2;
            for (String tipoNivel : tiposNiveles) {
                ps.setString(i, tipoNivel);
                ++i;
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Instructor instructor = new Instructor();
                instructor.setId(rs.getInt("id"));
                instructor.setIdCurso(rs.getInt("id_curso"));
                instructor.setIdDocente(rs.getInt("id_docente"));
                instructor.setIdInstitucion(rs.getInt("id_institucion"));
                instructor.setIdMateria(rs.getInt("id_materia"));
                instructor.setIdParalelo(rs.getInt("id_paralelo"));
                instructor.setIdPeriodo(rs.getInt("id_periodo"));
                instructor.setIdentificacionDocente(identificacion);
                instructor.setNombreApellidoDocente(rs.getString("nombre_apellido_docente"));
                instructor.setNombreCurso(rs.getString("nombre_curso"));
                instructor.setNombreInstitucion(rs.getString("nombre_institucion"));
                instructor.setNombreMateria(rs.getString("nombre_materia"));
                instructor.setNombreParalelo(rs.getString("nombre_paralelo"));
                instructor.setNombrePeriodo(rs.getString("nombre_periodo"));
                instructor.setTutor(rs.getString("tutor"));
                instructor.setIdTipoNivel(rs.getInt("id_tipo_nivel"));
                instructor.setNemTipoNivel(rs.getString("nem_tipo_nivel"));
                instructor.setIdRegimen(rs.getInt("id_regimen"));
                instructor.setRegimen(rs.getString("regimen"));
                instructor.setIdAnioLectivo(rs.getInt("id_anio_lectivo"));
                instructor.setAnioLectivoInicio(rs.getString("anio_lectivo_inicio"));
                instructor.setAnioLectivoFin(rs.getString("anio_lectivo_fin"));
                instructor.setIdRegistroAnioLectivo(rs.getInt("id_reg_anio_lectivo"));
                instructor.setIdUsuario(rs.getInt("id_usuario"));
                instructor.setIdTipoCultura(rs.getInt("id_tipo_cultura"));
                instructor.setIdEsquema(rs.getInt("id_esquema"));
                instructor.setJornada(rs.getString("nombre_jornada"));
                instructor.setEspecialidad(rs.getString("nombre_especialidad"));
                instructor.setIdEscenario(rs.getInt("id_escenario"));
                instructor.setIdEscenarioDiscrecion(rs.getInt("id_escenario_discrecion"));
                listaInstructores.add(instructor);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return listaInstructores;
    }

    @Override
    public List<Instructor> buscarPorIdentificacionAsistencia(String identificacion, List<String> tiposNiveles) {
        ArrayList<Instructor> asignaturasAsistencia = new ArrayList<Instructor>();
        try {
            asignaturasAsistencia.addAll(this.buscarPorIdentificacionTutores(identificacion));
            asignaturasAsistencia.addAll(this.buscarPorIdentificacionTipoNivel(identificacion, tiposNiveles));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return asignaturasAsistencia;
    }

    @Override
    public List<Instructor> buscarPorIdentificacionTutoresBachillerato(String identificacion) throws Exception {
        ArrayList<Instructor> listaInstructores = new ArrayList<Instructor>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT distinct i.id_docente, i.nombre_apellido_docente, i.identificacion_docente, i.id_periodo, i.nombre_periodo, i.id_institucion, i.nombre_institucion, i.id_curso, i.nombre_curso, i.id_paralelo, i.nombre_paralelo, i.tutor, i.id_tipo_nivel, i.nem_tipo_nivel, i.id_regimen, i.regimen, i.id_anio_lectivo, i.anio_lectivo_inicio, i.anio_lectivo_fin, i.id_reg_anio_lectivo, id_usuario, i.nombre_jornada, i.nombre_especialidad ");
            query.append(" FROM instructor i ");
            query.append(" WHERE i.identificacion_docente = ? and i.tutor = ? and i.nem_tipo_nivel in (?,?,?,?) order by i.id_curso, i.id_paralelo asc ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setString(1, identificacion);
            ps.setString(2, "1");
            ps.setString(3, NivelEnum.TECNICO.getNemonico());
            ps.setString(4, NivelEnum.BASICA_SUPERIOR.getNemonico());
            ps.setString(5, NivelEnum.INTERNACIONAL.getNemonico());
            ps.setString(6, NivelEnum.CIENCIAS.getNemonico());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Instructor instructor = new Instructor();
                instructor.setIdCurso(rs.getInt("id_curso"));
                instructor.setIdDocente(rs.getInt("id_docente"));
                instructor.setIdInstitucion(rs.getInt("id_institucion"));
                instructor.setIdParalelo(rs.getInt("id_paralelo"));
                instructor.setIdPeriodo(rs.getInt("id_periodo"));
                instructor.setIdentificacionDocente(identificacion);
                instructor.setNombreApellidoDocente(rs.getString("nombre_apellido_docente"));
                instructor.setNombreCurso(rs.getString("nombre_curso"));
                instructor.setNombreInstitucion(rs.getString("nombre_institucion"));
                instructor.setNombreParalelo(rs.getString("nombre_paralelo"));
                instructor.setNombrePeriodo(rs.getString("nombre_periodo"));
                instructor.setTutor(rs.getString("tutor"));
                instructor.setIdTipoNivel(rs.getInt("id_tipo_nivel"));
                instructor.setNemTipoNivel(rs.getString("nem_tipo_nivel"));
                instructor.setIdRegimen(rs.getInt("id_regimen"));
                instructor.setRegimen(rs.getString("regimen"));
                instructor.setIdAnioLectivo(rs.getInt("id_anio_lectivo"));
                instructor.setAnioLectivoInicio(rs.getString("anio_lectivo_inicio"));
                instructor.setAnioLectivoFin(rs.getString("anio_lectivo_fin"));
                instructor.setIdRegistroAnioLectivo(rs.getInt("id_reg_anio_lectivo"));
                instructor.setIdUsuario(rs.getInt("id_usuario"));
                instructor.setJornada(rs.getString("nombre_jornada"));
                instructor.setEspecialidad(rs.getString("nombre_especialidad"));
                listaInstructores.add(instructor);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return listaInstructores;
    }

    @Override
    public List<Instructor> buscarTutorTipoNivel(String identificacion, List<String> tiposNiveles) throws Exception {
        ArrayList<Instructor> listaInstructores = new ArrayList<Instructor>();
        try {
            StringBuilder query = new StringBuilder();
            String cantidadParametros = "";
            query.append(" SELECT * ");
            query.append(" FROM instructor i ");
            query.append(" WHERE i.identificacion_docente = ? ");
            query.append(" and i.tutor = 1 ");
            query.append(" and i.nem_tipo_nivel in ( ");
            for (int i = 0; i < tiposNiveles.size(); ++i) {
                cantidadParametros = cantidadParametros + " ?, ";
            }
            query.append(cantidadParametros);
            query.append(" '') ");
            query.append(" order by i.id_curso, i.id_paralelo asc ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setString(1, identificacion);
            int i = 2;
            for (String tipoNivel : tiposNiveles) {
                ps.setString(i, tipoNivel);
                ++i;
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Instructor instructor = new Instructor();
                instructor.setId(rs.getInt("id"));
                instructor.setIdCurso(rs.getInt("id_curso"));
                instructor.setIdDocente(rs.getInt("id_docente"));
                instructor.setIdInstitucion(rs.getInt("id_institucion"));
                instructor.setIdMateria(rs.getInt("id_materia"));
                instructor.setIdParalelo(rs.getInt("id_paralelo"));
                instructor.setIdPeriodo(rs.getInt("id_periodo"));
                instructor.setIdentificacionDocente(identificacion);
                instructor.setNombreApellidoDocente(rs.getString("nombre_apellido_docente"));
                instructor.setNombreCurso(rs.getString("nombre_curso"));
                instructor.setNombreInstitucion(rs.getString("nombre_institucion"));
                instructor.setNombreMateria(rs.getString("nombre_materia"));
                instructor.setNombreParalelo(rs.getString("nombre_paralelo"));
                instructor.setNombrePeriodo(rs.getString("nombre_periodo"));
                instructor.setTutor(rs.getString("tutor"));
                instructor.setIdTipoNivel(rs.getInt("id_tipo_nivel"));
                instructor.setNemTipoNivel(rs.getString("nem_tipo_nivel"));
                instructor.setIdRegimen(rs.getInt("id_regimen"));
                instructor.setRegimen(rs.getString("regimen"));
                instructor.setIdAnioLectivo(rs.getInt("id_anio_lectivo"));
                instructor.setAnioLectivoInicio(rs.getString("anio_lectivo_inicio"));
                instructor.setAnioLectivoFin(rs.getString("anio_lectivo_fin"));
                instructor.setIdRegistroAnioLectivo(rs.getInt("id_reg_anio_lectivo"));
                instructor.setIdTipoCultura(rs.getInt("id_tipo_cultura"));
                instructor.setIdEsquema(rs.getInt("id_esquema"));
                instructor.setJornada(rs.getString("nombre_jornada"));
                instructor.setEspecialidad(rs.getString("nombre_especialidad"));
                instructor.setIdEscenario(rs.getInt("id_escenario"));
                instructor.setIdEscenarioDiscrecion(rs.getInt("id_escenario_discrecion"));
                listaInstructores.add(instructor);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return listaInstructores;
    }

    @Override
    public List<Instructor> buscarTutorGrados(String identificacion, List<String> tiposNiveles) {
        ArrayList<Instructor> asignaturasAsistencia = new ArrayList<Instructor>();
        try {
            asignaturasAsistencia.addAll(this.buscarPorIdentificacionTutores(identificacion));
            asignaturasAsistencia.addAll(this.buscarPorIdentificacionTutoresBachillerato(identificacion));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return asignaturasAsistencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarInstructor(Instructor instructor) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO instructor(id, id_docente, nombre_apellido_docente, identificacion_docente, id_periodo, nombre_periodo, id_institucion, nombre_institucion, id_curso, nombre_curso, id_paralelo, nombre_paralelo, id_materia, nombre_materia, tutor, id_tipo_nivel, nem_tipo_nivel, id_regimen, regimen, id_anio_lectivo, anio_lectivo_inicio, anio_lectivo_fin, id_reg_anio_lectivo, id_usuario, id_grado, nemonico_materia, id_tipo_cultura, id_esquema ,nombre_jornada, nombre_especialidad,id_escenario,id_escenario_discrecion ) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{instructor.getId(), instructor.getIdDocente(), instructor.getNombreApellidoDocente(), instructor.getIdentificacionDocente(), instructor.getIdPeriodo(), instructor.getNombrePeriodo(), instructor.getIdInstitucion(), instructor.getNombreInstitucion(), instructor.getIdCurso(), instructor.getNombreCurso(), instructor.getIdParalelo(), instructor.getNombreParalelo(), instructor.getIdMateria(), instructor.getNombreMateria(), instructor.getTutor(), instructor.getIdTipoNivel(), instructor.getNemTipoNivel(), instructor.getIdRegimen(), instructor.getRegimen(), instructor.getIdAnioLectivo(), instructor.getAnioLectivoInicio(), instructor.getAnioLectivoFin(), instructor.getIdRegistroAnioLectivo(), instructor.getIdUsuario(), instructor.getIdGrado(), instructor.getNemonicoMateria(), instructor.getIdTipoCultura(), instructor.getIdEsquema(), instructor.getJornada(), instructor.getEspecialidad()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public Instructor BuscarTutorCursoPorIdentificacion(String identificacion, Integer curso, Integer paralelo) throws Exception {
        ArrayList<Instructor> listaInstructores = new ArrayList<Instructor>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT * ");
            query.append(" FROM instructor i ");
            query.append(" WHERE i.identificacion_docente = ? and i.id_curso=? and i.tutor=1 and i.id_paralelo=? order by i.id_curso, i.id_paralelo asc ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setString(1, identificacion);
            ps.setInt(2, curso);
            ps.setInt(3, paralelo);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Instructor instructor = new Instructor();
                instructor.setId(rs.getInt("id"));
                instructor.setIdCurso(rs.getInt("id_curso"));
                instructor.setIdDocente(rs.getInt("id_docente"));
                instructor.setIdInstitucion(rs.getInt("id_institucion"));
                instructor.setIdMateria(rs.getInt("id_materia"));
                instructor.setIdParalelo(rs.getInt("id_paralelo"));
                instructor.setIdPeriodo(rs.getInt("id_periodo"));
                instructor.setIdentificacionDocente(identificacion);
                instructor.setNombreApellidoDocente(rs.getString("nombre_apellido_docente"));
                instructor.setNombreCurso(rs.getString("nombre_curso"));
                instructor.setNombreInstitucion(rs.getString("nombre_institucion"));
                instructor.setNombreMateria(rs.getString("nombre_materia"));
                instructor.setNombreParalelo(rs.getString("nombre_paralelo"));
                instructor.setNombrePeriodo(rs.getString("nombre_periodo"));
                instructor.setTutor(rs.getString("tutor"));
                instructor.setIdTipoNivel(rs.getInt("id_tipo_nivel"));
                instructor.setNemTipoNivel(rs.getString("nem_tipo_nivel"));
                instructor.setIdRegimen(rs.getInt("id_regimen"));
                instructor.setRegimen(rs.getString("regimen"));
                instructor.setIdAnioLectivo(rs.getInt("id_anio_lectivo"));
                instructor.setAnioLectivoInicio(rs.getString("anio_lectivo_inicio"));
                instructor.setAnioLectivoFin(rs.getString("anio_lectivo_fin"));
                instructor.setIdRegistroAnioLectivo(rs.getInt("id_reg_anio_lectivo"));
                instructor.setIdUsuario(rs.getInt("id_usuario"));
                instructor.setIdTipoCultura(rs.getInt("id_tipo_cultura"));
                instructor.setIdEsquema(rs.getInt("id_esquema"));
                instructor.setJornada(rs.getString("nombre_jornada"));
                instructor.setEspecialidad(rs.getString("nombre_especialidad"));
                instructor.setIdEscenario(rs.getInt("id_escenario"));
                instructor.setIdEscenarioDiscrecion(rs.getInt("id_escenario_discrecion"));
                listaInstructores.add(instructor);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        if (listaInstructores.size() > 0) {
            return (Instructor)listaInstructores.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Grado> obtenerGradosInstructor(String identificacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(Grado.class);
        List<Grado> notas = new ArrayList<Grado>();
        try {
            notas = (List)run.query(conn, " select DISTINCT(id_curso) as codigo, nombre_curso ||' '|| nombre_especialidad as descripcion,  nem_tipo_nivel as nemonico  from instructor  where identificacion_docente=? and tutor='1'  and nem_tipo_nivel in ('" + NivelEnum.BASICA_ELEMENTAL.getNemonico() + "','" + NivelEnum.BASICA_MEDIA.getNemonico() + "','" + NivelEnum.BASICA_SUPERIOR.getNemonico() + "','" + NivelEnum.TECNICO.getNemonico() + "','" + NivelEnum.CIENCIAS.getNemonico() + "','" + NivelEnum.INTERNACIONAL.getNemonico() + "')  order by id_grado asc ", (ResultSetHandler)handler, new Object[]{identificacion});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return notas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Paralelo> obtenerParalelosInstructor(Integer idCurso, String identificacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(Paralelo.class);
        List<Paralelo> notas = new ArrayList<Paralelo>();
        try {
            notas = (List)run.query(conn, " select DISTINCT(id_paralelo) as codigo,nombre_paralelo as descripcion from instructor  where id_curso=?  and identificacion_docente=? order by nombre_paralelo asc ", (ResultSetHandler)handler, new Object[]{idCurso, identificacion});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return notas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Instructor> buscarPorIdentificacionYExistenciaHorario(String identificacion) {
        ArrayList<Instructor> listaInstructores = new ArrayList<Instructor>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT DISTINCT i.* ");
            query.append(" FROM instructor i, horario h ");
            query.append(" WHERE i.identificacion_docente = ? ");
            query.append(" and h.id_instructor = i.id ");
            query.append(" order by i.id_curso, i.id_paralelo asc ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setString(1, identificacion);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Instructor instructor = new Instructor();
                instructor.setId(rs.getInt("id"));
                instructor.setIdCurso(rs.getInt("id_curso"));
                instructor.setIdDocente(rs.getInt("id_docente"));
                instructor.setIdInstitucion(rs.getInt("id_institucion"));
                instructor.setIdMateria(rs.getInt("id_materia"));
                instructor.setIdParalelo(rs.getInt("id_paralelo"));
                instructor.setIdPeriodo(rs.getInt("id_periodo"));
                instructor.setIdentificacionDocente(identificacion);
                instructor.setNombreApellidoDocente(rs.getString("nombre_apellido_docente"));
                instructor.setNombreCurso(rs.getString("nombre_curso"));
                instructor.setNombreInstitucion(rs.getString("nombre_institucion"));
                instructor.setNombreMateria(rs.getString("nombre_materia"));
                instructor.setNombreParalelo(rs.getString("nombre_paralelo"));
                instructor.setNombrePeriodo(rs.getString("nombre_periodo"));
                instructor.setTutor(rs.getString("tutor"));
                instructor.setIdTipoNivel(rs.getInt("id_tipo_nivel"));
                instructor.setNemTipoNivel(rs.getString("nem_tipo_nivel"));
                instructor.setIdRegimen(rs.getInt("id_regimen"));
                instructor.setRegimen(rs.getString("regimen"));
                instructor.setIdAnioLectivo(rs.getInt("id_anio_lectivo"));
                instructor.setAnioLectivoInicio(rs.getString("anio_lectivo_inicio"));
                instructor.setAnioLectivoFin(rs.getString("anio_lectivo_fin"));
                instructor.setIdRegistroAnioLectivo(rs.getInt("id_reg_anio_lectivo"));
                instructor.setIdUsuario(rs.getInt("id_usuario"));
                instructor.setJornada(rs.getString("nombre_jornada"));
                instructor.setEspecialidad(rs.getString("nombre_especialidad"));
                instructor.setIdEscenario(rs.getInt("id_escenario"));
                instructor.setIdEscenarioDiscrecion(rs.getInt("id_escenario_discrecion"));
                listaInstructores.add(instructor);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrar();
            }
            catch (Exception exception) {}
        }
        return listaInstructores;
    }

    @Override
    public Integer obtenerIdDocente() throws Exception {
        Integer idDocente = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT i.id_docente FROM instructor i limit 1 ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                idDocente = rs.getInt("id_docente");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return idDocente;
    }
}

