/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.NotaDao;
import Modelos.Entidades.Nota;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang.exception.ExceptionUtils;

public class NotaDaoImpl
extends ConexionSQLite
implements NotaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaNota(List<Nota> listaNota) throws Exception {
        if (null != listaNota && !listaNota.isEmpty()) {
            try {
                String sql = " INSERT INTO nota(id, id_calificacion, id_modelo,nombre_modelo,nota1,nota2,nota3,promedio_nota,porcentaje_promedio,nota_examen,porcentaje_examen,promedio_ec,reg_anio_inicio,id_usuario_creacion,fecha_creacion,promedio )  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (Nota nota : listaNota) {
                    if (null == nota) continue;
                    PreparedStatement psc = this.getConexion().prepareStatement("SELECT * FROM calificacion WHERE id =? ");
                    psc.setInt(1, nota.getIdCalificacion());
                    ResultSet rsc = psc.executeQuery();
                    if (null == rsc) continue;
                    rsc.next();
                    ps.setInt(1, nota.getId());
                    ps.setInt(2, rsc.getInt("id_aplicacion"));
                    ps.setObject(3, (Object)nota.getIdModelo(), 4);
                    ps.setString(4, nota.getNombreModelo());
                    ps.setObject(5, (Object)nota.getNota1(), 8);
                    ps.setObject(6, (Object)nota.getNota2(), 8);
                    ps.setObject(7, (Object)nota.getNota3(), 8);
                    ps.setObject(8, (Object)nota.getPromedioNota(), 8);
                    ps.setObject(9, (Object)nota.getPorcentajePromedio(), 8);
                    ps.setObject(10, (Object)nota.getNotaExamen(), 8);
                    ps.setObject(11, (Object)nota.getPorcentajeExamen(), 8);
                    ps.setString(12, nota.getPromedioEc());
                    ps.setString(13, nota.getRegAnioInicio());
                    ps.setInt(14, nota.getIdUsuarioCreacion());
                    ps.setObject(15, (Object)nota.getFechaCreacion(), 91);
                    ps.setObject(16, (Object)nota.getPromedio(), 8);
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    @Override
    public List<Nota> listar() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void registrar(Float nota, String tipo) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Nota obtenerPorCalificacionModelo(Integer idCalificacion, Integer idModelo) throws Exception {
        Nota nota = new Nota();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT r.id_aplicacion as idAplicacion, ");
            query.append(" r.id_modelo as idModelo, ");
            query.append(" r.nombre_modelo as nombreModelo, ");
            query.append(" r.nota1 as nota1, ");
            query.append(" r.nota2 as nota2, ");
            query.append(" r.nota3 as nota3, ");
            query.append(" r.promedio_nota as promedioNota, ");
            query.append(" r.porcentaje_promedio as porcentajePromedio, ");
            query.append(" r.nota_examen as notaExamen, ");
            query.append(" r.porcentaje_examen as porcentajeExamen, ");
            query.append(" r.promedio as promedio, ");
            query.append(" r.promedio_ec as promedioEc, ");
            query.append(" r.id as id ");
            query.append(" FROM nota r ");
            query.append(" WHERE ");
            query.append(" r.id_calificacion = ? and ");
            query.append(" r.id_modelo=? ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idCalificacion);
            ps.setInt(2, idModelo);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                nota = new Nota();
                nota.setIdAplicacion(rs.getInt("idAplicacion"));
                nota.setIdModelo(rs.getInt("idModelo"));
                nota.setNombreModelo(rs.getString("nombreModelo"));
                nota.setNota1(rs.getBigDecimal("nota1"));
                nota.setNota2(rs.getBigDecimal("nota2"));
                nota.setNota3(rs.getBigDecimal("nota3"));
                nota.setPromedioNota(rs.getBigDecimal("promedioNota"));
                nota.setPorcentajePromedio(rs.getBigDecimal("porcentajePromedio"));
                nota.setNotaExamen(rs.getBigDecimal("notaExamen"));
                nota.setPorcentajeExamen(rs.getBigDecimal("porcentajeExamen"));
                nota.setPromedio(rs.getBigDecimal("promedio"));
                nota.setPromedioEc(rs.getString("promedioEc"));
                nota.setId(rs.getInt("id"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return nota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarNota(Nota nota) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO nota(id_calificacion, id_modelo,nombre_modelo,nota1,nota2,nota3,promedio_nota,porcentaje_promedio,nota_examen,porcentaje_examen,promedio_ec,id_usuario_creacion,reg_anio_inicio,promedio )  values(?,?,?,?,?,?,?,?,?,?,?,?,?,? )";
        try {
            run.update(conn, sql, new Object[]{nota.getCalificacion().getIdAplicacion(), nota.getIdModelo(), nota.getNombreModelo(), nota.getNota1(), nota.getNota2(), nota.getNota3(), nota.getPromedioNota(), nota.getPorcentajePromedio(), nota.getNotaExamen(), nota.getPorcentajeExamen(), nota.getPromedioEc(), nota.getIdUsuarioCreacion(), nota.getRegAnioInicio(), nota.getPromedio()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarNota(Nota nota) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE nota set nota1 = ?, nota2 = ?, nota3 = ?, promedio_nota = ?, porcentaje_promedio = ?, nota_examen = ?, porcentaje_examen = ?, promedio = ?, promedio_ec=?, id_usuario_creacion=?, reg_anio_inicio=?, id = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{nota.getNota1(), nota.getNota2(), nota.getNota3(), nota.getPromedioNota(), nota.getPorcentajePromedio(), nota.getNotaExamen(), nota.getPorcentajeExamen(), nota.getPromedio(), nota.getPromedioEc(), nota.getIdUsuarioCreacion(), nota.getRegAnioInicio(), nota.getId(), nota.getIdAplicacion()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public boolean actualizar(String valores, Integer id) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Nota> obtenerPorParalelo(Integer idEscenario, Integer idEscenarioDiscrecion) throws Exception {
        ArrayList<Nota> notas = new ArrayList<Nota>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT r.id_aplicacion as idAplicacion, ");
            query.append(" r.id_modelo as idModelo, ");
            query.append(" r.nombre_modelo as nombreModelo, ");
            query.append(" r.nota1 as nota1, ");
            query.append(" r.nota2 as nota2, ");
            query.append(" r.nota3 as nota3, ");
            query.append(" r.promedio_nota as promedioNota, ");
            query.append(" r.porcentaje_promedio as porcentajePromedio, ");
            query.append(" r.nota_examen as notaExamen, ");
            query.append(" r.porcentaje_examen as porcentajeExamen, ");
            query.append(" r.promedio as promedio, ");
            query.append(" r.promedio_ec as promedioEc, ");
            query.append(" r.id as id, ");
            query.append(" r.reg_anio_inicio as regAnioInicio, ");
            query.append(" r.id_usuario_creacion as idUsuarioCreacion, ");
            query.append(" c.id as idCalificacion ");
            query.append(" FROM nota r ");
            query.append(" join calificacion c on c.id_aplicacion=r.id_calificacion ");
            query.append(" where  c.id_escenario=? ");
            if (idEscenarioDiscrecion == null || idEscenarioDiscrecion == 0) {
                query.append("and c.id_escenario_discrecion is null ");
            } else {
                query.append("and c.id_escenario_discrecion=? ");
            }
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idEscenario);
            if (idEscenarioDiscrecion != null && idEscenarioDiscrecion != 0) {
                ps.setInt(2, idEscenarioDiscrecion);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Nota nota = new Nota();
                nota.setIdAplicacion(rs.getInt("idAplicacion"));
                nota.setIdModelo(rs.getInt("idModelo"));
                nota.setNombreModelo(rs.getString("nombreModelo"));
                nota.setNota1(rs.getBigDecimal("nota1"));
                nota.setNota2(rs.getBigDecimal("nota2"));
                nota.setNota3(rs.getBigDecimal("nota3"));
                nota.setPromedioNota(rs.getBigDecimal("promedioNota"));
                nota.setPorcentajePromedio(rs.getBigDecimal("porcentajePromedio"));
                nota.setNotaExamen(rs.getBigDecimal("notaExamen"));
                nota.setPorcentajeExamen(rs.getBigDecimal("porcentajeExamen"));
                nota.setPromedio(rs.getBigDecimal("promedio"));
                nota.setPromedioEc(rs.getString("promedioEc"));
                nota.setId(rs.getInt("id"));
                nota.setRegAnioInicio(rs.getString("regAnioInicio"));
                nota.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                nota.setIdCalificacion(rs.getInt("idCalificacion"));
                notas.add(nota);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return notas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarNotaSincronizacion(Nota nota) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE nota set id = ?,codigo_error = ? where id_aplicacion =? ";
        try {
            run.update(conn, sql, new Object[]{nota.getId(), nota.getCodigoError(), nota.getIdAplicacion()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public List<Nota> buscarTodo() throws Exception {
        ArrayList<Nota> notas = new ArrayList<Nota>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT r.id_aplicacion as idAplicacion, ");
            query.append(" r.id_modelo as idModelo, ");
            query.append(" r.nombre_modelo as nombreModelo, ");
            query.append(" r.nota1 as nota1, ");
            query.append(" r.nota2 as nota2, ");
            query.append(" r.nota3 as nota3, ");
            query.append(" r.promedio_nota as promedioNota, ");
            query.append(" r.porcentaje_promedio as porcentajePromedio, ");
            query.append(" r.nota_examen as notaExamen, ");
            query.append(" r.porcentaje_examen as porcentajeExamen, ");
            query.append(" r.promedio as promedio, ");
            query.append(" r.promedio_ec as promedioEc, ");
            query.append(" r.id as id, ");
            query.append(" r.reg_anio_inicio as regAnioInicio, ");
            query.append(" r.id_usuario_creacion as idUsuarioCreacion, ");
            query.append(" c.id as idCalificacion ");
            query.append(" FROM nota r ");
            query.append(" join calificacion c on c.id_aplicacion=r.id_calificacion ");
            query.append(" join instructor i on i.id=c.id_instructor ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Nota nota = new Nota();
                nota.setIdAplicacion(rs.getInt("idAplicacion"));
                nota.setIdModelo(rs.getInt("idModelo"));
                nota.setNombreModelo(rs.getString("nombreModelo"));
                nota.setNota1(rs.getBigDecimal("nota1"));
                nota.setNota2(rs.getBigDecimal("nota2"));
                nota.setNota3(rs.getBigDecimal("nota3"));
                nota.setPromedioNota(rs.getBigDecimal("promedioNota"));
                nota.setPorcentajePromedio(rs.getBigDecimal("porcentajePromedio"));
                nota.setNotaExamen(rs.getBigDecimal("notaExamen"));
                nota.setPorcentajeExamen(rs.getBigDecimal("porcentajeExamen"));
                nota.setPromedio(rs.getBigDecimal("promedio"));
                nota.setPromedioEc(rs.getString("promedioEc"));
                nota.setId(rs.getInt("id"));
                nota.setRegAnioInicio(rs.getString("regAnioInicio"));
                nota.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                nota.setIdCalificacion(rs.getInt("idCalificacion"));
                notas.add(nota);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return notas;
    }
}

