/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.OrientacionPcaDao;
import Modelos.Entidades.DetalleUnidadPca;
import Modelos.Entidades.OrientacionDestrezaPca;
import Modelos.Entidades.OrientacionPca;
import Servicios.ConexionSQLite;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class OrientacionPcaDaoImpl
extends ConexionSQLite
implements OrientacionPcaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaOrientacionDestrezaPca(List<OrientacionDestrezaPca> listaOrientacionDestrezaPca) {
        if (null != listaOrientacionDestrezaPca && !listaOrientacionDestrezaPca.isEmpty()) {
            try {
                String sql = " INSERT INTO orientacion_destreza_pca(id, descripcion, id_usuario_creacion, fecha_creacion, estado, reg_anio_inicio, id_destreza_pca, observacion, id_orientacion_pca)  values (?,?,?,?,?,?,?,?,?) ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (OrientacionDestrezaPca orientacion : listaOrientacionDestrezaPca) {
                    if (null == orientacion) continue;
                    ps.setObject(1, (Object)orientacion.getId(), 4);
                    ps.setString(2, orientacion.getDescripcion());
                    ps.setInt(3, orientacion.getIdUsuarioCreacion());
                    ps.setObject(4, (Object)orientacion.getFechaCreacion(), 91);
                    ps.setString(5, orientacion.getEstado());
                    ps.setString(6, orientacion.getRegAnioInicio());
                    ps.setInt(7, orientacion.getIdDestrezaPca());
                    ps.setString(8, orientacion.getObservacion());
                    ps.setInt(9, orientacion.getIdOrientacionPca());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(OrientacionPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaOrienacionPcaSinc(List<OrientacionPca> listaOrientacionPca) {
        if (null != listaOrientacionPca && !listaOrientacionPca.isEmpty()) {
            try {
                String sql = " INSERT INTO orientacion_pca(id, descripcion, id_usuario_creacion, fecha_creacion, estado, reg_anio_inicio, observacion, id_orientacion_destreza, id_detalle_unidad)  values(?,?,?,?,?,?,?,?,?) ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (OrientacionPca orientacion : listaOrientacionPca) {
                    if (null == orientacion) continue;
                    PreparedStatement psc = this.getConexion().prepareStatement("SELECT id_aplicacion FROM detalle_unidad WHERE id = ? ");
                    psc.setInt(1, orientacion.getIdDetalleUnidadPca());
                    ResultSet rsc = psc.executeQuery();
                    if (null == rsc) continue;
                    rsc.next();
                    ps.setObject(1, (Object)orientacion.getId(), 4);
                    ps.setString(2, orientacion.getDescripcion());
                    ps.setInt(3, orientacion.getIdUsuarioCreacion());
                    ps.setObject(4, (Object)orientacion.getFechaCreacion(), 91);
                    ps.setString(5, orientacion.getEstado());
                    ps.setString(6, orientacion.getRegAnioInicio());
                    ps.setString(7, orientacion.getObservacion());
                    ps.setInt(8, orientacion.getIdOrientacionDestrezaPca());
                    ps.setInt(9, rsc.getInt("id_aplicacion"));
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(OrientacionPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaOrienacionPca(List<OrientacionPca> listaOrientacionPca, Integer idUnidad) {
        if (null != listaOrientacionPca && !listaOrientacionPca.isEmpty()) {
            try {
                String sql = " INSERT INTO orientacion_pca(id, descripcion, id_usuario_creacion, fecha_creacion, estado, reg_anio_inicio, id_orientacion_destreza, id_detalle_unidad)  values(?,?,?,datetime('now'),'1',?,?,?) ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                String sqlDelete = " update orientacion_pca set estado = '0', observacion = 'actualizacion de unidad' where id_detalle_unidad in (  select id_aplicacion from detalle_unidad where id_unidad_pca = ? )";
                QueryRunner run = new QueryRunner();
                run.update(this.getConexion(), sqlDelete, (Object)idUnidad);
                for (OrientacionPca orientacion : listaOrientacionPca) {
                    if (null == orientacion) continue;
                    ps.setObject(1, (Object)orientacion.getId(), 4);
                    ps.setString(2, orientacion.getDescripcion());
                    ps.setInt(3, orientacion.getIdUsuarioCreacion());
                    ps.setString(4, orientacion.getRegAnioInicio());
                    ps.setInt(5, orientacion.getIdOrientacionDestrezaPca());
                    ps.setInt(6, orientacion.getIdDetalleUnidadPca());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(OrientacionPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarOrientacionPcaSinc(List<OrientacionPca> listaOrientacionPca) {
        if (null != listaOrientacionPca && !listaOrientacionPca.isEmpty()) {
            try {
                String sql = " update orientacion_pca set id = ?, codigo_error = ?  where id_aplicacion = ? ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (OrientacionPca orientacion : listaOrientacionPca) {
                    if (null == orientacion) continue;
                    ps.setObject(1, (Object)orientacion.getId(), 4);
                    ps.setObject(2, (Object)orientacion.getCodigoError(), 4);
                    ps.setInt(3, orientacion.getIdAplicacion());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(OrientacionPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrientacionDestrezaPca> obtenerListaOrientacionDestrezaPcaPorIdDestreza(List<Integer> idDestreza) {
        CharSequence[] ids = new String[idDestreza.size()];
        for (int i = 0; i < idDestreza.size(); ++i) {
            ids[i] = idDestreza.get(i).toString();
        }
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(OrientacionDestrezaPca.class);
        List<OrientacionDestrezaPca> listaOrientacionDestrezaPca = new ArrayList<OrientacionDestrezaPca>();
        try {
            listaOrientacionDestrezaPca = (List)run.query(conn, " SELECT o.id, o.descripcion, o.id_aplicacion as idAplicacion, o.id_orientacion_pca as idOrientacionPca, o.id_destreza_pca as idDestrezaPca,o.id_usuario_creacion as idUsuarioCreacion  FROM orientacion_destreza_pca o where o.id_destreza_pca in ( " + String.join((CharSequence)",", ids) + " ) ", (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return listaOrientacionDestrezaPca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrientacionPca> obtenerListaOrientacionPcaPorIdDestrezaIdUnidad(Integer idDestreza, Integer idUnidad) {
        List<OrientacionPca> listaOrientacionPca = new ArrayList<OrientacionPca>();
        Connection conn = this.getConnection();
        try {
            QueryRunner run = new QueryRunner();
            BeanListHandler handler = new BeanListHandler(OrientacionPca.class);
            listaOrientacionPca = (List)run.query(conn, " SELECT o.id, o.descripcion, o.id_aplicacion as idAplicacion, o.id_orientacion_destreza as idOrientacionDestrezaPca, o.id_detalle_unidad as idDetalleUnidadPca, o.id_usuario_creacion as idUsuarioCreacion, o.estado  FROM orientacion_pca o  join detalle_unidad du on du.id_aplicacion = o.id_detalle_unidad  where o.estado = '1' and du.id_unidad_pca = ? and du.id_detreza_pca = ? ", (ResultSetHandler)handler, new Object[]{idUnidad, idDestreza});
        }
        catch (Exception e) {
            Logger.getLogger(OrientacionPcaDaoImpl.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException ex) {
                Logger.getLogger(OrientacionPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return listaOrientacionPca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrientacionPca> obtenerListadoOrientacionPcaEnviar(List<DetalleUnidadPca> litaDetalleUnidadRecibida) {
        CharSequence[] ids = new String[litaDetalleUnidadRecibida.size()];
        for (int i = 0; i < litaDetalleUnidadRecibida.size(); ++i) {
            ids[i] = litaDetalleUnidadRecibida.get(i).getIdAplicacion().toString();
        }
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(OrientacionPca.class);
        List<OrientacionPca> listaOrientacionPca = new ArrayList<OrientacionPca>();
        try {
            listaOrientacionPca = (List)run.query(conn, " SELECT o.id, o.descripcion, o.id_aplicacion as idAplicacion, o.id_orientacion_destreza as idOrientacionDestrezaPca, du.id as idDetalleUnidadPca, o.id_usuario_creacion as idUsuarioCreacion, o.estado from orientacion_pca o join detalle_unidad du on du.id_aplicacion = o.id_detalle_unidad where du.id_aplicacion in (" + String.join((CharSequence)",", ids) + ")  and (o.estado='1' or (o.id is not null and o.estado = '0')) ", (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return listaOrientacionPca;
    }
}

