/*
 * Decompiled with CFR 0.152.
 */
package Versionador;

import Servicios.ConexionSQLite;
import Util.FileUtil;
import Util.MsgLog;
import Util.ObtenerPropiedad;
import Util.Util;
import Versionador.IOUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang.exception.ExceptionUtils;

public class UpdateInfo
extends JDialog {
    private JLabel infoPane;
    private JScrollPane scp;
    private JButton ok;
    private JButton cancel;
    private JPanel pan1;
    private JPanel pan2;
    private final boolean existeConexion;

    public UpdateInfo(String info, Frame parent, boolean modal, boolean existeConexion) {
        super(parent, modal);
        this.existeConexion = existeConexion;
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.infoPane.setText("<html><div style=\"padding-left:10px; padding-right:10px; width:290px; text-align: center\"><b>Estimado Docente.<br/><br/>Existe una nueva versi\u00f3n de la aplicaci\u00f3n, por favor pulse en el bot\u00f3n \"Actualizar\", caso contrario no la podr\u00e1 usar.</b></div></htm>");
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        WindowAdapter exitListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (UpdateInfo.this.existeConexion) {
                    int confirm = JOptionPane.showOptionDialog(null, "<html>Estimado docente si no actualiza la aplicaci\u00f3n no podr\u00e1 continuar con su trabajo.<br/>\u00bfEst\u00e1 seguro de cancelar la actualizaci\u00f3n?</html>", "Confirmaci\u00f3n", 0, 3, null, null, null);
                    if (confirm == 0) {
                        System.exit(0);
                    }
                } else {
                    System.exit(0);
                }
            }
        };
        this.setTitle("Nueva actualizaci\u00f3n");
        this.pan1 = new JPanel();
        this.pan1.setLayout(new BorderLayout());
        this.pan2 = new JPanel();
        this.pan2.setLayout(new FlowLayout());
        this.infoPane = new JLabel();
        this.scp = new JScrollPane();
        this.scp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scp.setViewportView(this.infoPane);
        this.ok = new JButton("Actualizar");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateInfo.this.update();
            }
        });
        this.cancel = new JButton("Cancelar");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UpdateInfo.this.existeConexion) {
                    int confirm = JOptionPane.showOptionDialog(null, "<html>Estimado docente si no actualiza la aplicaci\u00f3n no podr\u00e1 continuar con su trabajo.<br/>\u00bfEst\u00e1 seguro de cancelar la actualizaci\u00f3n?</html>", "Confirmaci\u00f3n", 0, 3, null, null, null);
                    if (confirm == 0) {
                        UpdateInfo.this.cerrarAplicacion();
                        System.exit(0);
                    }
                } else {
                    UpdateInfo.this.cerrarAplicacion();
                    System.exit(0);
                }
            }
        });
        if (this.existeConexion) {
            this.pan2.add(this.ok);
        }
        this.pan2.add(this.cancel);
        this.pan1.add((Component)this.pan2, "South");
        this.pan1.add((Component)this.scp, "Center");
        this.add(this.pan1);
        this.setSize(400, 200);
        this.addWindowListener(exitListener);
    }

    private void update() {
        String[] run = new String[]{"java", "-jar", "Update.jar"};
        try {
            Process p = Runtime.getRuntime().exec(run);
            IOUtils.outputProcessStreams(p);
            System.exit(0);
        }
        catch (IOException ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
            JOptionPane.showMessageDialog(null, "Un error a ocurrido mientras se ejecutaba la actualizaci\u00f3n!");
        }
    }

    private void cerrarAplicacion() {
        try {
            ConexionSQLite csq = new ConexionSQLite();
            Connection c = csq.getConnection();
            if (!c.isClosed()) {
                Statement stmt = c.createStatement();
                stmt.executeQuery("SELECT id FROM usuario limit 1;");
                csq.cerrarExterno(c);
                String url = FileUtil.rutaApp() + "/config/" + ObtenerPropiedad.obtenerPropiedad("bdd");
                Util.encriptaArchivoBB(url);
                String urlPlantilla = FileUtil.rutaApp() + "/config/" + ObtenerPropiedad.obtenerPropiedad("plantilla");
                Util.encriptaArchivoBB(urlPlantilla);
            }
        }
        catch (FileNotFoundException | SQLException ex) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }
}

