/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Modelos.Dao.AsistenciaBachilleratoDaoImpl;
import Modelos.Dao.AsistenciaEducacionBasicaDaoImpl;
import Modelos.Dao.PeriodoAnioLectivoDao;
import Modelos.Dao.PeriodoAnioLectivoDaoImpl;
import Modelos.Dao.RegistroAnioLectivoDaoImpl;
import Modelos.Dao.ResgistroAnioLectivoDao;
import Modelos.Entidades.AsistenciaEducacionBasica;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.Mes;
import Modelos.Entidades.PeriodoAnioLectivo;
import Modelos.Entidades.RegistroAnioLectivo;
import Util.DiasSemana;
import Util.Util;
import Vistas.FuncionesAuxiliar;
import Vistas.model.AsistenciaEGBTableJbroModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class VistaAsistencia
extends JPanel {
    private Integer codigoMes;
    private List<Mes> meses;
    private Mes mesSeleccionado;
    private Integer codigoParaleloSeleccionado;
    private List<AsistenciaEducacionBasica> asistencia = new ArrayList<AsistenciaEducacionBasica>();
    private final JComboBox<Mes> comboMeses = new JComboBox();
    private final AsistenciaEducacionBasicaDaoImpl asistenciaEducacionBasicaDaoImpl = new AsistenciaEducacionBasicaDaoImpl();
    private final AsistenciaBachilleratoDaoImpl asistenciaBachilleratoDaoImpl = new AsistenciaBachilleratoDaoImpl();
    private final ResgistroAnioLectivoDao registroAnioLectivoDao = new RegistroAnioLectivoDaoImpl();
    private final PeriodoAnioLectivoDao periodoAnioLectivoDao = new PeriodoAnioLectivoDaoImpl();
    private RegistroAnioLectivo regAniLec;
    private PeriodoAnioLectivo periodoAnioLectivoQ1;
    private PeriodoAnioLectivo periodoAnioLectivoQ2;
    private PeriodoAnioLectivo periodoAnioLectivo;
    private Instructor instructor;
    private Panel panel1;
    private JPanel panelCombo;
    private JPanel panelTablaAsistencia;

    public VistaAsistencia() {
        this.initComponents();
        this.comboMeses.setPreferredSize(new Dimension(150, 25));
        JPanel panelAgrupadoComboLabel = new JPanel();
        JLabel etiquetaMes = new JLabel("*Mes de consulta:");
        panelAgrupadoComboLabel.add(etiquetaMes);
        panelAgrupadoComboLabel.add(this.comboMeses);
        panelAgrupadoComboLabel.setBorder(new EmptyBorder(15, 15, 15, 15));
        panelAgrupadoComboLabel.setBackground(new Color(245, 245, 245));
        this.panelCombo.setLayout(new BorderLayout());
        this.panelCombo.setBackground(new Color(245, 245, 245));
        this.panelCombo.add((Component)panelAgrupadoComboLabel, "Before");
        this.panelTablaAsistencia.setLayout(new BorderLayout());
        JPanel panelInformacion = new JPanel();
        JPanel panelAuxiliar = new JPanel();
        JLabel informacionInicial = new JLabel("Estimado docente, seleccione un mes para cargar la asistencia del paralelo seleccionado. ");
        informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
        panelInformacion.add((Component)informacionInicial, "Center");
        panelInformacion.setBackground(new Color(252, 248, 227));
        panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
        panelAuxiliar.add(panelInformacion);
        panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.panelTablaAsistencia.add((Component)panelAuxiliar, "First");
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCombo, "First");
        this.add((Component)this.panelTablaAsistencia, "Center");
    }

    private void initComponents() {
        this.panel1 = new Panel();
        this.panelTablaAsistencia = new JPanel();
        this.panelCombo = new JPanel();
        this.setPreferredSize(new Dimension(452, 402));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelTablaAsistencia, "Center");
        this.add((Component)this.panelCombo, "First");
    }

    private void cargarMeses(Integer idRegistrAnioLectivo) {
        Mes mesSeleccione = new Mes();
        mesSeleccione.setNombre("Seleccione...");
        this.comboMeses.addItem(mesSeleccione);
        try {
            this.regAniLec = this.registroAnioLectivoDao.buscarPorId(idRegistrAnioLectivo);
            this.periodoAnioLectivoQ1 = this.periodoAnioLectivoDao.buscarPorAniLecModelo(idRegistrAnioLectivo, 2);
            this.periodoAnioLectivoQ2 = this.periodoAnioLectivoDao.buscarPorAniLecModelo(idRegistrAnioLectivo, 3);
            this.periodoAnioLectivo = this.periodoAnioLectivoDao.buscarPorAniLecModelo(idRegistrAnioLectivo, 1);
            SimpleDateFormat formatoFechas = new SimpleDateFormat("yyyy-MM-dd");
            String fechaComparar = "";
            Date fechaActual = new Date();
            Date fechaFinClases = formatoFechas.parse(this.periodoAnioLectivoQ2.getFechaFin());
            fechaComparar = fechaActual.before(fechaFinClases) ? formatoFechas.format(new Date()) : formatoFechas.format(fechaFinClases);
            this.meses = new Util().listaMesesAnioEntreDosFechas(this.periodoAnioLectivoQ1.getFechaInicio(), fechaComparar);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.meses = new ArrayList<Mes>();
        }
        for (Mes mes : this.meses) {
            this.comboMeses.addItem(mes);
        }
        this.comboMeses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VistaAsistencia.this.getMesSeleccionado();
                VistaAsistencia.this.panelTablaAsistencia.updateUI();
                VistaAsistencia.this.updateUI();
            }
        });
    }

    public void iniciarCarga(Integer codigoParalelo, Integer idRegistrAnioLectivo, Instructor instructor) {
        this.codigoParaleloSeleccionado = codigoParalelo;
        this.instructor = instructor;
        if (this.asistenciaBachilleratoDaoImpl.buscarAsistenciaPorParalelo(this.codigoParaleloSeleccionado).isEmpty()) {
            this.panelCombo.removeAll();
            this.panelTablaAsistencia.removeAll();
            JPanel panelInformacion = new JPanel();
            JPanel panelAuxiliar = new JPanel();
            JLabel informacionInicial = new JLabel("El paralelo no presenta estudiantes. Por favor comun\u00edquese con el rector de la instituci\u00f3n a la que pertenece el paralelo.");
            informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
            panelInformacion.add((Component)informacionInicial, "Center");
            panelInformacion.setBackground(new Color(252, 248, 227));
            panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelAuxiliar.add(panelInformacion);
            panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
            this.panelCombo.add((Component)panelAuxiliar, "First");
        } else {
            this.cargarMeses(idRegistrAnioLectivo);
        }
    }

    public void getMesSeleccionado() {
        this.mesSeleccionado = (Mes)this.comboMeses.getSelectedItem();
        this.codigoMes = this.mesSeleccionado.getId();
        List<DiasSemana> diasSemana = Util.getDiasMesConAnio(this.mesSeleccionado.getId(), this.mesSeleccionado.getAnio(), this.periodoAnioLectivoQ1.getFechaInicio(), this.periodoAnioLectivoQ2.getFechaFin());
        try {
            this.asistencia = this.asistenciaEducacionBasicaDaoImpl.inicializarAsistenciaDeParalelo(this.codigoParaleloSeleccionado, this.codigoMes, diasSemana, this.instructor);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.asistencia = new ArrayList<AsistenciaEducacionBasica>();
        }
        this.panelTablaAsistencia.removeAll();
        if (this.asistencia.isEmpty()) {
            JLabel informacion = new JLabel("El paralelo no presenta estudiantes. Por favor comun\u00edquese con el rector de la instituci\u00f3n a la que pertenece el paralelo.");
            this.panelTablaAsistencia.add((Component)informacion, "Center");
        } else {
            this.panelTablaAsistencia.add((Component)new AsistenciaEGBTableJbroModel(this.asistencia, this.mesSeleccionado, diasSemana, this.instructor, this.regAniLec, this.codigoParaleloSeleccionado, this.periodoAnioLectivoQ1.getFechaInicio(), this.periodoAnioLectivoQ2.getFechaFin(), this.periodoAnioLectivo).getScroll(), "Center");
        }
    }

    public List<AsistenciaEducacionBasica> getAsistencia() {
        return this.asistencia;
    }

    public void setAsistencia(List<AsistenciaEducacionBasica> asistencia) {
        this.asistencia = asistencia;
    }
}

