/*
 * Decompiled with CFR 0.152.
 */
package Vistas.model;

import Formatos.FormatoTablaAsistencia;
import Formatos.FormatoTablaFija;
import Modelos.Entidades.AsistenciaEducacionBasica;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.Mes;
import Modelos.Entidades.PeriodoAnioLectivo;
import Modelos.Entidades.RegistroAnioLectivo;
import Util.DiasSemana;
import Vistas.model.JBroTableDataAsistencia;
import java.awt.Component;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.model.ModelFieldGroup;
import org.quinto.swing.table.model.ModelRow;
import org.quinto.swing.table.view.JBroTable;

public class AsistenciaEGBTableJbroModel
extends JFrame {
    int nombreMasLargo;
    JBroTable tablaFija;
    JBroTable tablaNotas;
    JScrollPane scroll;

    public AsistenciaEGBTableJbroModel(List<AsistenciaEducacionBasica> asistenciaEstudiantes, Mes mesSeleccionado, List<DiasSemana> diasSemana, Instructor instructor, RegistroAnioLectivo regAniLec, Integer codigoParalelo, String fechaInicial, String fechaFinal, PeriodoAnioLectivo periodoAnioLectivo) {
        IModelFieldGroup[] cabeceraNombres = new IModelFieldGroup[]{new ModelFieldGroup("estudiantes", "LISTADO").withChild((IModelFieldGroup)new ModelField("nombres", "ESTUDIANTES").withRowspan(2))};
        int numeroDiasClase = periodoAnioLectivo.getDiaAsistencia();
        ModelField[] fieldsNombres = ModelFieldGroup.getBottomFields((IModelFieldGroup[])cabeceraNombres);
        ModelRow[] rowsNombres = new ModelRow[asistenciaEstudiantes.size()];
        for (int i = 0; i < asistenciaEstudiantes.size(); ++i) {
            int inicialNombreMasLargo;
            rowsNombres[i] = new ModelRow(fieldsNombres.length);
            AsistenciaEducacionBasica estudiante = asistenciaEstudiantes.get(i);
            int n = inicialNombreMasLargo = estudiante.getNombresApellidosEstudiante() != null ? estudiante.getNombresApellidosEstudiante().length() : 0;
            if (inicialNombreMasLargo > this.nombreMasLargo) {
                this.nombreMasLargo = inicialNombreMasLargo;
            }
            for (int j = 0; j < fieldsNombres.length; ++j) {
                rowsNombres[i].setValue(j, (Object)estudiante.getNombresApellidosEstudiante());
            }
        }
        ModelData dataNombres = new ModelData(cabeceraNombres);
        dataNombres.setRows(rowsNombres);
        this.tablaFija = new JBroTable(dataNombres){

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                AsistenciaEGBTableJbroModel.this.checkSelection(true);
            }
        };
        this.tablaFija.setDefaultRenderer(Object.class, (TableCellRenderer)new FormatoTablaFija(this.tablaFija, this.nombreMasLargo));
        ModelFieldGroup agrupacionDias = new ModelFieldGroup(mesSeleccionado.getNombre() + "_head", "ASISTENCIA PARA EL MES DE " + mesSeleccionado.getNombre().toUpperCase() + " DE " + mesSeleccionado.getAnio());
        agrupacionDias.withChild((IModelFieldGroup)new ModelField("SET", "<html><div align='center'>INAC</div></html>").withDefaultWidth(Integer.valueOf(38)));
        for (DiasSemana dia : diasSemana) {
            agrupacionDias.withChild((IModelFieldGroup)new ModelField(dia.getDescripcion() + dia.getDiaNumero(), "<html>" + dia.getNemonico() + "<br/>" + dia.getDiaNumero() + "</html>").withDefaultWidth(Integer.valueOf(38)));
        }
        agrupacionDias.withChild((IModelFieldGroup)new ModelField("VC", "<html><div align='center'> %<br/>INASISTENCIA</div></html>").withDefaultWidth(Integer.valueOf(100)));
        IModelFieldGroup[] cabeceraNotas = new IModelFieldGroup[]{agrupacionDias};
        ModelField[] fields = ModelFieldGroup.getBottomFields((IModelFieldGroup[])cabeceraNotas);
        ModelRow[] rowsNotas = new ModelRow[asistenciaEstudiantes.size()];
        ModelData dataNotas = new ModelData(cabeceraNotas);
        dataNotas.setRows(rowsNotas);
        this.tablaNotas = new JBroTableDataAsistencia(dataNotas, asistenciaEstudiantes, diasSemana, instructor, fields, numeroDiasClase, codigoParalelo, mesSeleccionado);
        this.tablaNotas.getTableHeader().setReorderingAllowed(false);
        this.tablaNotas.setDefaultRenderer(Object.class, (TableCellRenderer)new FormatoTablaAsistencia(this.tablaNotas));
        this.tablaFija.setAutoResizeMode(0);
        this.tablaNotas.setAutoResizeMode(0);
        this.tablaFija.setSelectionMode(0);
        this.tablaNotas.setSelectionMode(0);
        this.scroll = new JScrollPane((Component)this.tablaNotas);
        JViewport viewport = new JViewport();
        viewport.setView((Component)this.tablaFija);
        viewport.setPreferredSize(this.tablaFija.getPreferredSize());
        this.scroll.setRowHeaderView(viewport);
        this.scroll.setCorner("UPPER_LEFT_CORNER", (Component)this.tablaFija.getTableHeader());
    }

    private void checkSelection(boolean isFixedTable) {
        int selectedIndex;
        int fixedSelectedIndex = this.tablaFija.getSelectedRow();
        if (fixedSelectedIndex != (selectedIndex = this.tablaNotas.getSelectedRow())) {
            if (isFixedTable) {
                this.tablaNotas.setRowSelectionInterval(fixedSelectedIndex, fixedSelectedIndex);
            } else {
                this.tablaFija.setRowSelectionInterval(selectedIndex, selectedIndex);
            }
        }
    }

    public int getNombreMasLargo() {
        return this.nombreMasLargo;
    }

    public void setNombreMasLargo(int nombreMasLargo) {
        this.nombreMasLargo = nombreMasLargo;
    }

    public JBroTable getTablaFija() {
        return this.tablaFija;
    }

    public void setTablaFija(JBroTable tablaFija) {
        this.tablaFija = tablaFija;
    }

    public JBroTable getTablaNotas() {
        return this.tablaNotas;
    }

    public void setTablaNotas(JBroTable tablaNotas) {
        this.tablaNotas = tablaNotas;
    }

    public JScrollPane getScroll() {
        return this.scroll;
    }

    public void setScroll(JScrollPane scroll) {
        this.scroll = scroll;
    }
}

