/*
 * Decompiled with CFR 0.152.
 */
package Controladores;

import Enumeradores.EstadoEnum;
import Modelos.Dao.DestrezaPcaDao;
import Modelos.Dao.DestrezaPcaDaoImpl;
import Modelos.Dao.PcaDao;
import Modelos.Dao.PcaDaoImpl;
import Modelos.Entidades.Pca;
import Util.Util;
import Vistas.FuncionesAuxiliar;
import Vistas.VistaPcaPlantilla;
import Vistas.VistaPrincipal;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ControladorPCA
implements ActionListener {
    private final PcaDao pcaDao = new PcaDaoImpl();
    private final DestrezaPcaDao destrezaPcaDao = new DestrezaPcaDaoImpl();

    public void cargarPCA(final VistaPrincipal jfrParent) {
        List<Pca> listaPca = this.pcaDao.obtenerListaPca();
        if (null != listaPca && !listaPca.isEmpty()) {
            int size = listaPca.size();
            ImageIcon Img = new ImageIcon(this.getClass().getResource("/Imagenes/NOTAS_BLANCO.PNG"));
            Color color = new Color(0, 140, 205);
            Color colorEdicion = new Color(0, 77, 128);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                final Pca pca = listaPca.get(i);
                JButton jbtMateria = new JButton();
                if (null != pca.getEstado() && EstadoEnum.ESTADO_ACTIVO.getEstado().equals(pca.getEstado())) {
                    jbtMateria.setBackground(color);
                } else {
                    jbtMateria.setBackground(colorEdicion);
                }
                jbtMateria.setIcon(Img);
                sb.setLength(0);
                sb.append("<html><body><center><div style=\"padding:10px;font-weight:bold;\"><div style=\"padding:3px;\">");
                sb.append(pca.getNombreInstitucion());
                sb.append("</div><div style=\"padding:3px;\">");
                sb.append(pca.getNombreMateria());
                sb.append("</div><div style=\"padding:3px;\">");
                sb.append(pca.getNombreCurso());
                sb.append("</div><div style=\"padding:3px;\">");
                sb.append(pca.getNombreJornada());
                sb.append("</div></center></body></html>");
                jbtMateria.setText(sb.toString());
                jbtMateria.setIconTextGap(1);
                jbtMateria.setHorizontalAlignment(4);
                jbtMateria.setVerticalAlignment(0);
                jbtMateria.setHorizontalTextPosition(4);
                jbtMateria.setForeground(Color.WHITE);
                jbtMateria.setFont(new FuncionesAuxiliar().establecerFont(3));
                jbtMateria.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            jfrParent.setCursor(Cursor.getPredefinedCursor(3));
                            if (null == pca.getListaDestrezas()) {
                                pca.setListaDestrezas(ControladorPCA.this.destrezaPcaDao.obtenerDestrezasPcaPorIdMateriaNemonicoNivel(pca.getIdMateria(), pca.getNemonicoNivelEducativo()));
                            }
                            if (null == jfrParent.vistaPcaPlantilla) {
                                jfrParent.vistaPcaPlantilla = new VistaPcaPlantilla();
                            }
                            jfrParent.vistaPcaPlantilla.removeAll();
                            jfrParent.vistaPcaPlantilla.iniciarPcaPlantilla(jfrParent, pca);
                            jfrParent.vistaPcaPlantilla.revalidate();
                            jfrParent.vistaPcaPlantilla.repaint();
                            jfrParent.setIndiceVentana(6);
                            jfrParent.setInstitucion(pca.getNombreInstitucion());
                            jfrParent.setMateria(pca.getNombreMateria());
                            jfrParent.setParalelo(pca.getNombreCurso());
                            jfrParent.setRegimenAnioLectivo(Util.concatena(pca.getRegimen(), " ", pca.getAnioLectivoInicio(), "-", pca.getAnioLectivoFin()));
                            jfrParent.formarTrabajo();
                            jfrParent.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        catch (Exception ex) {
                            Logger.getLogger(ControladorPCA.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
                jfrParent.pnlListaMateria.add(jbtMateria);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

