/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.AsignacionDaoImpl;
import Modelos.Dao.AsistenciaEducacionBasicaDao;
import Modelos.Dao.EstudianteRetiradoDao;
import Modelos.Dao.EstudianteRetiradoDaoImpl;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.AsistenciaEducacionBasica;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.PeriodoInactividad;
import Servicios.ConexionSQLite;
import Util.DiasSemana;
import Util.MsgLog;
import Util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class AsistenciaEducacionBasicaDaoImpl
extends ConexionSQLite
implements AsistenciaEducacionBasicaDao {
    private final AsignacionDaoImpl asignacionDaoImpl = new AsignacionDaoImpl();
    private final EstudianteRetiradoDao estudianteRetiradoDao = new EstudianteRetiradoDaoImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsistenciaEducacionBasica> buscarPorParaleloMes(Integer codigoParalelo, Integer codigoMes) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AsistenciaEducacionBasica.class);
        List<AsistenciaEducacionBasica> asistencia = new ArrayList<AsistenciaEducacionBasica>();
        try {
            asistencia = (List)run.query(conn, "SELECT a.nombre_apellido_estudiante as nombresApellidosEstudiante, aeb.id_aplicacion as idAplicacion, aeb.id, aeb.id_mes as idMes, aeb.id_asignacion as idAsignacion,aeb.dia_1 as dia1,aeb.dia_2 as dia2,aeb.dia_3 as dia3,aeb.dia_4 as dia4,aeb.dia_5 as dia5,aeb.dia_6 as dia6,aeb.dia_7 as dia7,aeb.dia_8 as dia8,aeb.dia_9 as dia9,aeb.dia_10 as dia10,aeb.dia_11 as dia11,aeb.dia_12 as dia12,aeb.dia_13 as dia13,aeb.dia_14 as dia14,aeb.dia_15 as dia15,aeb.dia_16 as dia16,aeb.dia_17 as dia17,aeb.dia_18 as dia18,aeb.dia_19 as dia19,aeb.dia_20 as dia20,aeb.dia_21 as dia21,aeb.dia_22 as dia22,aeb.dia_23 as dia23,aeb.dia_24 as dia24,aeb.dia_25 as dia25,aeb.dia_26 as dia26,aeb.dia_27 as dia27,aeb.dia_28 as dia28,aeb.dia_29 as dia29,aeb.dia_30 as dia30,aeb.dia_31 as dia31, er.retiro as asisteClases, aeb.codigo_error as codigoError, aeb.reg_anio_inicio as regAnioInicio, aeb.id_usuario_creacion as idUsuarioCreacion, a.id_estudiante as idEstudiante  FROM asignacion a, asistencia_educacion_basica aeb  LEFT OUTER JOIN periodo_inactividad er on er.id_asignacion=a.id  WHERE a.id_paralelo = ? and a.id = aeb.id_asignacion and aeb.id_mes = ? order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoParalelo, codigoMes});
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (Exception e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return asistencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsistenciaEducacionBasica> buscarPorParaleloMesAsignacion(Integer codigoParalelo, Integer codigoMes, Integer idAsignacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AsistenciaEducacionBasica.class);
        List<AsistenciaEducacionBasica> asistencia = new ArrayList<AsistenciaEducacionBasica>();
        try {
            asistencia = (List)run.query(conn, "SELECT a.nombre_apellido_estudiante as nombresApellidosEstudiante, aeb.id_aplicacion as idAplicacion, aeb.id, aeb.id_mes as idMes, aeb.id_asignacion as idAsignacion,aeb.dia_1 as dia1,aeb.dia_2 as dia2,aeb.dia_3 as dia3,aeb.dia_4 as dia4,aeb.dia_5 as dia5,aeb.dia_6 as dia6,aeb.dia_7 as dia7,aeb.dia_8 as dia8,aeb.dia_9 as dia9,aeb.dia_10 as dia10,aeb.dia_11 as dia11,aeb.dia_12 as dia12,aeb.dia_13 as dia13,aeb.dia_14 as dia14,aeb.dia_15 as dia15,aeb.dia_16 as dia16,aeb.dia_17 as dia17,aeb.dia_18 as dia18,aeb.dia_19 as dia19,aeb.dia_20 as dia20,aeb.dia_21 as dia21,aeb.dia_22 as dia22,aeb.dia_23 as dia23,aeb.dia_24 as dia24,aeb.dia_25 as dia25,aeb.dia_26 as dia26,aeb.dia_27 as dia27,aeb.dia_28 as dia28,aeb.dia_29 as dia29,aeb.dia_30 as dia30,aeb.dia_31 as dia31, er.retiro as asisteClases, aeb.codigo_error as codigoError, aeb.reg_anio_inicio as regAnioInicio, aeb.id_usuario_creacion as idUsuarioCreacion, a.id_estudiante as idEstudiante  FROM asignacion a, asistencia_educacion_basica aeb  LEFT OUTER JOIN periodo_inactividad er on er.id_asignacion=a.id  WHERE a.id_paralelo = ? and a.id = aeb.id_asignacion and aeb.id_mes = ? and a.id= ? order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoParalelo, codigoMes, idAsignacion});
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return asistencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarAsistencia(AsistenciaEducacionBasica asistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO asistencia_educacion_basica (id, id_mes, id_asignacion,dia_1,dia_2,dia_3,dia_4,dia_5,dia_6,dia_7,dia_8,dia_9,dia_10,dia_11,dia_12,dia_13,dia_14,dia_15,dia_16,dia_17,dia_18,dia_19,dia_20,dia_21,dia_22,dia_23,dia_24,dia_25,dia_26,dia_27,dia_28,dia_29,dia_30,dia_31, reg_anio_inicio, id_usuario_creacion, codigo_error)  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{asistencia.getId(), asistencia.getIdMes(), asistencia.getIdAsignacion(), asistencia.getDia1(), asistencia.getDia2(), asistencia.getDia3(), asistencia.getDia4(), asistencia.getDia5(), asistencia.getDia6(), asistencia.getDia7(), asistencia.getDia8(), asistencia.getDia9(), asistencia.getDia10(), asistencia.getDia11(), asistencia.getDia12(), asistencia.getDia13(), asistencia.getDia14(), asistencia.getDia15(), asistencia.getDia16(), asistencia.getDia17(), asistencia.getDia18(), asistencia.getDia19(), asistencia.getDia20(), asistencia.getDia21(), asistencia.getDia22(), asistencia.getDia23(), asistencia.getDia24(), asistencia.getDia25(), asistencia.getDia26(), asistencia.getDia27(), asistencia.getDia28(), asistencia.getDia29(), asistencia.getDia30(), asistencia.getDia31(), asistencia.getRegAnioInicio(), asistencia.getIdUsuarioCreacion(), asistencia.getCodigoError()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarAsistencia(AsistenciaEducacionBasica asistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE asistencia_educacion_basica set id = ?, id_mes = ?, id_asignacion = ?, dia_1 = ?, dia_2 = ?, dia_3 = ?, dia_4 = ?, dia_5 = ?, dia_6 = ?, dia_7 = ?, dia_8 = ?, dia_9 = ?, dia_10 = ?, dia_11 = ?, dia_12 = ?, dia_13 = ?, dia_14 = ?, dia_15 = ?, dia_16 = ?, dia_17 = ?, dia_18 = ?, dia_19 = ?, dia_20 = ?, dia_21 = ?, dia_22 = ?, dia_23 = ?, dia_24 = ?, dia_25 = ?, dia_26 = ?, dia_27 = ?, dia_28 = ?, dia_29 = ?, dia_30 = ?, dia_31 = ?, reg_anio_inicio = ?, id_usuario_creacion = ?, codigo_error = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{asistencia.getId(), asistencia.getIdMes(), asistencia.getIdAsignacion(), asistencia.getDia1(), asistencia.getDia2(), asistencia.getDia3(), asistencia.getDia4(), asistencia.getDia5(), asistencia.getDia6(), asistencia.getDia7(), asistencia.getDia8(), asistencia.getDia9(), asistencia.getDia10(), asistencia.getDia11(), asistencia.getDia12(), asistencia.getDia13(), asistencia.getDia14(), asistencia.getDia15(), asistencia.getDia16(), asistencia.getDia17(), asistencia.getDia18(), asistencia.getDia19(), asistencia.getDia20(), asistencia.getDia21(), asistencia.getDia22(), asistencia.getDia23(), asistencia.getDia24(), asistencia.getDia25(), asistencia.getDia26(), asistencia.getDia27(), asistencia.getDia28(), asistencia.getDia29(), asistencia.getDia30(), asistencia.getDia31(), asistencia.getRegAnioInicio(), asistencia.getIdUsuarioCreacion(), asistencia.getCodigoError(), asistencia.getIdAplicacion()});
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<AsistenciaEducacionBasica> inicializarAsistenciaDeParalelo(Integer codigoParalelo, Integer codigoMes, List<DiasSemana> diasSemana, Instructor instructor) {
        ArrayList<AsistenciaEducacionBasica> asistenciaParaleloInicial = new ArrayList<AsistenciaEducacionBasica>();
        List<Asignacion> estudiantesParalelo = this.asignacionDaoImpl.buscarPorParalelo(codigoParalelo);
        for (Asignacion estudiante : estudiantesParalelo) {
            AsistenciaEducacionBasica asistenciaGuardada = this.buscarAsistenciaEstudiantePorMesAsignacion(estudiante.getId(), codigoMes);
            if (asistenciaGuardada != null) {
                new Util().validarFechaActualAsistenciaEGB(asistenciaGuardada, diasSemana, codigoMes);
                asistenciaParaleloInicial.add(asistenciaGuardada);
                continue;
            }
            AsistenciaEducacionBasica nuevaAsistencia = new AsistenciaEducacionBasica();
            nuevaAsistencia.setNombresApellidosEstudiante(estudiante.getNombreApellidoEstudiante());
            nuevaAsistencia.setIdAsignacion(estudiante.getId());
            nuevaAsistencia.setIdEstudiante(estudiante.getIdEstudiante());
            nuevaAsistencia.setIdMes(codigoMes);
            PeriodoInactividad retirado = this.estudianteRetiradoDao.buscarPorAsignacion(estudiante.getId(), instructor.getIdParalelo());
            if (retirado != null && !retirado.getRetirado().booleanValue()) {
                Util.setearValoresInicialesRetiroEGB(nuevaAsistencia, diasSemana);
            } else {
                Util.setearValoresInicialesAsistenciaEGB(nuevaAsistencia, diasSemana);
            }
            nuevaAsistencia.setIdUsuarioCreacion(instructor.getIdUsuario());
            nuevaAsistencia.setRegAnioInicio(instructor.getAnioLectivoInicio() + "-" + instructor.getIdRegimen());
            this.guardarAsistencia(nuevaAsistencia);
            asistenciaParaleloInicial.add(this.buscarUltimaAsistenciaIngresada());
        }
        return asistenciaParaleloInicial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsistenciaEducacionBasica buscarAsistenciaEstudiantePorMesAsignacion(Integer codigoAsignacion, Integer codigoMes) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(AsistenciaEducacionBasica.class);
        AsistenciaEducacionBasica asistenciaEstudiante = null;
        try {
            asistenciaEstudiante = (AsistenciaEducacionBasica)run.query(conn, "SELECT a.nombre_apellido_estudiante as nombresApellidosEstudiante, aeb.id_aplicacion as idAplicacion, aeb.id, aeb.id_mes as idMes, aeb.id_asignacion as idAsignacion,aeb.dia_1 as dia1,aeb.dia_2 as dia2,aeb.dia_3 as dia3,aeb.dia_4 as dia4,aeb.dia_5 as dia5,aeb.dia_6 as dia6,aeb.dia_7 as dia7,aeb.dia_8 as dia8,aeb.dia_9 as dia9,aeb.dia_10 as dia10,aeb.dia_11 as dia11,aeb.dia_12 as dia12,aeb.dia_13 as dia13,aeb.dia_14 as dia14,aeb.dia_15 as dia15,aeb.dia_16 as dia16,aeb.dia_17 as dia17,aeb.dia_18 as dia18,aeb.dia_19 as dia19,aeb.dia_20 as dia20,aeb.dia_21 as dia21,aeb.dia_22 as dia22,aeb.dia_23 as dia23,aeb.dia_24 as dia24,aeb.dia_25 as dia25,aeb.dia_26 as dia26,aeb.dia_27 as dia27,aeb.dia_28 as dia28,aeb.dia_29 as dia29,aeb.dia_30 as dia30,aeb.dia_31 as dia31, er.retiro as asisteClases, aeb.reg_anio_inicio as regAnioInicio, aeb.codigo_error as codigoError, aeb.id_usuario_creacion as idUsuarioCreacion, a.id_estudiante as idEstudiante  FROM asignacion a, asistencia_educacion_basica aeb  LEFT OUTER JOIN periodo_inactividad er on er.id_asignacion=a.id  WHERE  aeb.id_asignacion = ?  and aeb.id_mes = ?  and a.id = aeb.id_asignacion  order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoAsignacion, codigoMes});
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (Exception exception) {}
        }
        return asistenciaEstudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsistenciaEducacionBasica buscarUltimaAsistenciaIngresada() {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(AsistenciaEducacionBasica.class);
        AsistenciaEducacionBasica asistenciaEstudiante = null;
        try {
            asistenciaEstudiante = (AsistenciaEducacionBasica)run.query(conn, "SELECT a.nombre_apellido_estudiante as nombresApellidosEstudiante, aeb.id_aplicacion as idAplicacion, aeb.id, aeb.id_mes as idMes, aeb.id_asignacion as idAsignacion,aeb.dia_1 as dia1,aeb.dia_2 as dia2,aeb.dia_3 as dia3,aeb.dia_4 as dia4,aeb.dia_5 as dia5,aeb.dia_6 as dia6,aeb.dia_7 as dia7,aeb.dia_8 as dia8,aeb.dia_9 as dia9,aeb.dia_10 as dia10,aeb.dia_11 as dia11,aeb.dia_12 as dia12,aeb.dia_13 as dia13,aeb.dia_14 as dia14,aeb.dia_15 as dia15,aeb.dia_16 as dia16,aeb.dia_17 as dia17,aeb.dia_18 as dia18,aeb.dia_19 as dia19,aeb.dia_20 as dia20,aeb.dia_21 as dia21,aeb.dia_22 as dia22,aeb.dia_23 as dia23,aeb.dia_24 as dia24,aeb.dia_25 as dia25,aeb.dia_26 as dia26,aeb.dia_27 as dia27,aeb.dia_28 as dia28,aeb.dia_29 as dia29,aeb.dia_30 as dia30,aeb.dia_31 as dia31, er.retiro as asisteClases, aeb.reg_anio_inicio as regAnioInicio, aeb.id_usuario_creacion as idUsuarioCreacion, aeb.codigo_error as codigoError, a.id_estudiante as idEstudiante  FROM asignacion a, asistencia_educacion_basica aeb  LEFT OUTER JOIN periodo_inactividad er on er.id_asignacion=a.id  WHERE  aeb.id_aplicacion = (SELECT max(id_aplicacion) from asistencia_educacion_basica)  and a.id = aeb.id_asignacion  order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler);
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistenciaEstudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarAsistenciaSincronizacion(AsistenciaEducacionBasica asistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE asistencia_educacion_basica set id= ?, codigo_error = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{asistencia.getId(), asistencia.getCodigoError(), asistencia.getIdAplicacion()});
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsistenciaEducacionBasica> buscarTodo() {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AsistenciaEducacionBasica.class);
        ArrayList<AsistenciaEducacionBasica> asistencia = new ArrayList();
        try {
            asistencia = (List)run.query(conn, "SELECT a.nombre_apellido_estudiante as nombresApellidosEstudiante, aeb.id_aplicacion as idAplicacion, aeb.id, aeb.id_mes as idMes, aeb.id_asignacion as idAsignacion,aeb.dia_1 as dia1,aeb.dia_2 as dia2,aeb.dia_3 as dia3,aeb.dia_4 as dia4,aeb.dia_5 as dia5,aeb.dia_6 as dia6,aeb.dia_7 as dia7,aeb.dia_8 as dia8,aeb.dia_9 as dia9,aeb.dia_10 as dia10,aeb.dia_11 as dia11,aeb.dia_12 as dia12,aeb.dia_13 as dia13,aeb.dia_14 as dia14,aeb.dia_15 as dia15,aeb.dia_16 as dia16,aeb.dia_17 as dia17,aeb.dia_18 as dia18,aeb.dia_19 as dia19,aeb.dia_20 as dia20,aeb.dia_21 as dia21,aeb.dia_22 as dia22,aeb.dia_23 as dia23,aeb.dia_24 as dia24,aeb.dia_25 as dia25,aeb.dia_26 as dia26,aeb.dia_27 as dia27,aeb.dia_28 as dia28,aeb.dia_29 as dia29,aeb.dia_30 as dia30,aeb.dia_31 as dia31, er.retiro as asisteClases, aeb.reg_anio_inicio as regAnioInicio, aeb.codigo_error as codigoError, aeb.id_usuario_creacion as idUsuarioCreacion, a.id_estudiante as idEstudiante  FROM asignacion a, asistencia_educacion_basica aeb  LEFT OUTER JOIN periodo_inactividad er on er.id_asignacion=a.id  WHERE  a.id = aeb.id_asignacion  order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler);
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaAsistencia(List<AsistenciaEducacionBasica> listaAsistencia) throws Exception {
        if (null != listaAsistencia && !listaAsistencia.isEmpty()) {
            try {
                String sql = " INSERT INTO asistencia_educacion_basica (id, id_mes, id_asignacion,dia_1,dia_2,dia_3,dia_4,dia_5,dia_6,dia_7,dia_8,dia_9,dia_10,dia_11,dia_12,dia_13,dia_14,dia_15,dia_16,dia_17,dia_18,dia_19,dia_20,dia_21,dia_22,dia_23,dia_24,dia_25,dia_26,dia_27,dia_28,dia_29,dia_30,dia_31, reg_anio_inicio, id_usuario_creacion)  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                this.Conectar();
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (AsistenciaEducacionBasica asistencia : listaAsistencia) {
                    if (null == asistencia) continue;
                    ps.setInt(1, asistencia.getId());
                    ps.setInt(2, asistencia.getIdMes());
                    ps.setInt(3, asistencia.getIdAsignacion());
                    if (asistencia.getDia1() != null) {
                        ps.setBoolean(4, asistencia.getDia1());
                    } else {
                        ps.setObject(4, null);
                    }
                    if (asistencia.getDia2() != null) {
                        ps.setBoolean(5, asistencia.getDia2());
                    } else {
                        ps.setObject(5, null);
                    }
                    if (asistencia.getDia3() != null) {
                        ps.setBoolean(6, asistencia.getDia3());
                    } else {
                        ps.setObject(6, null);
                    }
                    if (asistencia.getDia4() != null) {
                        ps.setBoolean(7, asistencia.getDia4());
                    } else {
                        ps.setObject(7, null);
                    }
                    if (asistencia.getDia5() != null) {
                        ps.setBoolean(8, asistencia.getDia5());
                    } else {
                        ps.setObject(8, null);
                    }
                    if (asistencia.getDia6() != null) {
                        ps.setBoolean(9, asistencia.getDia6());
                    } else {
                        ps.setObject(9, null);
                    }
                    if (asistencia.getDia7() != null) {
                        ps.setBoolean(10, asistencia.getDia7());
                    } else {
                        ps.setObject(10, null);
                    }
                    if (asistencia.getDia8() != null) {
                        ps.setBoolean(11, asistencia.getDia8());
                    } else {
                        ps.setObject(11, null);
                    }
                    if (asistencia.getDia9() != null) {
                        ps.setBoolean(12, asistencia.getDia9());
                    } else {
                        ps.setObject(12, null);
                    }
                    if (asistencia.getDia10() != null) {
                        ps.setBoolean(13, asistencia.getDia10());
                    } else {
                        ps.setObject(13, null);
                    }
                    if (asistencia.getDia11() != null) {
                        ps.setBoolean(14, asistencia.getDia11());
                    } else {
                        ps.setObject(14, null);
                    }
                    if (asistencia.getDia12() != null) {
                        ps.setBoolean(15, asistencia.getDia12());
                    } else {
                        ps.setObject(15, null);
                    }
                    if (asistencia.getDia13() != null) {
                        ps.setBoolean(16, asistencia.getDia13());
                    } else {
                        ps.setObject(16, null);
                    }
                    if (asistencia.getDia14() != null) {
                        ps.setBoolean(17, asistencia.getDia14());
                    } else {
                        ps.setObject(17, null);
                    }
                    if (asistencia.getDia15() != null) {
                        ps.setBoolean(18, asistencia.getDia15());
                    } else {
                        ps.setObject(18, null);
                    }
                    if (asistencia.getDia16() != null) {
                        ps.setBoolean(19, asistencia.getDia16());
                    } else {
                        ps.setObject(19, null);
                    }
                    if (asistencia.getDia17() != null) {
                        ps.setBoolean(20, asistencia.getDia17());
                    } else {
                        ps.setObject(20, null);
                    }
                    if (asistencia.getDia18() != null) {
                        ps.setBoolean(21, asistencia.getDia18());
                    } else {
                        ps.setObject(21, null);
                    }
                    if (asistencia.getDia19() != null) {
                        ps.setBoolean(22, asistencia.getDia19());
                    } else {
                        ps.setObject(22, null);
                    }
                    if (asistencia.getDia20() != null) {
                        ps.setBoolean(23, asistencia.getDia20());
                    } else {
                        ps.setObject(23, null);
                    }
                    if (asistencia.getDia21() != null) {
                        ps.setBoolean(24, asistencia.getDia21());
                    } else {
                        ps.setObject(24, null);
                    }
                    if (asistencia.getDia22() != null) {
                        ps.setBoolean(25, asistencia.getDia22());
                    } else {
                        ps.setObject(25, null);
                    }
                    if (asistencia.getDia23() != null) {
                        ps.setBoolean(26, asistencia.getDia23());
                    } else {
                        ps.setObject(26, null);
                    }
                    if (asistencia.getDia24() != null) {
                        ps.setBoolean(27, asistencia.getDia24());
                    } else {
                        ps.setObject(27, null);
                    }
                    if (asistencia.getDia25() != null) {
                        ps.setBoolean(28, asistencia.getDia25());
                    } else {
                        ps.setObject(28, null);
                    }
                    if (asistencia.getDia26() != null) {
                        ps.setBoolean(29, asistencia.getDia26());
                    } else {
                        ps.setObject(29, null);
                    }
                    if (asistencia.getDia27() != null) {
                        ps.setBoolean(30, asistencia.getDia27());
                    } else {
                        ps.setObject(30, null);
                    }
                    if (asistencia.getDia28() != null) {
                        ps.setBoolean(31, asistencia.getDia28());
                    } else {
                        ps.setObject(31, null);
                    }
                    if (asistencia.getDia29() != null) {
                        ps.setBoolean(32, asistencia.getDia29());
                    } else {
                        ps.setObject(32, null);
                    }
                    if (asistencia.getDia30() != null) {
                        ps.setBoolean(33, asistencia.getDia30());
                    } else {
                        ps.setObject(33, null);
                    }
                    if (asistencia.getDia31() != null) {
                        ps.setBoolean(34, asistencia.getDia31());
                    } else {
                        ps.setObject(34, null);
                    }
                    ps.setString(35, asistencia.getRegAnioInicio());
                    ps.setInt(36, asistencia.getIdUsuarioCreacion());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (Exception e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsistenciaEducacionBasica> buscarInasistenciaEGBPorParaleloAsignacion(Integer codigoParalelo, Integer codigoEstudiante) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AsistenciaEducacionBasica.class);
        List<AsistenciaEducacionBasica> asistencia = new ArrayList<AsistenciaEducacionBasica>();
        try {
            asistencia = (List)run.query(conn, "SELECT a.nombre_apellido_estudiante as nombresApellidosEstudiante, e.id_aplicacion as idAplicacion, e.id, e.id_mes as idMes, e.id_asignacion as idAsignacion,e.dia_1 as dia1,e.dia_2 as dia2,e.dia_3 as dia3,e.dia_4 as dia4,e.dia_5 as dia5,e.dia_6 as dia6,e.dia_7 as dia7,e.dia_8 as dia8,e.dia_9 as dia9,e.dia_10 as dia10,e.dia_11 as dia11,e.dia_12 as dia12,e.dia_13 as dia13,e.dia_14 as dia14,e.dia_15 as dia15,e.dia_16 as dia16,e.dia_17 as dia17,e.dia_18 as dia18,e.dia_19 as dia19,e.dia_20 as dia20,e.dia_21 as dia21,e.dia_22 as dia22,e.dia_23 as dia23,e.dia_24 as dia24,e.dia_25 as dia25,e.dia_26 as dia26,e.dia_27 as dia27,e.dia_28 as dia28,e.dia_29 as dia29,e.dia_30 as dia30,e.dia_31 as dia31, a.id as idEstudiante FROM asignacion a INNER JOIN asistencia_educacion_basica e on a.id=e.id_asignacion where (e.dia_1=0 OR e.dia_2=0 or e.dia_3=0 or e.dia_4=0 or e.dia_5=0 or e.dia_6=0 or e.dia_7=0 or e.dia_8=0 or e.dia_9=0 or e.dia_10=0 or e.dia_11=0 or e.dia_12=0 or e.dia_13=0 or e.dia_14=0 or e.dia_15=0 or e.dia_16=0 or e.dia_17=0 or e.dia_18=0 or e.dia_19=0 or e.dia_21=0 or e.dia_22=0 or e.dia_23=0 or e.dia_24=0 or e.dia_25=0 or e.dia_26=0 or e.dia_27=0 or e.dia_28=0 or e.dia_29=0 or e.dia_30=0 or e.dia_31=0) and a.id_paralelo = ? and a.id_estudiante = ? order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoParalelo, codigoEstudiante});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistencia;
    }
}

