/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.NotaInicialDao;
import Modelos.Entidades.NotaInicial;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class NotaInicialDaoImpl
extends ConexionSQLite
implements NotaInicialDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaNota(List<NotaInicial> listaNota) throws Exception {
        if (null != listaNota && !listaNota.isEmpty()) {
            try {
                String sql = " INSERT INTO nota_inicial(id, id_destreza, id_asignacion,nota1,nota2,id_usuario_creacion,reg_anio_inicio )  values(?,?,?,?,?,?,?)";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (NotaInicial nota : listaNota) {
                    if (null == nota) continue;
                    ps.setInt(1, nota.getId());
                    ps.setInt(2, nota.getIdDestreza());
                    ps.setInt(3, nota.getIdAsignacion());
                    ps.setString(4, (String)(nota.getNota1() != null ? (nota.getNota1().trim().equals("") ? null : nota.getNota1().trim()) : nota.getNota1()));
                    ps.setString(5, (String)(nota.getNota2() != null ? (nota.getNota2().trim().equals("") ? null : nota.getNota2().trim()) : nota.getNota2()));
                    ps.setInt(6, nota.getIdUsuarioCreacion());
                    ps.setString(7, nota.getRegAnioInicio());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    @Override
    public List<NotaInicial> listar() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void registrar(Float nota, String tipo) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotaInicial obtenerPorDestrezaAsignacion(Integer idDesteza, Integer idAsignacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(NotaInicial.class);
        NotaInicial nota = null;
        try {
            nota = (NotaInicial)run.query(conn, " SELECT  r.id_aplicacion as idAplicacion,  r.id_destreza as idDestreza,  r.id_asignacion as idAsignacion,  r.nota1 as nota1, r.nota2 as nota2,  r.id as id, r.codigo_error as codigoError,  r.id_usuario_creacion as idUsuarioCreacion,  r.reg_anio_inicio as regAnioInicio  FROM nota_inicial r  WHERE  r.id_destreza = ? and  r.id_asignacion=? ", (ResultSetHandler)handler, new Object[]{idDesteza, idAsignacion});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return nota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NotaInicial> obtenerPorParalelo(Integer idParalelo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(NotaInicial.class);
        List<NotaInicial> notas = new ArrayList<NotaInicial>();
        try {
            notas = (List)run.query(conn, " SELECT  r.id_aplicacion as idAplicacion,  r.id_destreza as idDestreza,  r.nota1 as nota1, r.nota2 as nota2,  a.id as idAsignacion,  r.id as id, r.codigo_error as codigoError,  r.id_usuario_creacion as idUsuarioCreacion,  r.reg_anio_inicio as regAnioInicio  FROM nota_inicial r  inner join asignacion a on a.id=r.id_asignacion and a.id_paralelo=? ", (ResultSetHandler)handler, new Object[]{idParalelo});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return notas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarNota(NotaInicial nota) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO nota_inicial(id_destreza, id_asignacion,nota1,nota2,id_usuario_creacion,reg_anio_inicio )  values(?,?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{nota.getIdDestreza(), nota.getIdAsignacion(), nota.getNota1(), nota.getNota2(), nota.getIdUsuarioCreacion(), nota.getRegAnioInicio()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarNota(NotaInicial nota) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE nota_inicial set nota1 = ?, nota2 = ?,id_usuario_creacion = ?,id = ? where id_aplicacion =? ";
        try {
            run.update(conn, sql, new Object[]{nota.getNota1(), nota.getNota2(), nota.getIdUsuarioCreacion(), nota.getId(), nota.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarNotaSincronizacion(NotaInicial nota) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE nota_inicial set id = ?,codigo_error = ? where id_aplicacion =? ";
        try {
            run.update(conn, sql, new Object[]{nota.getId(), nota.getCodigoError(), nota.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public boolean actualizar(String valores, Integer id) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NotaInicial> buscarTodo() {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(NotaInicial.class);
        ArrayList<NotaInicial> nota = new ArrayList();
        try {
            nota = (List)run.query(conn, " SELECT  r.id_aplicacion as idAplicacion,  r.id_destreza as idDestreza,  r.nota1 as nota1, r.nota2 as nota2,  a.id as idAsignacion,  r.id as id, r.codigo_error as codigoError,  r.id_usuario_creacion as idUsuarioCreacion,  r.reg_anio_inicio as regAnioInicio  FROM nota_inicial r  inner join asignacion a on a.id=r.id_asignacion ", (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return nota;
    }
}

