/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.RecomendacionDao;
import Modelos.Entidades.Recomendacion;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class RecomendacionDaoImpl
extends ConexionSQLite
implements RecomendacionDao {
    @Override
    public List<Recomendacion> listar() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void registrar(String nota, String tipo) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Recomendacion obtenerPorCalificacionModelo(Integer idCalificacion, Integer idModelo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(Recomendacion.class);
        Recomendacion nota = null;
        try {
            nota = (Recomendacion)run.query(conn, " SELECT  r.id_aplicacion as idAplicacion,  r.id_modelo as idModelo,  r.nombre_modelo as nombreModelo, r.recomendacion1 as recomendacion1, r.recomendacion2 as recomendacion2,  r.recomendacion3 as recomendacion3, r.recomendacion_quimestre as recomendacionQuimestre,  r.tipo_novedad as tipoNovedad, r.id as id FROM recomendacion r  WHERE  r.id_calificacion = ? and  r.id_modelo=? ", (ResultSetHandler)handler, new Object[]{idCalificacion, idModelo});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return nota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarRecomendacion(Recomendacion recomendacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO recomendacion(id_calificacion, id_modelo,nombre_modelo,recomendacion1,recomendacion2,recomendacion3,recomendacion_quimestre, id_usuario_creacion, tipo_novedad, reg_anio_inicio )  values(?,?,?,?,?,?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{recomendacion.getIdCalificacion(), recomendacion.getIdModelo(), recomendacion.getNombreModelo(), recomendacion.getRecomendacion1(), recomendacion.getRecomendacion2(), recomendacion.getRecomendacion3(), recomendacion.getNotaQuimestres(), recomendacion.getIdUsuarioCreacion(), recomendacion.getTipoNovedad(), recomendacion.getRegAnioInicio()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarRecomendacion(Recomendacion recomendacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE recomendacion set recomendacion1 = ?, recomendacion2 = ?, recomendacion3 = ?, recomendacion_quimestre= ?, reg_anio_inicio= ?, tipo_novedad=?, id_usuario_creacion=?, id = ? where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{recomendacion.getRecomendacion1(), recomendacion.getRecomendacion2(), recomendacion.getRecomendacion3(), recomendacion.getNotaQuimestres(), recomendacion.getRegAnioInicio(), recomendacion.getTipoNovedad(), recomendacion.getIdUsuarioCreacion(), recomendacion.getId(), recomendacion.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    @Override
    public boolean actualizar(String valores, Integer id) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Recomendacion> obtenerPorParalelo(Integer idEscenario, Integer idEscenarioDiscrecion) throws Exception {
        ArrayList<Recomendacion> notas = new ArrayList<Recomendacion>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT r.id_aplicacion as idAplicacion , ");
            query.append(" r.id_modelo as idModelo,  ");
            query.append(" r.nombre_modelo as nombreModelo, ");
            query.append(" r.recomendacion1 as recomendacion1, ");
            query.append(" r.recomendacion2 as recomendacion2, ");
            query.append(" r.recomendacion3 as recomendacion3, ");
            query.append(" r.recomendacion_quimestre as notaQuimestres, ");
            query.append(" r.id as id, ");
            query.append(" r.reg_anio_inicio as regAnioInicio, ");
            query.append(" r.tipo_novedad as tipoNovedad, ");
            query.append(" r.id_usuario_creacion as idUsuarioCreacion, ");
            query.append(" c.id as idCalificacion ");
            query.append(" FROM recomendacion r ");
            query.append(" join calificacion c on c.id_aplicacion=r.id_calificacion ");
            query.append(" where  c.id_escenario=? ");
            if (idEscenarioDiscrecion == null || idEscenarioDiscrecion == 0) {
                query.append("and c.id_escenario_discrecion is null ");
            } else {
                query.append("and c.id_escenario_discrecion=? ");
            }
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idEscenario);
            if (idEscenarioDiscrecion != 0) {
                ps.setInt(2, idEscenarioDiscrecion);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Recomendacion reco = new Recomendacion();
                reco.setIdAplicacion(rs.getInt("idAplicacion"));
                reco.setIdModelo(rs.getInt("idModelo"));
                reco.setNombreModelo(rs.getString("nombreModelo"));
                reco.setRecomendacion1(rs.getString("recomendacion1"));
                reco.setRecomendacion2(rs.getString("recomendacion2"));
                reco.setRecomendacion3(rs.getString("recomendacion3"));
                reco.setNotaQuimestres(rs.getString("notaQuimestres"));
                reco.setId(rs.getInt("id"));
                reco.setRegAnioInicio(rs.getString("regAnioInicio"));
                reco.setTipoNovedad(rs.getString("tipoNovedad"));
                reco.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                reco.setIdCalificacion(rs.getInt("idCalificacion"));
                notas.add(reco);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return notas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarRecomendacionSincronizacion(Recomendacion nota) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE recomendacion set id= ?, codigo_error = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{nota.getId(), nota.getCodigoError(), nota.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Recomendacion> buscarTodo() {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(Recomendacion.class);
        ArrayList<Recomendacion> recomendacion = new ArrayList();
        try {
            recomendacion = (List)run.query(conn, " SELECT  r.id_aplicacion as idAplicacion,  r.id_modelo as idModelo,  r.nombre_modelo as nombreModelo, r.recomendacion1 as recomendacion1, r.recomendacion2 as recomendacion2,  r.recomendacion3 as recomendacion3, r.recomendacion_quimestre as notaQuimestres,  r.id as id, r.reg_anio_inicio as regAnioInicio, r.tipo_novedad as tipoNovedad, r.id_usuario_creacion as idUsuarioCreacion, c.id as idCalificacion FROM recomendacion r  join calificacion c on c.id_aplicacion=r.id_calificacion join instructor i on i.id=c.id_instructor ", (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return recomendacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaRecomendacion(List<Recomendacion> listaRecomendacion) throws Exception {
        if (null != listaRecomendacion && !listaRecomendacion.isEmpty()) {
            try {
                String sql = " INSERT INTO recomendacion(id, id_calificacion, id_modelo,nombre_modelo,recomendacion1,recomendacion2,recomendacion3,recomendacion_quimestre, id_usuario_creacion, tipo_novedad, reg_anio_inicio )  values(?,?,?,?,?,?,?,?,?,?,?)";
                this.Conectar();
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (Recomendacion recomendacion : listaRecomendacion) {
                    if (null == recomendacion) continue;
                    PreparedStatement psc = this.getConexion().prepareStatement("SELECT * FROM calificacion WHERE id =? ");
                    psc.setInt(1, recomendacion.getIdCalificacion());
                    ResultSet rsc = psc.executeQuery();
                    ps.setInt(1, recomendacion.getId());
                    ps.setInt(2, rsc.getInt("id_aplicacion"));
                    ps.setObject(3, (Object)recomendacion.getIdModelo(), 4);
                    ps.setString(4, "QUIMESTRAL");
                    ps.setString(5, recomendacion.getRecomendacion1());
                    ps.setString(6, recomendacion.getRecomendacion2());
                    ps.setString(7, recomendacion.getRecomendacion3());
                    ps.setString(8, recomendacion.getNotaQuimestres());
                    ps.setObject(9, (Object)recomendacion.getIdUsuarioCreacion(), 4);
                    ps.setString(10, recomendacion.getTipoNovedad());
                    ps.setString(11, recomendacion.getRegAnioInicio());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (Exception e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }
}

