/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Util.Util;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JLabel;

public class LabelLink
extends JLabel {
    private String text = "";
    private String TextLink = null;
    private URI uri;

    public LabelLink() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setVisible(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LabelLink.this.Abrir_URL(LabelLink.this.uri);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LabelLink.this.setText(LabelLink.this.text, false);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LabelLink.this.setText(LabelLink.this.text, true);
                LabelLink.this.repaint();
            }
        });
    }

    public void setLink(String link) {
        try {
            this.uri = new URI(link);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTextLink(String texto) {
        this.TextLink = texto;
    }

    @Override
    public void setText(String value) {
        this.setText(value, false);
    }

    public String getTextSinFormato() {
        return this.text;
    }

    private void setText(String text, boolean inout) {
        String css = "<style type='text/css'>.link {text-decoration: none;font-weight: bold;color:#000000;}.link_hover{color:rgb(255,0,0);text-decoration:underline;}</style>";
        String clase = inout ? "link" : "link_hover";
        String html_text = this.TextLink != null ? text.replace(this.TextLink, Util.concatena("<span class='", clase, "' >", this.TextLink, "</span>")) : text;
        super.setText(Util.concatena("<html>", css, "<span>", html_text, "<span/></html>"));
        this.text = text;
    }

    private void Abrir_URL(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            }
            catch (IOException e) {
                System.err.println("Error: No se pudo abrir el enlace" + e.getMessage());
            }
        } else {
            System.err.println("Error: Error de compatibilidad en la plataforma actual. No se puede abrir enlaces web.");
        }
    }
}

