/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.educacion.encripta;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class Encripta {
    Cipher desCipher;
    private SecretKey myDesKey;

    public Encripta(String key) {
        try {
            this.desCipher = Cipher.getInstance("AES");
            byte[] encoded = key.getBytes();
            this.myDesKey = new SecretKeySpec(encoded, "AES");
        }
        catch (Exception ex) {
            System.err.println("Error al iniciar Encripta " + ex.getMessage());
        }
    }

    protected Boolean encrypt(File inputFile, File outputFile) throws FileNotFoundException {
        return this.doCrypto(1, inputFile, outputFile);
    }

    protected Boolean decrypt(File inputFile, File outputFile) throws FileNotFoundException {
        return this.doCrypto(2, inputFile, outputFile);
    }

    protected Boolean doCrypto(int cipherMode, File inputFile, File outputFile) throws FileNotFoundException {
        Boolean exito = false;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(cipherMode, this.myDesKey);
            FileInputStream inputStream = new FileInputStream(inputFile);
            byte[] inputBytes = new byte[(int)inputFile.length()];
            inputStream.read(inputBytes);
            byte[] outputBytes = cipher.doFinal(inputBytes);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            outputStream.write(outputBytes);
            inputStream.close();
            outputStream.close();
            exito = true;
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            if (2 == cipherMode) {
                System.err.println("Error a desencriptar " + ex.getMessage());
            }
            System.err.println("Error a encriptar " + ex.getMessage());
        }
        return exito;
    }
}

