/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.educacion.encripta;

import ec.gob.educacion.encripta.Encripta;
import ec.gob.educacion.encripta.MD5;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Calendar;

public class UtilEncripta {
    public static Boolean encriptaArchivoBB(String url) {
        Boolean exito;
        block40: {
            exito = false;
            try {
                File archivoBB = new File(url);
                if (!archivoBB.isFile()) break block40;
                String key1 = String.valueOf(Calendar.getInstance().getTimeInMillis());
                String key = MD5.getMD5(key1);
                Encripta encripta = new Encripta(key = UtilEncripta.generaKeyEncriptar(key));
                if (!encripta.encrypt(archivoBB, archivoBB).booleanValue()) break block40;
                try (FileWriter fw = new FileWriter(url, true);
                     BufferedWriter bw = new BufferedWriter(fw);
                     PrintWriter out = new PrintWriter(bw);){
                    out.print(key1);
                }
                catch (IOException e) {
                    System.out.println("Ocurrio un error al encriptaArchivoBB guardar key " + e.getMessage());
                }
                exito = true;
            }
            catch (Exception e) {
                System.out.println("Ocurrio un error al encriptaArchivoBB " + e.getMessage());
            }
        }
        return exito;
    }

    public static Boolean desencriptaArchivoBB(String url) {
        Boolean exito;
        block16: {
            exito = false;
            int digitos = 13;
            try {
                File archivoBB = new File(url);
                if (!archivoBB.isFile()) break block16;
                ByteBuffer buffer = ByteBuffer.allocate(1024);
                FileChannel channel = FileChannel.open(Paths.get(url, new String[0]), StandardOpenOption.READ);
                channel.read(buffer, channel.size() - (long)digitos);
                String key1 = new String(buffer.array());
                key1 = key1.trim();
                if (!UtilEncripta.isLong(key1) || key1.length() != digitos) {
                    digitos = 15;
                    buffer = ByteBuffer.allocate(1024);
                    channel.read(buffer, channel.size() - (long)digitos);
                    key1 = new String(buffer.array());
                    key1 = key1.trim();
                }
                if (UtilEncripta.isLong(key1)) {
                    try (RandomAccessFile file = new RandomAccessFile(url, "rw");){
                        long length = file.length();
                        file.setLength(length - (long)digitos);
                    }
                    archivoBB = new File(url);
                    String key = MD5.getMD5(key1);
                    Encripta encripta = new Encripta(UtilEncripta.generaKeyEncriptar(key));
                    exito = encripta.decrypt(archivoBB, archivoBB);
                    break block16;
                }
                exito = Boolean.TRUE;
            }
            catch (Exception e) {
                System.out.println("Ocurrio un error al desencriptaArchivoBB " + e.getMessage());
            }
        }
        return exito;
    }

    private static String generaKeyEncriptar(String keyInicial) {
        String outKeyFinal = new String(keyInicial);
        Integer keySize = 16;
        if (keyInicial.length() > keySize) {
            outKeyFinal = outKeyFinal.substring(0, keySize);
        } else {
            for (int i = keyInicial.length() + 1; i <= keySize; ++i) {
                outKeyFinal = outKeyFinal + String.valueOf((char)(122 - i));
            }
        }
        return outKeyFinal;
    }

    public static boolean isLong(String input) {
        try {
            Long.parseLong(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

